/*
 * Decompiled with CFR 0.152.
 */
package com.aiup.api.config;

import com.aiup.service.domain.R;
import com.aiup.service.entity.UserInfo;
import com.aiup.service.utils.JwtUtils;
import com.aiup.service.utils.LoginUserUtils;
import com.alibaba.fastjson2.JSON;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("Authorization");
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (null == token || "".equals(token) || !JwtUtils.verify(token)) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            try (PrintWriter writer = response.getWriter();){
                R result = new R();
                result.setResult(-1);
                result.setErrorCode("401");
                result.setDescription("\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                writer.print(JSON.toJSONString(result));
            }
            catch (Exception e) {
                logger.error("login token error is {}", (Object)e.getMessage());
            }
            return false;
        }
        UserInfo user = JwtUtils.getUserByToken(token);
        LoginUserUtils.setLoginUser(user);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        System.out.println("\u6267\u884c\u4e86\u62e6\u622a\u5668\u7684postHandle\u65b9\u6cd5");
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        LoginUserUtils.removeUser();
    }
}

