/*
 * Decompiled with CFR 0.152.
 */
package com.aiup.api.controller;

import com.aiup.service.domain.R;
import com.aiup.service.domain.WxCodeSessionResult;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.query.WeChatLoginQuery;
import com.aiup.service.domain.response.WeChatLoginResponse;
import com.aiup.service.entity.UserInfo;
import com.aiup.service.service.UserInfoService;
import com.aiup.service.service.WeChatLoginService;
import com.aiup.service.utils.JwtUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private WeChatLoginService weChatLoginService;

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/getUserInfo"})
    public R<UserInfo> getUserInfo(@RequestBody UserInfoQuery query2) {
        return R.ok(this.userInfoService.queryById(query2.getUserId()));
    }

    @ApiOperation(value="\u5fae\u4fe1\u7528\u6237\u767b\u5f55")
    @PostMapping(value={"/weChatLogin"})
    public R<WeChatLoginResponse> weChatLogin(@Validated @RequestBody WeChatLoginQuery query2) {
        WxCodeSessionResult openIdByCode = this.weChatLoginService.getOpenIdByCode(query2.getCode());
        if (openIdByCode.getErrcode() != 0) {
            return R.error(openIdByCode.getErrcode(), "\u6388\u6743\u767b\u5f55\u5931\u8d25");
        }
        UserInfo userInfo = this.userInfoService.queryByOpenId(openIdByCode.getOpenid());
        if (userInfo == null) {
            userInfo = new UserInfo();
            userInfo.setOpenId(openIdByCode.getOpenid());
            userInfo.setCreateTime(new Date());
            userInfo = this.userInfoService.insert(userInfo);
        } else {
            userInfo = this.userInfoService.update(userInfo);
        }
        String sign = JwtUtils.sign(userInfo);
        Date expireTime = JwtUtils.getExpireByToken(sign);
        WeChatLoginResponse response = new WeChatLoginResponse();
        response.setLoginUserInfo(userInfo);
        response.setToken(sign);
        response.setTokenExpireTime(expireTime.getTime());
        return R.ok(response);
    }
}

