/*
 * Decompiled with CFR 0.152.
 */
package com.aiup.service.utils;

import com.aiup.service.entity.UserInfo;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class JwtUtils {
    public static final long EXPIRE_TIME = 86400000L;
    public static final String SECRET = "SECRET_Yunzhongyu_AiUp";

    public static String sign(UserInfo user) {
        Date expireDate = new Date(System.currentTimeMillis() + 86400000L);
        return JWT.create().withClaim("account", user.getUserId()).withClaim("userName", user.getUserName()).withClaim("openId", user.getOpenId()).withExpiresAt(expireDate).sign(Algorithm.HMAC256(SECRET));
    }

    public static boolean verify(String token) {
        try {
            JWTVerifier verifier = JWT.require(Algorithm.HMAC256(SECRET)).build();
            DecodedJWT decodedJWT = verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getUserNameByToken(String token) {
        DecodedJWT decodedJWT = JWT.decode(token);
        return decodedJWT.getClaim("userName").asString();
    }

    public static Date getExpireByToken(String token) {
        DecodedJWT decodedJWT = JWT.decode(token);
        Date date = decodedJWT.getExpiresAt();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(12, -5);
        date = calendar.getTime();
        return date;
    }

    public static String getOpenIdByToken(String token) {
        DecodedJWT decodedJWT = JWT.decode(token);
        return decodedJWT.getClaim("openId").asString();
    }

    public static UserInfo getUserByToken(String token) {
        DecodedJWT decodedJWT = JWT.decode(token);
        UserInfo user = new UserInfo();
        user.setUserName(decodedJWT.getClaim("userName").asString());
        user.setUserId(decodedJWT.getClaim("account").asInt());
        user.setOpenId(decodedJWT.getClaim("openId").asString());
        return user;
    }
}

