/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public final class SQLZOrderBy
extends SQLObjectImpl
implements SQLReplaceable {
    protected final List<SQLSelectOrderByItem> items = new ArrayList<SQLSelectOrderByItem>();
    private boolean sibings;

    public SQLZOrderBy() {
    }

    public SQLZOrderBy(SQLExpr expr) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr);
        this.addItem(item);
    }

    public SQLZOrderBy(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem(expr, type);
        this.addItem(item);
    }

    public void addItem(SQLSelectOrderByItem item) {
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(item);
    }

    public void addItem(SQLExpr item) {
        this.addItem(new SQLSelectOrderByItem(item));
    }

    public List<SQLSelectOrderByItem> getItems() {
        return this.items;
    }

    public boolean isSibings() {
        return this.sibings;
    }

    public void setSibings(boolean sibings) {
        this.sibings = sibings;
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            for (int i2 = 0; i2 < this.items.size(); ++i2) {
                SQLSelectOrderByItem item = this.items.get(i2);
                item.accept(v);
            }
        }
        v.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLZOrderBy order = (SQLZOrderBy)o;
        if (this.sibings != order.sibings) {
            return false;
        }
        return this.items.equals(order.items);
    }

    public int hashCode() {
        int result = this.items.hashCode();
        result = 31 * result + (this.sibings ? 1 : 0);
        return result;
    }

    public void addItem(SQLExpr expr, SQLOrderingSpecification type) {
        SQLSelectOrderByItem item = this.createItem();
        item.setExpr(expr);
        item.setType(type);
        this.addItem(item);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        for (SQLSelectOrderByItem item : this.items) {
            if (!item.replace(expr, target)) continue;
            return true;
        }
        return false;
    }

    protected SQLSelectOrderByItem createItem() {
        return new SQLSelectOrderByItem();
    }

    @Override
    public SQLZOrderBy clone() {
        SQLZOrderBy x = new SQLZOrderBy();
        for (SQLSelectOrderByItem item : this.items) {
            SQLSelectOrderByItem item1 = item.clone();
            item1.setParent(x);
            x.items.add(item1);
        }
        x.sibings = this.sibings;
        return x;
    }
}

