/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class SQLBinaryOpExprGroup
extends SQLExprImpl
implements SQLReplaceable {
    private final SQLBinaryOperator operator;
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    private DbType dbType;

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    public SQLBinaryOpExprGroup(SQLBinaryOperator operator, DbType dbType) {
        this.operator = operator;
        this.dbType = dbType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLBinaryOpExprGroup that = (SQLBinaryOpExprGroup)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.items.equals(that.items);
    }

    @Override
    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + this.items.hashCode();
        return result;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            for (int i2 = 0; i2 < this.items.size(); ++i2) {
                SQLExpr item = this.items.get(i2);
                item.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public SQLExpr clone() {
        SQLBinaryOpExprGroup x = new SQLBinaryOpExprGroup(this.operator);
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(this);
            x.items.add(item2);
        }
        return x;
    }

    public List getChildren() {
        return this.items;
    }

    public void add(SQLExpr item) {
        this.add(this.items.size(), item);
    }

    public void add(int index, SQLExpr item) {
        if (item instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)item;
            if (binaryOpExpr.getOperator() == this.operator) {
                this.add(binaryOpExpr.getLeft());
                this.add(binaryOpExpr.getRight());
                return;
            }
        } else if (item instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)item;
            if (group.operator == this.operator) {
                for (SQLExpr sqlExpr : group.getItems()) {
                    this.add(sqlExpr);
                }
                return;
            }
        }
        if (item != null) {
            item.setParent(this);
        }
        this.items.add(index, item);
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString((SQLObject)this, this.dbType);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        boolean replaced = false;
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            if (this.items.get(i2) != expr) continue;
            if (target == null) {
                this.items.remove(i2);
            } else if (target instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)target).getOperator() == this.operator) {
                this.items.remove(i2);
                List<SQLExpr> list = SQLBinaryOpExpr.split(target, this.operator);
                for (int j = 0; j < list.size(); ++j) {
                    SQLExpr o = list.get(j);
                    o.setParent(this);
                    this.items.add(i2 + j, o);
                }
            } else {
                target.setParent(this);
                this.items.set(i2, target);
            }
            replaced = true;
        }
        if (this.items.size() == 1 && replaced) {
            SQLUtils.replaceInParent(this, this.items.get(0));
        }
        if (this.items.size() == 0) {
            SQLUtils.replaceInParent(this, null);
        }
        return replaced;
    }

    public void optimize() {
        int i2;
        ArrayList<Integer> dupIndexList = null;
        LinkedHashSet<SQLExpr> itemSet = new LinkedHashSet<SQLExpr>();
        for (i2 = 0; i2 < this.items.size(); ++i2) {
            if (itemSet.add(this.items.get(i2))) continue;
            if (dupIndexList == null) {
                dupIndexList = new ArrayList<Integer>();
            }
            dupIndexList.add(i2);
        }
        if (dupIndexList != null) {
            for (i2 = dupIndexList.size() - 1; i2 >= 0; --i2) {
                int index = (Integer)dupIndexList.get(i2);
                this.items.remove(index);
            }
        }
    }
}

