/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLPartitionByHash;
import com.alibaba.druid.sql.ast.SQLPartitionByList;
import com.alibaba.druid.sql.ast.SQLPartitionByRange;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLSubPartition;
import com.alibaba.druid.sql.ast.SQLSubPartitionByHash;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDbLinkExpr;
import com.alibaba.druid.sql.ast.expr.SQLExprUtils;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterOutlineStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAnalyzePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableArchivePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCheckPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableCoalescePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableConvertCharSet;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDiscardPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableImportPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableMergePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableOptimizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReOrganizePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRebuildPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRepairPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetOption;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTruncatePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTypeStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLAnalyzeTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloneTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCopyFromStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateOutlineStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateRoleStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDefault;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropCatalogStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropOutlineStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropRoleStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSynonymStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTypeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDumpStatement;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExportTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLImportTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLPartitionRef;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLRefreshMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowDatabasesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.druid.sql.ast.statement.SQLShowTableGroupsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowViewsStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSyncMetaStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExpr;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleExpr;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitorAdapter;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaStatVisitor
extends SQLASTVisitorAdapter {
    protected SchemaRepository repository;
    protected final List<SQLName> originalTables = new ArrayList<SQLName>();
    protected final HashMap<TableStat.Name, TableStat> tableStats = new LinkedHashMap<TableStat.Name, TableStat>();
    protected final Map<Long, TableStat.Column> columns = new LinkedHashMap<Long, TableStat.Column>();
    protected final List<TableStat.Condition> conditions = new ArrayList<TableStat.Condition>();
    protected final Set<TableStat.Relationship> relationships = new LinkedHashSet<TableStat.Relationship>();
    protected final List<TableStat.Column> orderByColumns = new ArrayList<TableStat.Column>();
    protected final Set<TableStat.Column> groupByColumns = new LinkedHashSet<TableStat.Column>();
    protected final List<SQLAggregateExpr> aggregateFunctions = new ArrayList<SQLAggregateExpr>();
    protected final List<SQLMethodInvokeExpr> functions = new ArrayList<SQLMethodInvokeExpr>(2);
    private List<Object> parameters;
    private TableStat.Mode mode;
    protected DbType dbType;

    public SchemaStatVisitor() {
        this((DbType)null);
    }

    public SchemaStatVisitor(SchemaRepository repository) {
        if (repository != null) {
            this.dbType = repository.getDbType();
        }
        this.repository = repository;
    }

    public SchemaStatVisitor(DbType dbType) {
        this(new SchemaRepository(dbType), new ArrayList<Object>());
        this.dbType = dbType;
    }

    public SchemaStatVisitor(List<Object> parameters) {
        this((DbType)null, parameters);
    }

    public SchemaStatVisitor(DbType dbType, List<Object> parameters) {
        this(new SchemaRepository(dbType), parameters);
        this.parameters = parameters;
    }

    public SchemaStatVisitor(SchemaRepository repository, List<Object> parameters) {
        DbType dbType;
        this.repository = repository;
        this.parameters = parameters;
        if (repository != null && (dbType = repository.getDbType()) != null && this.dbType == null) {
            this.dbType = dbType;
        }
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SchemaRepository repository) {
        this.repository = repository;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public TableStat getTableStat(String tableName) {
        TableStat.Name tableNameObj = new TableStat.Name(tableName = this.handleName(tableName));
        TableStat stat = this.tableStats.get(tableNameObj);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(tableName), stat);
        }
        return stat;
    }

    public TableStat getTableStat(SQLName tableName) {
        String strName = tableName instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)tableName).normalizedName() : (tableName instanceof SQLPropertyExpr ? ((SQLPropertyExpr)tableName).normalizedName() : tableName.toString());
        long hashCode64 = tableName.hashCode64();
        if (hashCode64 == FnvHash.Constants.DUAL) {
            return null;
        }
        this.originalTables.add(tableName);
        TableStat.Name tableNameObj = new TableStat.Name(strName, hashCode64);
        TableStat stat = this.tableStats.get(tableNameObj);
        if (stat == null) {
            stat = new TableStat();
            this.tableStats.put(new TableStat.Name(strName, hashCode64), stat);
        }
        return stat;
    }

    protected TableStat.Column addColumn(String tableName, String columnName) {
        TableStat.Column c = new TableStat.Column(tableName, columnName, this.dbType);
        TableStat.Column column = this.columns.get(c.hashCode64());
        if (column == null && columnName != null) {
            column = c;
            this.columns.put(c.hashCode64(), c);
        }
        return column;
    }

    protected TableStat.Column addColumn(SQLName table, String columnName) {
        long tableHashCode64;
        String tableName = table instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)table).normalizedName() : (table instanceof SQLPropertyExpr ? ((SQLPropertyExpr)table).normalizedName() : table.toString());
        long basic = tableHashCode64 = table.hashCode64();
        basic ^= 0x2EL;
        long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, columnName);
        TableStat.Column column = this.columns.get(columnHashCode64);
        if (column == null && columnName != null) {
            column = new TableStat.Column(tableName, columnName, columnHashCode64);
            this.columns.put(columnHashCode64, column);
        }
        return column;
    }

    private String handleName(String ident) {
        int len = ident.length();
        if (ident.charAt(0) == '[' && ident.charAt(len - 1) == ']') {
            ident = ident.substring(1, len - 1);
        } else {
            boolean flag0 = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            for (int i2 = 0; i2 < len; ++i2) {
                char ch = ident.charAt(i2);
                if (ch == '\"') {
                    flag0 = true;
                    continue;
                }
                if (ch == '`') {
                    flag1 = true;
                    continue;
                }
                if (ch == ' ') {
                    flag2 = true;
                    continue;
                }
                if (ch != '\'') continue;
                flag3 = true;
            }
            if (flag0) {
                ident = ident.replaceAll("\"", "");
            }
            if (flag1) {
                ident = ident.replaceAll("`", "");
            }
            if (flag2) {
                ident = ident.replaceAll(" ", "");
            }
            if (flag3) {
                ident = ident.replaceAll("'", "");
            }
        }
        return ident;
    }

    protected TableStat.Mode getMode() {
        return this.mode;
    }

    protected void setModeOrigin(SQLObject x) {
        TableStat.Mode originalMode;
        this.mode = originalMode = (TableStat.Mode)((Object)x.getAttribute("_original_use_mode"));
    }

    protected TableStat.Mode setMode(SQLObject x, TableStat.Mode mode) {
        TableStat.Mode oldMode = this.mode;
        x.putAttribute("_original_use_mode", (Object)oldMode);
        this.mode = mode;
        return oldMode;
    }

    private boolean visitOrderBy(SQLIdentifierExpr x) {
        String tableName;
        block18: {
            block20: {
                SQLName tableExpr;
                block21: {
                    SQLTableSource tableSource;
                    block16: {
                        SQLMethodInvokeExpr methodInvokeExpr;
                        SQLExpr expr;
                        block19: {
                            SQLExprImpl table;
                            block17: {
                                SQLSelectQueryBlock queryBlock;
                                SQLSelectItem selectItem;
                                tableSource = x.getResolvedTableSource();
                                if (tableSource == null && x.getParent() instanceof SQLSelectOrderByItem && x.getParent().getParent() instanceof SQLOrderBy && x.getParent().getParent().getParent() instanceof SQLSelectQueryBlock && (selectItem = (queryBlock = (SQLSelectQueryBlock)x.getParent().getParent().getParent()).findSelectItem(x.nameHashCode64())) != null) {
                                    SQLExpr selectItemExpr = selectItem.getExpr();
                                    if (selectItemExpr instanceof SQLIdentifierExpr) {
                                        x = (SQLIdentifierExpr)selectItemExpr;
                                    } else {
                                        if (selectItemExpr instanceof SQLPropertyExpr) {
                                            return this.visitOrderBy((SQLPropertyExpr)selectItemExpr);
                                        }
                                        return false;
                                    }
                                }
                                tableName = null;
                                if (!(tableSource instanceof SQLExprTableSource)) break block16;
                                expr = ((SQLExprTableSource)tableSource).getExpr();
                                if (!(expr instanceof SQLIdentifierExpr)) break block17;
                                table = (SQLIdentifierExpr)expr;
                                tableName = ((SQLIdentifierExpr)table).getName();
                                break block18;
                            }
                            if (!(expr instanceof SQLPropertyExpr)) break block19;
                            table = (SQLPropertyExpr)expr;
                            tableName = ((SQLPropertyExpr)table).toString();
                            break block18;
                        }
                        if (!(expr instanceof SQLMethodInvokeExpr) || !"table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) || methodInvokeExpr.getArguments().size() != 1 || !(methodInvokeExpr.getArguments().get(0) instanceof SQLName)) break block18;
                        SQLName table = (SQLName)methodInvokeExpr.getArguments().get(0);
                        if (table instanceof SQLPropertyExpr) {
                            SQLExpr resolveExpr;
                            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table;
                            SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                            if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                                tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                            }
                        }
                        if (tableName != null) break block18;
                        tableName = table.toString();
                        break block18;
                    }
                    if (tableSource instanceof SQLWithSubqueryClause.Entry) {
                        return false;
                    }
                    if (!(tableSource instanceof SQLSubqueryTableSource)) break block20;
                    SQLSelectQueryBlock queryBlock = ((SQLSubqueryTableSource)tableSource).getSelect().getQueryBlock();
                    if (queryBlock == null) {
                        return false;
                    }
                    SQLSelectItem selectItem = queryBlock.findSelectItem(x.nameHashCode64());
                    if (selectItem == null) {
                        return false;
                    }
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    SQLTableSource columnTableSource = null;
                    if (selectItemExpr instanceof SQLIdentifierExpr) {
                        columnTableSource = ((SQLIdentifierExpr)selectItemExpr).getResolvedTableSource();
                    } else if (selectItemExpr instanceof SQLPropertyExpr) {
                        columnTableSource = ((SQLPropertyExpr)selectItemExpr).getResolvedTableSource();
                    }
                    if (!(columnTableSource instanceof SQLExprTableSource) || !(((SQLExprTableSource)columnTableSource).getExpr() instanceof SQLName)) break block18;
                    tableExpr = (SQLName)((SQLExprTableSource)columnTableSource).getExpr();
                    if (!(tableExpr instanceof SQLIdentifierExpr)) break block21;
                    tableName = ((SQLIdentifierExpr)tableExpr).normalizedName();
                    break block18;
                }
                if (!(tableExpr instanceof SQLPropertyExpr)) break block18;
                tableName = ((SQLPropertyExpr)tableExpr).normalizedName();
                break block18;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof SQLValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
        }
        String identName = x.getName();
        if (tableName != null) {
            this.orderByAddColumn(tableName, identName, x);
        } else {
            this.orderByAddColumn("UNKNOWN", identName, x);
        }
        return false;
    }

    private boolean visitOrderBy(SQLPropertyExpr x) {
        SQLExpr tableSourceExpr;
        if (this.isSubQueryOrParamOrVariant(x)) {
            return false;
        }
        String owner = null;
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLName) {
            owner = tableSourceExpr.toString();
        }
        if (owner == null && x.getOwner() instanceof SQLIdentifierExpr) {
            owner = ((SQLIdentifierExpr)x.getOwner()).getName();
        }
        if (owner == null) {
            return false;
        }
        this.orderByAddColumn(owner, x.getName(), x);
        return false;
    }

    private boolean visitOrderBy(SQLIntegerExpr x) {
        SQLObject parent = x.getParent();
        if (!(parent instanceof SQLSelectOrderByItem)) {
            return false;
        }
        if (parent.getParent() instanceof SQLSelectQueryBlock) {
            int selectItemIndex = x.getNumber().intValue() - 1;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent.getParent();
            List<SQLSelectItem> selectList = queryBlock.getSelectList();
            if (selectItemIndex < 0 || selectItemIndex >= selectList.size()) {
                return false;
            }
            SQLExpr selectItemExpr = selectList.get(selectItemIndex).getExpr();
            if (selectItemExpr instanceof SQLIdentifierExpr) {
                this.visitOrderBy((SQLIdentifierExpr)selectItemExpr);
            } else if (selectItemExpr instanceof SQLPropertyExpr) {
                this.visitOrderBy((SQLPropertyExpr)selectItemExpr);
            }
        }
        return false;
    }

    private void orderByAddColumn(String table, String columnName, SQLObject expr) {
        TableStat.Column column = new TableStat.Column(table, columnName, this.dbType);
        SQLObject parent = expr.getParent();
        if (parent instanceof SQLSelectOrderByItem) {
            SQLOrderingSpecification type = ((SQLSelectOrderByItem)parent).getType();
            column.getAttributes().put("orderBy.type", (Object)type);
        }
        this.orderByColumns.add(column);
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        SQLASTVisitor orderByVisitor = this.createOrderByVisitor(x);
        SQLSelectQueryBlock query2 = null;
        if (x.getParent() instanceof SQLSelectQueryBlock) {
            query2 = (SQLSelectQueryBlock)x.getParent();
        }
        if (query2 != null) {
            for (SQLSelectOrderByItem item : x.getItems()) {
                SQLExpr expr = item.getExpr();
                if (expr instanceof SQLIntegerExpr) {
                    int intValue = ((SQLIntegerExpr)expr).getNumber().intValue() - 1;
                    if (intValue >= query2.getSelectList().size()) continue;
                    SQLExpr selectItemExpr = query2.getSelectList().get(intValue).getExpr();
                    selectItemExpr.accept(orderByVisitor);
                    continue;
                }
                if (!(expr instanceof MySqlExpr) && !(expr instanceof OracleExpr)) continue;
            }
        }
        x.accept(orderByVisitor);
        for (SQLSelectOrderByItem orderByItem : x.getItems()) {
            this.statExpr(orderByItem.getExpr());
        }
        return false;
    }

    @Override
    public boolean visit(SQLOver x) {
        SQLName of = x.getOf();
        SQLOrderBy orderBy = x.getOrderBy();
        List<SQLExpr> partitionBy = x.getPartitionBy();
        if (of == null && orderBy != null) {
            orderBy.accept(this);
        }
        if (partitionBy != null) {
            for (SQLExpr expr : partitionBy) {
                expr.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLWindow x) {
        SQLOver over = x.getOver();
        if (over != null) {
            this.visit(over);
        }
        return false;
    }

    protected SQLASTVisitor createOrderByVisitor(SQLOrderBy x) {
        if (this.dbType == null) {
            this.dbType = DbType.other;
        }
        switch (this.dbType) {
            case mysql: 
            case mariadb: 
            case tidb: {
                return new MySqlOrderByStatVisitor(x);
            }
            case postgresql: {
                return new PGOrderByStatVisitor(x);
            }
            case oracle: {
                return new OracleOrderByStatVisitor(x);
            }
        }
        return new OrderByStatVisitor(x);
    }

    public Set<TableStat.Relationship> getRelationships() {
        return this.relationships;
    }

    public List<TableStat.Column> getOrderByColumns() {
        return this.orderByColumns;
    }

    public Set<TableStat.Column> getGroupByColumns() {
        return this.groupByColumns;
    }

    public List<TableStat.Condition> getConditions() {
        return this.conditions;
    }

    public List<SQLAggregateExpr> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    @Override
    public boolean visit(SQLBetweenExpr x) {
        SQLObject parent = x.getParent();
        SQLExpr test = x.getTestExpr();
        SQLExpr begin = x.getBeginExpr();
        SQLExpr end = x.getEndExpr();
        this.statExpr(test);
        this.statExpr(begin);
        this.statExpr(end);
        this.handleCondition(test, "BETWEEN", begin, end);
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLObject parent = x.getParent();
        if (parent instanceof SQLIfStatement) {
            return true;
        }
        SQLBinaryOperator op = x.getOperator();
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        if ((op == SQLBinaryOperator.BooleanAnd || op == SQLBinaryOperator.BooleanOr) && left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == op) {
            List<SQLExpr> groupList = SQLBinaryOpExpr.split(x, op);
            for (int i2 = 0; i2 < groupList.size(); ++i2) {
                SQLExpr item = groupList.get(i2);
                item.accept(this);
            }
            return false;
        }
        switch (op) {
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case Equality: 
            case NotEqual: 
            case LessThanOrGreater: 
            case LessThanOrEqualOrGreaterThan: 
            case SoudsLike: 
            case Like: 
            case NotLike: 
            case Is: 
            case IsNot: {
                this.handleCondition(left, op.name, right);
                String reverseOp = op.name;
                switch (op) {
                    case LessThan: {
                        reverseOp = SQLBinaryOperator.GreaterThan.name;
                        break;
                    }
                    case LessThanOrEqual: {
                        reverseOp = SQLBinaryOperator.GreaterThanOrEqual.name;
                        break;
                    }
                    case GreaterThan: {
                        reverseOp = SQLBinaryOperator.LessThan.name;
                        break;
                    }
                    case GreaterThanOrEqual: {
                        reverseOp = SQLBinaryOperator.LessThanOrEqual.name;
                        break;
                    }
                }
                this.handleCondition(right, reverseOp, left);
                this.handleRelationship(left, op.name, right);
                break;
            }
            case BooleanOr: {
                List<SQLExpr> list = SQLBinaryOpExpr.split(x, op);
                for (SQLExpr item : list) {
                    if (item instanceof SQLBinaryOpExpr) {
                        this.visit((SQLBinaryOpExpr)item);
                        continue;
                    }
                    item.accept(this);
                }
                return false;
            }
            case Modulus: {
                long hashCode64;
                if (!(right instanceof SQLIdentifierExpr) || (hashCode64 = ((SQLIdentifierExpr)right).hashCode64()) != FnvHash.Constants.ISOPEN) break;
                left.accept(this);
                return false;
            }
        }
        if (left instanceof SQLBinaryOpExpr) {
            this.visit((SQLBinaryOpExpr)left);
        } else {
            this.statExpr(left);
        }
        this.statExpr(right);
        return false;
    }

    protected void handleRelationship(SQLExpr left, String operator, SQLExpr right) {
        TableStat.Column leftColumn = this.getColumn(left);
        if (leftColumn == null) {
            return;
        }
        TableStat.Column rightColumn = this.getColumn(right);
        if (rightColumn == null) {
            return;
        }
        TableStat.Relationship relationship = new TableStat.Relationship(leftColumn, rightColumn, operator);
        this.relationships.add(relationship);
    }

    protected void handleCondition(SQLExpr expr, String operator, List<SQLExpr> values) {
        this.handleCondition(expr, operator, values.toArray(new SQLExpr[values.size()]));
    }

    protected void handleCondition(SQLExpr expr, String operator, SQLExpr ... valueExprs) {
        if (expr instanceof SQLCastExpr) {
            expr = ((SQLCastExpr)expr).getExpr();
        } else if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr func = (SQLMethodInvokeExpr)expr;
            List<SQLExpr> arguments = func.getArguments();
            if (func.methodNameHashCode64() == FnvHash.Constants.COALESCE && arguments.size() > 0) {
                boolean allLiteral = true;
                for (int i2 = 1; i2 < arguments.size(); ++i2) {
                    SQLExpr arg = arguments.get(i2);
                    if (arg instanceof SQLLiteralExpr) continue;
                    allLiteral = false;
                }
                if (allLiteral) {
                    expr = arguments.get(0);
                }
            }
        }
        TableStat.Column column = this.getColumn(expr);
        if (column == null && expr instanceof SQLBinaryOpExpr && valueExprs.length == 1 && valueExprs[0] instanceof SQLLiteralExpr) {
            SQLBinaryOpExpr left = (SQLBinaryOpExpr)expr;
            SQLLiteralExpr right = (SQLLiteralExpr)valueExprs[0];
            if (left.getRight() instanceof SQLIntegerExpr && right instanceof SQLIntegerExpr) {
                long v;
                long v0 = ((SQLIntegerExpr)left.getRight()).getNumber().longValue();
                long v1 = ((SQLIntegerExpr)right).getNumber().longValue();
                SQLBinaryOperator op = left.getOperator();
                switch (op) {
                    case Add: {
                        v = v1 - v0;
                        break;
                    }
                    case Subtract: {
                        v = v1 + v0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.handleCondition(left.getLeft(), operator, new SQLIntegerExpr(v));
                return;
            }
        }
        if (column == null) {
            return;
        }
        TableStat.Condition condition = null;
        for (TableStat.Condition item : this.getConditions()) {
            if (!item.getColumn().equals(column) || !item.getOperator().equals(operator)) continue;
            condition = item;
            break;
        }
        if (condition == null) {
            condition = new TableStat.Condition(column, operator);
            this.conditions.add(condition);
        }
        for (SQLExpr item : valueExprs) {
            Object value;
            TableStat.Column valueColumn = this.getColumn(item);
            if (valueColumn != null) continue;
            if (item instanceof SQLCastExpr) {
                item = ((SQLCastExpr)item).getExpr();
            }
            if (item instanceof SQLMethodInvokeExpr || item instanceof SQLCurrentTimeExpr) {
                value = item.toString();
            } else {
                value = SQLEvalVisitorUtils.eval(this.dbType, (SQLObject)item, this.parameters, false);
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    value = null;
                }
            }
            condition.addValue(value);
        }
    }

    public DbType getDbType() {
        return this.dbType;
    }

    protected TableStat.Column getColumn(SQLExpr expr) {
        SQLExpr original = expr;
        if ((expr = this.unwrapExpr(expr)) instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
            SQLExpr owner = propertyExpr.getOwner();
            String column = SQLUtils.normalize(propertyExpr.getName());
            if (owner instanceof SQLName) {
                SQLName table = (SQLName)owner;
                SQLObject resolvedOwnerObject = propertyExpr.getResolvedOwnerObject();
                if (resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLCreateProcedureStatement || resolvedOwnerObject instanceof SQLCreateFunctionStatement) {
                    table = null;
                }
                if (resolvedOwnerObject instanceof SQLExprTableSource) {
                    SQLExpr tableSourceExpr = ((SQLExprTableSource)resolvedOwnerObject).getExpr();
                    if (tableSourceExpr instanceof SQLName) {
                        table = (SQLName)tableSourceExpr;
                    }
                } else if (resolvedOwnerObject instanceof SQLValuesTableSource) {
                    return null;
                }
                if (table != null) {
                    SQLColumnDefinition columnDef;
                    SchemaObject schemaObject;
                    String tableName = table instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)table).normalizedName() : (table instanceof SQLPropertyExpr ? ((SQLPropertyExpr)table).normalizedName() : table.toString());
                    long tableHashCode64 = table.hashCode64();
                    if (resolvedOwnerObject instanceof SQLExprTableSource && (schemaObject = ((SQLExprTableSource)resolvedOwnerObject).getSchemaObject()) != null && schemaObject.getStatement() instanceof SQLCreateTableStatement && (columnDef = schemaObject.findColumn(propertyExpr.nameHashCode64())) == null) {
                        tableName = "UNKNOWN";
                        tableHashCode64 = FnvHash.Constants.UNKNOWN;
                    }
                    long basic = tableHashCode64;
                    basic ^= 0x2EL;
                    long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, column);
                    TableStat.Column columnObj = this.columns.get(columnHashCode64);
                    if (columnObj == null) {
                        columnObj = new TableStat.Column(tableName, column, columnHashCode64);
                        if (!(resolvedOwnerObject instanceof SQLSubqueryTableSource) && !(resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry)) {
                            this.columns.put(columnHashCode64, columnObj);
                        }
                    }
                    return columnObj;
                }
            }
            return null;
        }
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            if (identifierExpr.getResolvedParameter() != null) {
                return null;
            }
            if (identifierExpr.getResolvedTableSource() instanceof SQLSubqueryTableSource) {
                return null;
            }
            if (identifierExpr.getResolvedDeclareItem() != null || identifierExpr.getResolvedParameter() != null) {
                return null;
            }
            String column = identifierExpr.getName();
            SQLName table = null;
            SQLTableSource tableSource = identifierExpr.getResolvedTableSource();
            if (tableSource instanceof SQLExprTableSource) {
                SQLExpr tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr();
                if (tableSourceExpr != null && !(tableSourceExpr instanceof SQLName)) {
                    tableSourceExpr = this.unwrapExpr(tableSourceExpr);
                }
                if (tableSourceExpr instanceof SQLName) {
                    table = (SQLName)tableSourceExpr;
                }
            }
            if (table != null) {
                long tableHashCode64;
                long basic = tableHashCode64 = table.hashCode64();
                basic ^= 0x2EL;
                long columnHashCode64 = FnvHash.hashCode64(basic *= 1099511628211L, column);
                TableStat.Column old = this.columns.get(columnHashCode64);
                if (old != null) {
                    return old;
                }
                return new TableStat.Column(table.toString(), column, columnHashCode64);
            }
            return new TableStat.Column("UNKNOWN", column);
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
            List<SQLExpr> arguments = methodInvokeExpr.getArguments();
            long nameHash = methodInvokeExpr.methodNameHashCode64();
            if (nameHash == FnvHash.Constants.DATE_FORMAT && arguments.size() == 2 && arguments.get(0) instanceof SQLName && arguments.get(1) instanceof SQLCharExpr) {
                return this.getColumn(arguments.get(0));
            }
        }
        return null;
    }

    private SQLExpr unwrapExpr(SQLExpr expr) {
        SQLExpr original = expr;
        int i2 = 0;
        while (true) {
            SQLMethodInvokeExpr methodInvokeExp;
            if (i2 > 1000) {
                return null;
            }
            if (expr instanceof SQLMethodInvokeExpr && (methodInvokeExp = (SQLMethodInvokeExpr)expr).getArguments().size() == 1) {
                SQLExpr firstExpr;
                expr = firstExpr = methodInvokeExp.getArguments().get(0);
            } else if (expr instanceof SQLCastExpr) {
                expr = ((SQLCastExpr)expr).getExpr();
            } else {
                if (!(expr instanceof SQLPropertyExpr)) break;
                SQLPropertyExpr propertyExpr = (SQLPropertyExpr)expr;
                SQLTableSource resolvedTableSource = propertyExpr.getResolvedTableSource();
                if (resolvedTableSource instanceof SQLSubqueryTableSource) {
                    SQLExpr other;
                    SQLSelect select = ((SQLSubqueryTableSource)resolvedTableSource).getSelect();
                    SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
                    if (queryBlock == null || queryBlock.getGroupBy() != null && original.getParent() instanceof SQLBinaryOpExpr && !SQLExprUtils.isLiteralExpr(other = ((SQLBinaryOpExpr)original.getParent()).other(original))) break;
                    SQLSelectItem selectItem = queryBlock.findSelectItem(propertyExpr.nameHashCode64());
                    if (selectItem != null) {
                        SQLExpr selectItemExpr = selectItem.getExpr();
                        if (selectItemExpr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)selectItemExpr).getArguments().size() == 1) {
                            selectItemExpr = ((SQLMethodInvokeExpr)selectItemExpr).getArguments().get(0);
                        }
                        if (selectItemExpr == expr) break;
                        expr = selectItemExpr;
                    } else {
                        if (!queryBlock.selectItemHasAllColumn()) break;
                        SQLTableSource allColumnTableSource = null;
                        SQLTableSource from = queryBlock.getFrom();
                        if (from instanceof SQLJoinTableSource) {
                            SQLExpr owner;
                            SQLSelectItem allColumnSelectItem = queryBlock.findAllColumnSelectItem();
                            if (allColumnSelectItem != null && allColumnSelectItem.getExpr() instanceof SQLPropertyExpr && (owner = ((SQLPropertyExpr)allColumnSelectItem.getExpr()).getOwner()) instanceof SQLName) {
                                allColumnTableSource = from.findTableSource(((SQLName)owner).nameHashCode64());
                            }
                        } else {
                            allColumnTableSource = from;
                        }
                        if (allColumnTableSource == null) break;
                        propertyExpr = propertyExpr.clone();
                        propertyExpr.setResolvedTableSource(allColumnTableSource);
                        if (allColumnTableSource instanceof SQLExprTableSource) {
                            propertyExpr.setOwner(((SQLExprTableSource)allColumnTableSource).getExpr().clone());
                        }
                        expr = propertyExpr;
                    }
                } else {
                    SQLExprTableSource exprTableSource;
                    if (!(resolvedTableSource instanceof SQLExprTableSource) || (exprTableSource = (SQLExprTableSource)resolvedTableSource).getSchemaObject() != null) break;
                    SQLTableSource redirectTableSource = null;
                    SQLExpr tableSourceExpr = exprTableSource.getExpr();
                    if (tableSourceExpr instanceof SQLIdentifierExpr) {
                        redirectTableSource = ((SQLIdentifierExpr)tableSourceExpr).getResolvedTableSource();
                    } else if (tableSourceExpr instanceof SQLPropertyExpr) {
                        redirectTableSource = ((SQLPropertyExpr)tableSourceExpr).getResolvedTableSource();
                    }
                    if (redirectTableSource == resolvedTableSource) {
                        redirectTableSource = null;
                    }
                    if (redirectTableSource != null) {
                        propertyExpr = propertyExpr.clone();
                        if (redirectTableSource instanceof SQLExprTableSource) {
                            propertyExpr.setOwner(((SQLExprTableSource)redirectTableSource).getExpr().clone());
                        }
                        propertyExpr.setResolvedTableSource(redirectTableSource);
                        expr = propertyExpr;
                    } else {
                        propertyExpr = propertyExpr.clone();
                        propertyExpr.setOwner(tableSourceExpr);
                        expr = propertyExpr;
                        break;
                    }
                }
            }
            ++i2;
        }
        return expr;
    }

    @Override
    public boolean visit(SQLTruncateStatement x) {
        this.setMode(x, TableStat.Mode.Delete);
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDeleteCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropViewStatement x) {
        this.setMode(x, TableStat.Mode.Drop);
        return true;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        this.setMode(x, TableStat.Mode.Insert);
        for (SQLExprTableSource tableSource : x.getTableSources()) {
            SQLName name = (SQLName)tableSource.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDropCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Insert);
        if (x.getTableName() instanceof SQLName) {
            String ident = x.getTableName().toString();
            TableStat stat = this.getTableStat(x.getTableName());
            stat.incrementInsertCount();
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        return false;
    }

    protected static void putAliasMap(Map<String, String> aliasMap, String name, String value) {
        if (aliasMap == null || name == null) {
            return;
        }
        aliasMap.put(name.toLowerCase(), value);
    }

    protected void accept(SQLObject x) {
        if (x != null) {
            x.accept(this);
        }
    }

    protected void accept(List<? extends SQLObject> nodes) {
        int size = nodes.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.accept(nodes.get(i2));
        }
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        List<SQLSelectOrderByItem> sortBy;
        List<SQLSelectOrderByItem> distributeBy;
        SQLExpr first;
        SQLOrderBy sQLOrderBy;
        List<SQLWindow> windows;
        SQLSelectGroupByClause groupBy;
        SQLExpr connectBy;
        SQLExpr startWith;
        SQLExprTableSource into;
        SQLTableSource from = x.getFrom();
        this.setMode(x, TableStat.Mode.Select);
        boolean isHiveMultiInsert = false;
        if (from == null) {
            boolean bl = isHiveMultiInsert = x.getParent() != null && x.getParent().getParent() instanceof HiveInsert && x.getParent().getParent().getParent() instanceof HiveMultiInsertStatement;
            if (isHiveMultiInsert) {
                from = ((HiveMultiInsertStatement)x.getParent().getParent().getParent()).getFrom();
            }
        }
        if (from == null) {
            for (SQLSelectItem selectItem : x.getSelectList()) {
                this.statExpr(selectItem.getExpr());
            }
            return false;
        }
        if (from != null) {
            from.accept(this);
        }
        if ((into = x.getInto()) != null && into.getExpr() instanceof SQLName) {
            TableStat stat;
            boolean isParam;
            SQLName intoExpr = (SQLName)into.getExpr();
            boolean bl = isParam = intoExpr instanceof SQLIdentifierExpr && SchemaStatVisitor.isParam((SQLIdentifierExpr)intoExpr);
            if (!isParam && (stat = this.getTableStat(intoExpr)) != null) {
                stat.incrementInsertCount();
            }
            into.accept(this);
        }
        for (SQLSelectItem selectItem : x.getSelectList()) {
            if (selectItem.getClass() == SQLSelectItem.class) {
                this.statExpr(selectItem.getExpr());
                continue;
            }
            selectItem.accept(this);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            this.statExpr(where);
        }
        if ((startWith = x.getStartWith()) != null) {
            this.statExpr(startWith);
        }
        if ((connectBy = x.getConnectBy()) != null) {
            this.statExpr(connectBy);
        }
        if ((groupBy = x.getGroupBy()) != null) {
            for (SQLExpr sQLExpr : groupBy.getItems()) {
                this.statExpr(sQLExpr);
            }
        }
        if ((windows = x.getWindows()) != null && windows.size() > 0) {
            for (SQLWindow window : windows) {
                window.accept(this);
            }
        }
        if ((sQLOrderBy = x.getOrderBy()) != null) {
            this.visit(sQLOrderBy);
        }
        if ((first = x.getFirst()) != null) {
            this.statExpr(first);
        }
        if ((distributeBy = x.getDistributeBy()) != null) {
            for (SQLSelectOrderByItem item : distributeBy) {
                this.statExpr(item.getExpr());
            }
        }
        if ((sortBy = x.getSortBy()) != null) {
            for (SQLSelectOrderByItem orderByItem : sortBy) {
                this.statExpr(orderByItem.getExpr());
            }
        }
        for (SQLExpr expr : x.getForUpdateOf()) {
            this.statExpr(expr);
        }
        return false;
    }

    private static boolean isParam(SQLIdentifierExpr x) {
        return x.getResolvedParameter() != null || x.getResolvedDeclareItem() != null;
    }

    @Override
    public void endVisit(SQLSelectQueryBlock x) {
        this.setModeOrigin(x);
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        SQLTableSource left = x.getLeft();
        SQLTableSource right = x.getRight();
        left.accept(this);
        right.accept(this);
        SQLExpr condition = x.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (x.getUsing().size() > 0 && left instanceof SQLExprTableSource && right instanceof SQLExprTableSource) {
            SQLExpr leftExpr = ((SQLExprTableSource)left).getExpr();
            SQLExpr rightExpr = ((SQLExprTableSource)right).getExpr();
            for (SQLExpr expr : x.getUsing()) {
                if (!(expr instanceof SQLIdentifierExpr)) continue;
                String name = ((SQLIdentifierExpr)expr).getName();
                SQLPropertyExpr leftPropExpr = new SQLPropertyExpr(leftExpr, name);
                SQLPropertyExpr rightPropExpr = new SQLPropertyExpr(rightExpr, name);
                leftPropExpr.setResolvedTableSource(left);
                rightPropExpr.setResolvedTableSource(right);
                SQLBinaryOpExpr usingCondition = new SQLBinaryOpExpr((SQLExpr)leftPropExpr, SQLBinaryOperator.Equality, rightPropExpr);
                usingCondition.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        SQLTableSource subTableSource;
        SQLSelect subSelect;
        SQLSelectQueryBlock subQuery;
        TableStat.Column column = null;
        String ident = SQLUtils.normalize(x.getName());
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLSubqueryTableSource && (subQuery = (subSelect = ((SQLSubqueryTableSource)tableSource).getSelect()).getQueryBlock()) != null && (subTableSource = subQuery.findTableSourceWithColumn(x.nameHashCode64())) != null) {
            tableSource = subTableSource;
        }
        if (tableSource instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLTableSource resolvedTableSource;
            SQLExprImpl table;
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                table = (SQLIdentifierExpr)expr;
                resolvedTableSource = ((SQLIdentifierExpr)table).getResolvedTableSource();
                if (resolvedTableSource instanceof SQLExprTableSource) {
                    expr = ((SQLExprTableSource)resolvedTableSource).getExpr();
                }
            } else if (expr instanceof SQLPropertyExpr && (resolvedTableSource = ((SQLPropertyExpr)(table = (SQLPropertyExpr)expr)).getResolvedTableSource()) instanceof SQLExprTableSource) {
                expr = ((SQLExprTableSource)resolvedTableSource).getExpr();
            }
            if (expr instanceof SQLIdentifierExpr) {
                SQLColumnDefinition columnDef;
                table = (SQLIdentifierExpr)expr;
                resolvedTableSource = ((SQLIdentifierExpr)table).getResolvedTableSource();
                if (resolvedTableSource instanceof SQLWithSubqueryClause.Entry) {
                    return false;
                }
                String tableName = ((SQLIdentifierExpr)table).getName();
                SchemaObject schemaObject = ((SQLExprTableSource)tableSource).getSchemaObject();
                if (schemaObject != null && schemaObject.getStatement() instanceof SQLCreateTableStatement && !"*".equals(ident) && (columnDef = schemaObject.findColumn(x.nameHashCode64())) == null) {
                    column = this.addColumn("UNKNOWN", ident);
                }
                if (column == null) {
                    column = this.addColumn((SQLName)((Object)table), ident);
                }
                if (this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLPropertyExpr) {
                table = (SQLPropertyExpr)expr;
                column = this.addColumn((SQLName)((Object)table), ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLMethodInvokeExpr && "table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) && methodInvokeExpr.getArguments().size() == 1 && methodInvokeExpr.getArguments().get(0) instanceof SQLName) {
                SQLName table2 = (SQLName)methodInvokeExpr.getArguments().get(0);
                String tableName = null;
                if (table2 instanceof SQLPropertyExpr) {
                    SQLExpr resolveExpr;
                    SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table2;
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                    if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                        tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                    }
                }
                if (tableName == null) {
                    tableName = table2.toString();
                }
                column = this.addColumn(tableName, ident);
            }
        } else {
            if (tableSource instanceof SQLWithSubqueryClause.Entry || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource || tableSource instanceof SQLValuesTableSource || tableSource instanceof SQLLateralViewTableSource) {
                return false;
            }
            if (x.getResolvedProcudure() != null) {
                return false;
            }
            if (x.getResolvedOwnerObject() instanceof SQLParameter) {
                return false;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof SQLValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
            if (!skip) {
                column = this.handleUnknownColumn(ident);
            }
        }
        if (column != null) {
            SQLObject parent = x.getParent();
            if (parent instanceof SQLSelectOrderByItem && (parent = parent.getParent()) instanceof SQLIndexDefinition) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
            } else if (parent instanceof SQLUnique) {
                column.setUnique(true);
            }
            this.setColumn(x, column);
        }
        return false;
    }

    protected boolean isPseudoColumn(long hash) {
        return false;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        SQLSelectOrderByItem selectOrderByItem;
        if (SchemaStatVisitor.isParam(x)) {
            return false;
        }
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (x.getParent() instanceof SQLSelectOrderByItem && (selectOrderByItem = (SQLSelectOrderByItem)x.getParent()).getResolvedSelectItem() != null) {
            return false;
        }
        if (tableSource == null && (x.getResolvedParameter() != null || x.getResolvedDeclareItem() != null)) {
            return false;
        }
        long hash = x.nameHashCode64();
        if (this.isPseudoColumn(hash)) {
            return false;
        }
        if ((hash == FnvHash.Constants.LEVEL || hash == FnvHash.Constants.CONNECT_BY_ISCYCLE || hash == FnvHash.Constants.ROWNUM) && x.getResolvedColumn() == null && tableSource == null) {
            return false;
        }
        TableStat.Column column = null;
        String ident = x.normalizedName();
        if (tableSource instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLMethodInvokeExpr func;
            SQLExpr expr = ((SQLExprTableSource)tableSource).getExpr();
            if (expr instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ANN) {
                expr = func.getArguments().get(0);
            }
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr table = (SQLIdentifierExpr)expr;
                column = this.addColumn(table, ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLPropertyExpr || expr instanceof SQLDbLinkExpr) {
                String tableName = expr instanceof SQLPropertyExpr ? ((SQLPropertyExpr)expr).normalizedName() : expr.toString();
                column = this.addColumn(tableName, ident);
                if (column != null && this.isParentGroupBy(x)) {
                    this.groupByColumns.add(column);
                }
            } else if (expr instanceof SQLMethodInvokeExpr && "table".equalsIgnoreCase((methodInvokeExpr = (SQLMethodInvokeExpr)expr).getMethodName()) && methodInvokeExpr.getArguments().size() == 1 && methodInvokeExpr.getArguments().get(0) instanceof SQLName) {
                SQLName table = (SQLName)methodInvokeExpr.getArguments().get(0);
                String tableName = null;
                if (table instanceof SQLPropertyExpr) {
                    SQLExpr resolveExpr;
                    SQLPropertyExpr propertyExpr = (SQLPropertyExpr)table;
                    SQLIdentifierExpr owner = (SQLIdentifierExpr)propertyExpr.getOwner();
                    if (propertyExpr.getResolvedTableSource() != null && propertyExpr.getResolvedTableSource() instanceof SQLExprTableSource && (resolveExpr = ((SQLExprTableSource)propertyExpr.getResolvedTableSource()).getExpr()) instanceof SQLName) {
                        tableName = resolveExpr.toString() + "." + propertyExpr.getName();
                    }
                }
                if (tableName == null) {
                    tableName = table.toString();
                }
                column = this.addColumn(tableName, ident);
            }
        } else {
            if (tableSource instanceof SQLWithSubqueryClause.Entry || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLLateralViewTableSource) {
                return false;
            }
            boolean skip = false;
            for (SQLObject parent = x.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLTableSource from = ((SQLSelectQueryBlock)parent).getFrom();
                    if (!(from instanceof SQLValuesTableSource)) continue;
                    skip = true;
                    break;
                }
                if (parent instanceof SQLSelectQuery) break;
            }
            if (x.getParent() instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)x.getParent()).methodNameHashCode64() == FnvHash.Constants.ANN) {
                skip = true;
            }
            if (!skip) {
                column = this.handleUnknownColumn(ident);
            }
        }
        if (column != null) {
            SQLObject parent = x.getParent();
            if (parent instanceof SQLSelectOrderByItem && (parent = parent.getParent()) instanceof SQLIndexDefinition) {
                parent = parent.getParent();
            }
            if (parent instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
            } else if (parent instanceof SQLUnique) {
                column.setUnique(true);
            }
            this.setColumn(x, column);
        }
        return false;
    }

    private boolean isParentSelectItem(SQLObject parent) {
        for (int i2 = 0; parent != null && i2 <= 100; parent = parent.getParent(), ++i2) {
            if (parent instanceof SQLSelectItem) {
                return true;
            }
            if (!(parent instanceof SQLSelectQueryBlock)) continue;
            return false;
        }
        return false;
    }

    private boolean isParentGroupBy(SQLObject parent) {
        while (parent != null) {
            if (parent instanceof SQLSelectItem) {
                return false;
            }
            if (parent instanceof SQLSelectGroupByClause) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void setColumn(SQLExpr x, TableStat.Column column) {
        SQLObject parent;
        SQLObject current = x;
        for (int i2 = 0; i2 < 100 && (parent = current.getParent()) != null; ++i2) {
            if (parent instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock query2 = (SQLSelectQueryBlock)parent;
                if (query2.getWhere() != current) break;
                column.setWhere(true);
                break;
            }
            if (parent instanceof SQLSelectGroupByClause) {
                SQLSelectGroupByClause groupBy = (SQLSelectGroupByClause)parent;
                if (current == groupBy.getHaving()) {
                    column.setHaving(true);
                    break;
                }
                if (!groupBy.getItems().contains(current)) break;
                column.setGroupBy(true);
                break;
            }
            if (this.isParentSelectItem(parent)) {
                column.setSelec(true);
                break;
            }
            if (parent instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)parent;
                if (join.getCondition() != current) break;
                column.setJoin(true);
                break;
            }
            current = parent;
        }
    }

    protected TableStat.Column handleUnknownColumn(String columnName) {
        return this.addColumn("UNKNOWN", columnName);
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource == null) {
            return false;
        }
        this.statAllColumn(x, tableSource);
        return false;
    }

    private void statAllColumn(SQLAllColumnExpr x, SQLTableSource tableSource) {
        if (tableSource instanceof SQLExprTableSource) {
            this.statAllColumn(x, (SQLExprTableSource)tableSource);
            return;
        }
        if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            this.statAllColumn(x, join.getLeft());
            this.statAllColumn(x, join.getRight());
        }
    }

    private void statAllColumn(SQLAllColumnExpr x, SQLExprTableSource tableSource) {
        SQLStatement stmt;
        SQLExprTableSource exprTableSource = tableSource;
        SQLName expr = exprTableSource.getName();
        SQLCreateTableStatement createStmt = null;
        SchemaObject tableObject = exprTableSource.getSchemaObject();
        if (tableObject != null && (stmt = tableObject.getStatement()) instanceof SQLCreateTableStatement) {
            createStmt = (SQLCreateTableStatement)stmt;
        }
        if (createStmt != null && createStmt.getTableElementList().size() > 0) {
            SQLName tableName = createStmt.getName();
            for (SQLTableElement e : createStmt.getTableElementList()) {
                if (!(e instanceof SQLColumnDefinition)) continue;
                SQLColumnDefinition columnDefinition = (SQLColumnDefinition)e;
                SQLName columnName = columnDefinition.getName();
                TableStat.Column column = this.addColumn(tableName, columnName.toString());
                if (!this.isParentSelectItem(x.getParent())) continue;
                column.setSelec(true);
            }
        } else if (expr != null) {
            TableStat.Column column = this.addColumn(expr, "*");
            if (this.isParentSelectItem(x.getParent())) {
                column.setSelec(true);
            }
        }
    }

    public Map<TableStat.Name, TableStat> getTables() {
        return this.tableStats;
    }

    public boolean containsTable(String tableName) {
        return this.tableStats.containsKey(new TableStat.Name(tableName));
    }

    public boolean containsColumn(String tableName, String columnName) {
        long hashCode;
        int p = tableName.indexOf(46);
        if (p != -1) {
            SQLExpr owner = SQLUtils.toSQLExpr(tableName, this.dbType);
            hashCode = new SQLPropertyExpr(owner, columnName).hashCode64();
        } else {
            hashCode = FnvHash.hashCode64(tableName, columnName);
        }
        return this.columns.containsKey(hashCode);
    }

    public Collection<TableStat.Column> getColumns() {
        return this.columns.values();
    }

    public TableStat.Column getColumn(String tableName, String columnName) {
        TableStat.Column column = new TableStat.Column(tableName, columnName);
        return this.columns.get(column.hashCode64());
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.visit(x.getSelect());
        return false;
    }

    @Override
    public void endVisit(SQLSelectStatement x) {
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        String alias = x.getAlias();
        SQLWithSubqueryClause with = (SQLWithSubqueryClause)x.getParent();
        if (Boolean.TRUE == with.getRecursive()) {
            SQLSelect select = x.getSubQuery();
            if (select != null) {
                select.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
        } else {
            SQLSelect select = x.getSubQuery();
            if (select != null) {
                select.accept(this);
            } else {
                x.getReturningStatement().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        x.getSelect().accept(this);
        return false;
    }

    protected boolean isSimpleExprTableSource(SQLExprTableSource x) {
        return x.getExpr() instanceof SQLName;
    }

    public TableStat getTableStat(SQLExprTableSource tableSource) {
        return this.getTableStatWithUnwrap(tableSource.getExpr());
    }

    protected TableStat getTableStatWithUnwrap(SQLExpr expr) {
        SQLExpr tableSourceExpr;
        SQLExpr identExpr = null;
        if ((expr = this.unwrapExpr(expr)) instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            if (identifierExpr.nameHashCode64() == FnvHash.Constants.DUAL) {
                return null;
            }
            if (this.isSubQueryOrParamOrVariant(identifierExpr)) {
                return null;
            }
        }
        SQLTableSource tableSource = null;
        if (expr instanceof SQLIdentifierExpr) {
            tableSource = ((SQLIdentifierExpr)expr).getResolvedTableSource();
        } else if (expr instanceof SQLPropertyExpr) {
            tableSource = ((SQLPropertyExpr)expr).getResolvedTableSource();
        }
        if (tableSource instanceof SQLExprTableSource && (tableSourceExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLName) {
            identExpr = tableSourceExpr;
        }
        if (identExpr == null) {
            identExpr = expr;
        }
        if (identExpr instanceof SQLName) {
            return this.getTableStat((SQLName)identExpr);
        }
        return this.getTableStat(identExpr.toString());
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLMethodInvokeExpr func;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLMethodInvokeExpr && (func = (SQLMethodInvokeExpr)expr).methodNameHashCode64() == FnvHash.Constants.ANN) {
            expr = func.getArguments().get(0);
        }
        if (this.isSimpleExprTableSource(x)) {
            TableStat stat = this.getTableStatWithUnwrap(expr);
            if (stat == null) {
                return false;
            }
            TableStat.Mode mode = this.getMode();
            if (mode != null) {
                switch (mode) {
                    case Delete: {
                        stat.incrementDeleteCount();
                        break;
                    }
                    case Insert: {
                        stat.incrementInsertCount();
                        break;
                    }
                    case Update: {
                        stat.incrementUpdateCount();
                        break;
                    }
                    case Select: {
                        stat.incrementSelectCount();
                        break;
                    }
                    case Merge: {
                        stat.incrementMergeCount();
                        break;
                    }
                    case Drop: {
                        stat.incrementDropCount();
                        break;
                    }
                }
            }
        } else {
            this.accept(expr);
        }
        return false;
    }

    protected boolean isSubQueryOrParamOrVariant(SQLIdentifierExpr identifierExpr) {
        SQLObject resolvedColumnObject = identifierExpr.getResolvedColumnObject();
        if (resolvedColumnObject instanceof SQLWithSubqueryClause.Entry || resolvedColumnObject instanceof SQLParameter || resolvedColumnObject instanceof SQLDeclareItem) {
            return true;
        }
        SQLObject resolvedOwnerObject = identifierExpr.getResolvedOwnerObject();
        return resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry;
    }

    protected boolean isSubQueryOrParamOrVariant(SQLPropertyExpr x) {
        SQLObject resolvedOwnerObject = x.getResolvedOwnerObject();
        if (resolvedOwnerObject instanceof SQLSubqueryTableSource || resolvedOwnerObject instanceof SQLWithSubqueryClause.Entry) {
            return true;
        }
        SQLExpr owner = x.getOwner();
        if (owner instanceof SQLIdentifierExpr && this.isSubQueryOrParamOrVariant((SQLIdentifierExpr)owner)) {
            return true;
        }
        SQLTableSource tableSource = x.getResolvedTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
            if (exprTableSource.getSchemaObject() != null) {
                return false;
            }
            SQLExpr expr = exprTableSource.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                return this.isSubQueryOrParamOrVariant((SQLIdentifierExpr)expr);
            }
            if (expr instanceof SQLPropertyExpr) {
                return this.isSubQueryOrParamOrVariant((SQLPropertyExpr)expr);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        this.statExpr(x.getExpr());
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        SQLOrderBy orderBy;
        SQLSelectQuery query2;
        SQLWithSubqueryClause with = x.getWithSubQuery();
        if (with != null) {
            with.accept(this);
        }
        if ((query2 = x.getQuery()) != null) {
            query2.accept(this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.accept(x.getOrderBy());
        }
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        this.aggregateFunctions.add(x);
        this.accept(x.getArguments());
        this.accept(x.getOrderBy());
        this.accept(x.getOver());
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        this.functions.add(x);
        this.accept(x.getArguments());
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Update);
        SQLTableSource tableSource = x.getTableSource();
        if (tableSource instanceof SQLExprTableSource) {
            SQLName identName = ((SQLExprTableSource)tableSource).getName();
            TableStat stat = this.getTableStat(identName);
            stat.incrementUpdateCount();
        } else {
            tableSource.accept(this);
        }
        SQLTableSource from = x.getFrom();
        if (from != null) {
            from.accept(this);
        }
        List<SQLUpdateSetItem> items = x.getItems();
        int size = items.size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLUpdateSetItem item = items.get(i2);
            this.visit(item);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateSetItem x) {
        SQLExpr value;
        SQLExpr column = x.getColumn();
        if (column != null) {
            this.statExpr(column);
            TableStat.Column columnStat = this.getColumn(column);
            if (columnStat != null) {
                columnStat.setUpdate(true);
            }
        }
        if ((value = x.getValue()) != null) {
            this.statExpr(value);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        SQLSelectQuery selectQuery;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Delete);
        if (x.getTableSource() instanceof SQLSubqueryTableSource && (selectQuery = ((SQLSubqueryTableSource)x.getTableSource()).getSelect().getQuery()) instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock subQueryBlock = (SQLSelectQueryBlock)selectQuery;
            subQueryBlock.getWhere().accept(this);
        }
        TableStat stat = this.getTableStat(x.getTableName());
        stat.incrementDeleteCount();
        SQLExpr where = x.getWhere();
        if (where != null) {
            where.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", x.getTargetList());
        } else {
            this.handleCondition(x.getExpr(), "IN", x.getTargetList());
        }
        return true;
    }

    @Override
    public boolean visit(SQLInSubQueryExpr x) {
        if (x.isNot()) {
            this.handleCondition(x.getExpr(), "NOT IN", new SQLExpr[0]);
        } else {
            this.handleCondition(x.getExpr(), "IN", new SQLExpr[0]);
        }
        return true;
    }

    @Override
    public void endVisit(SQLDeleteStatement x) {
    }

    @Override
    public void endVisit(SQLUpdateStatement x) {
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        SQLExprTableSource like;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        for (SQLTableElement e : x.getTableElementList()) {
            e.setParent(x);
        }
        TableStat stat = this.getTableStat(x.getName());
        stat.incrementCreateCount();
        this.accept(x.getTableElementList());
        if (x.getInherits() != null) {
            x.getInherits().accept(this);
        }
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
            stat.incrementInsertCount();
        }
        if ((like = x.getLike()) != null) {
            like.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        SQLName tableName = null;
        SQLObject parent = x.getParent();
        if (parent instanceof SQLCreateTableStatement) {
            tableName = ((SQLCreateTableStatement)parent).getName();
        }
        if (tableName == null) {
            return true;
        }
        String columnName = x.getName().toString();
        TableStat.Column column = this.addColumn(tableName, columnName);
        if (x.getDataType() != null) {
            column.setDataType(x.getDataType().getName());
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            if (item instanceof SQLPrimaryKey) {
                column.setPrimaryKey(true);
                continue;
            }
            if (!(item instanceof SQLUnique)) continue;
            column.setUnique(true);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        return false;
    }

    @Override
    public void endVisit(SQLCommentStatement x) {
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCurrentOfCursorExpr x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        String table = stmt.getName().toString();
        for (SQLColumnDefinition column : x.getColumns()) {
            String columnName = SQLUtils.normalize(column.getName().toString());
            this.addColumn(stmt.getName(), columnName);
        }
        return false;
    }

    @Override
    public void endVisit(SQLAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateViewStatement x) {
        SQLBlockStatement script;
        SQLSelect subQuery;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if ((subQuery = x.getSubQuery()) != null) {
            subQuery.accept(this);
        }
        if ((script = x.getScript()) != null) {
            script.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterViewStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropForeignKey x) {
        return false;
    }

    @Override
    public boolean visit(SQLUseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDisableConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableEnableConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        TableStat stat = this.getTableStat(x.getName());
        stat.incrementAlterCount();
        for (SQLAlterTableItem item : x.getItems()) {
            item.setParent(x);
            if (item instanceof SQLAlterTableAddPartition || item instanceof SQLAlterTableRenamePartition || item instanceof SQLAlterTableMergePartition) {
                stat.incrementAddPartitionCount();
            }
            item.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropConstraint x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropIndexStatement x) {
        this.setMode(x, TableStat.Mode.DropIndex);
        SQLExprTableSource table = x.getTableName();
        if (table != null) {
            SQLName name = (SQLName)table.getExpr();
            TableStat stat = this.getTableStat(name);
            stat.incrementDropIndexCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateIndexStatement x) {
        this.setMode(x, TableStat.Mode.CreateIndex);
        SQLName table = (SQLName)((SQLExprTableSource)x.getTable()).getExpr();
        TableStat stat = this.getTableStat(table);
        stat.incrementCreateIndexCount();
        for (SQLSelectOrderByItem item : x.getItems()) {
            SQLExpr param;
            SQLMethodInvokeExpr methodInvokeExpr;
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
                String columnName = identExpr.getName();
                this.addColumn(table, columnName);
                continue;
            }
            if (!(expr instanceof SQLMethodInvokeExpr) || (methodInvokeExpr = (SQLMethodInvokeExpr)expr).getArguments().size() != 1 || !((param = methodInvokeExpr.getArguments().get(0)) instanceof SQLIdentifierExpr)) continue;
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)param;
            String columnName = identExpr.getName();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLForeignKeyImpl x) {
        for (SQLName column : x.getReferencingColumns()) {
            column.accept(this);
        }
        SQLName table = x.getReferencedTableName();
        TableStat stat = this.getTableStat(x.getReferencedTableName());
        stat.incrementReferencedCount();
        for (SQLName column : x.getReferencedColumns()) {
            String columnName = column.getSimpleName();
            this.addColumn(table, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropSequenceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropTriggerStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropUserStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLGrantStatement x) {
        if (x.getResource() != null && (x.getResourceType() == null || x.getResourceType() == SQLObjectType.TABLE)) {
            x.getResource().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLRevokeStatement x) {
        if (x.getResource() != null) {
            x.getResource().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropDatabaseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddIndex x) {
        for (SQLSelectOrderByItem item : x.getColumns()) {
            item.accept(this);
        }
        SQLName table = ((SQLAlterTableStatement)x.getParent()).getName();
        TableStat tableStat = this.getTableStat(table);
        tableStat.incrementCreateIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLCheck x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDefault x) {
        x.getExpr().accept(this);
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateTriggerStatement x) {
        SQLExprTableSource on = x.getOn();
        on.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDropFunctionStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropTableSpaceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropProcedureStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRename x) {
        return false;
    }

    @Override
    public boolean visit(SQLArrayExpr x) {
        this.accept(x.getValues());
        SQLExpr exp = x.getExpr();
        if (exp instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)exp).getName().equals("ARRAY")) {
            return false;
        }
        if (exp != null) {
            exp.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOpenStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLFetchStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropMaterializedViewStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowMaterializedViewStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLRefreshMaterializedViewStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCloseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateProcedureStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(SQLCreateFunctionStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.accept(x.getBlock());
        return false;
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        for (SQLParameter param : x.getParameters()) {
            param.setParent(x);
            param.accept(this);
        }
        for (SQLStatement stmt : x.getStatementList()) {
            stmt.accept(this);
        }
        SQLStatement exception = x.getException();
        if (exception != null) {
            exception.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDeclareItem x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByHash x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByRange x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionByList x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSubPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSubPartitionByHash x) {
        return false;
    }

    @Override
    public boolean visit(SQLPartitionValue x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterDatabaseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableConvertCharSet x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableReOrganizePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCoalescePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableTruncatePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDiscardPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableImportPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAnalyzePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableCheckPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableOptimizePartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRebuildPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableRepairPartition x) {
        return false;
    }

    @Override
    public boolean visit(SQLSequenceExpr x) {
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x.getUsing(), TableStat.Mode.Select);
        x.getUsing().accept(this);
        this.setMode(x, TableStat.Mode.Merge);
        SQLTableSource into = x.getInto();
        if (into instanceof SQLExprTableSource) {
            String ident = ((SQLExprTableSource)into).getExpr().toString();
            TableStat stat = this.getTableStat(ident);
            stat.incrementMergeCount();
        } else {
            into.accept(this);
        }
        x.getOn().accept(this);
        if (x.getUpdateClause() != null) {
            x.getUpdateClause().accept(this);
        }
        if (x.getInsertClause() != null) {
            x.getInsertClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        return false;
    }

    public List<SQLMethodInvokeExpr> getFunctions() {
        return this.functions;
    }

    @Override
    public boolean visit(SQLCreateSequenceStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddConstraint x) {
        SQLConstraint constraint = x.getConstraint();
        if (constraint instanceof SQLUniqueConstraint) {
            SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
            TableStat tableStat = this.getTableStat(stmt.getName());
            tableStat.incrementCreateIndexCount();
        }
        return true;
    }

    @Override
    public boolean visit(SQLAlterTableDropIndex x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropPrimaryKey x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableDropKey x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        TableStat tableStat = this.getTableStat(stmt.getName());
        tableStat.incrementDropIndexCount();
        return false;
    }

    @Override
    public boolean visit(SQLDescribeStatement x) {
        SQLName tableName = x.getObject();
        TableStat tableStat = this.getTableStat(x.getObject());
        SQLName column = x.getColumn();
        if (column != null) {
            String columnName = column.toString();
            this.addColumn(tableName, columnName);
        }
        return false;
    }

    @Override
    public boolean visit(SQLExplainStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getStatement() != null) {
            this.accept(x.getStatement());
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateMaterializedViewStatement x) {
        SQLSelect query2;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if ((query2 = x.getQuery()) != null) {
            query2.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLReplaceStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Replace);
        SQLName tableName = x.getTableName();
        TableStat stat = this.getTableStat(tableName);
        if (stat != null) {
            stat.incrementInsertCount();
        }
        this.accept(x.getColumns());
        this.accept(x.getValuesList());
        this.accept(x.getQuery());
        return false;
    }

    protected final void statExpr(SQLExpr x) {
        if (x == null) {
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == SQLIdentifierExpr.class) {
            this.visit((SQLIdentifierExpr)x);
        } else if (clazz == SQLPropertyExpr.class) {
            this.visit((SQLPropertyExpr)x);
        } else if (clazz == SQLBinaryOpExpr.class) {
            this.visit((SQLBinaryOpExpr)x);
        } else if (!(x instanceof SQLLiteralExpr)) {
            x.accept(this);
        }
    }

    @Override
    public boolean visit(SQLAlterFunctionStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropSynonymStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTypeStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterProcedureStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLExprStatement x) {
        SQLExpr expr = x.getExpr();
        return !(expr instanceof SQLName);
    }

    @Override
    public boolean visit(SQLDropTypeStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLExternalRecordFormat x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateDatabaseStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateTableGroupStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropTableGroupStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowDatabasesStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowColumnsStatement x) {
        SQLName table = x.getTable();
        TableStat stat = this.getTableStat(table);
        if (stat != null) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowCreateTableStatement x) {
        TableStat stat;
        SQLName table = x.getName();
        if (table == null || (stat = this.getTableStat(table)) != null) {
            // empty if block
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowTableGroupsStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableSetOption x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowCreateViewStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLCreateRoleStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLDropRoleStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowViewsStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableExchangePartition x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropCatalogStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        boolean bracket;
        SQLUnionOperator operator = x.getOperator();
        List<SQLSelectQuery> relations = x.getRelations();
        if (relations.size() > 2) {
            for (SQLSelectQuery relation : x.getRelations()) {
                relation.accept(this);
            }
            return false;
        }
        SQLSelectQuery left = x.getLeft();
        SQLSelectQuery right = x.getRight();
        boolean bl = bracket = x.isParenthesized() && !(x.getParent() instanceof SQLUnionQueryTableSource);
        if (!bracket && left instanceof SQLUnionQuery && ((SQLUnionQuery)left).getOperator() == operator && !right.isParenthesized() && x.getOrderBy() == null) {
            SQLUnionQuery leftUnion = (SQLUnionQuery)left;
            ArrayList<SQLSelectQuery> rights = new ArrayList<SQLSelectQuery>();
            rights.add(right);
            if (leftUnion.getRelations().size() > 2) {
                rights.addAll(leftUnion.getRelations());
            } else {
                SQLSelectQuery leftRight;
                SQLSelectQuery leftLeft;
                while (true) {
                    leftLeft = leftUnion.getLeft();
                    leftRight = leftUnion.getRight();
                    if (leftUnion.isParenthesized() || leftUnion.getOrderBy() != null || leftLeft.isParenthesized() || leftRight.isParenthesized() || !(leftLeft instanceof SQLUnionQuery) || ((SQLUnionQuery)leftLeft).getOperator() != operator) break;
                    rights.add(leftRight);
                    leftUnion = (SQLUnionQuery)leftLeft;
                }
                rights.add(leftRight);
                rights.add(leftLeft);
            }
            for (int i2 = rights.size() - 1; i2 >= 0; --i2) {
                SQLSelectQuery item = (SQLSelectQuery)rights.get(i2);
                item.accept(this);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(SQLValuesTableSource x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterIndexStatement x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowIndexesStatement x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLAnalyzeTableStatement x) {
        for (SQLExprTableSource table : x.getTables()) {
            TableStat stat;
            if (table == null || (stat = this.getTableStat(table.getName())) == null) continue;
            stat.incrementAnalyzeCount();
        }
        SQLExprTableSource table = x.getTables().size() == 1 ? x.getTables().get(0) : null;
        SQLPartitionRef partition = x.getPartition();
        if (partition != null) {
            for (SQLPartitionRef.Item item : partition.getItems()) {
                SQLIdentifierExpr columnName = item.getColumnName();
                columnName.setResolvedTableSource(table);
                columnName.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLExportTableStatement x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        for (SQLAssignItem item : x.getPartition()) {
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr)) continue;
            ((SQLIdentifierExpr)target).setResolvedTableSource(table);
            target.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLImportTableStatement x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
        }
        for (SQLAssignItem item : x.getPartition()) {
            SQLExpr target = item.getTarget();
            if (!(target instanceof SQLIdentifierExpr)) continue;
            ((SQLIdentifierExpr)target).setResolvedTableSource(table);
            target.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateOutlineStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if (x.getOn() != null) {
            x.getOn().accept(this);
        }
        if (x.getTo() != null) {
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDumpStatement x) {
        SQLSelect select;
        SQLExprTableSource into;
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        if ((into = x.getInto()) != null) {
            into.accept(this);
        }
        if ((select = x.getSelect()) != null) {
            select.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLDropOutlineStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterOutlineStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableArchivePartition x) {
        return true;
    }

    @Override
    public boolean visit(HiveCreateTableStatement x) {
        return this.visit((SQLCreateTableStatement)x);
    }

    @Override
    public boolean visit(SQLCopyFromStatement x) {
        SQLExprTableSource table = x.getTable();
        if (table != null) {
            table.accept(this);
            for (SQLName column : x.getColumns()) {
                this.addColumn(table.getName(), column.getSimpleName());
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCloneTableStatement x) {
        TableStat stat;
        SQLExprTableSource to;
        TableStat stat2;
        SQLExprTableSource from = x.getFrom();
        if (from != null && (stat2 = this.getTableStat(from.getName())) != null) {
            stat2.incrementSelectCount();
        }
        if ((to = x.getTo()) != null && (stat = this.getTableStat(to.getName())) != null) {
            stat.incrementInsertCount();
        }
        return false;
    }

    @Override
    public boolean visit(SQLSyncMetaStatement x) {
        return false;
    }

    public List<SQLName> getOriginalTables() {
        return this.originalTables;
    }

    @Override
    public boolean visit(SQLUnique x) {
        for (SQLSelectOrderByItem column : x.getColumns()) {
            column.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLSavePointStatement x) {
        return false;
    }

    @Override
    public boolean visit(SQLShowPartitionsStmt x) {
        this.setMode(x, TableStat.Mode.DESC);
        return true;
    }

    protected class OracleOrderByStatVisitor
    extends OracleASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public OracleOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            SQLExpr unwrapped = SchemaStatVisitor.this.unwrapExpr(x);
            if (unwrapped instanceof SQLPropertyExpr) {
                SchemaStatVisitor.this.visitOrderBy((SQLPropertyExpr)unwrapped);
            } else if (unwrapped instanceof SQLIdentifierExpr) {
                SchemaStatVisitor.this.visitOrderBy((SQLIdentifierExpr)unwrapped);
            }
            return false;
        }

        @Override
        public boolean visit(SQLIntegerExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }

    protected class PGOrderByStatVisitor
    extends PGASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public PGOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLIntegerExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }

    protected class MySqlOrderByStatVisitor
    extends MySqlASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public MySqlOrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLIntegerExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }

    protected class OrderByStatVisitor
    extends SQLASTVisitorAdapter {
        private final SQLOrderBy orderBy;

        public OrderByStatVisitor(SQLOrderBy orderBy) {
            this.orderBy = orderBy;
            for (SQLSelectOrderByItem item : orderBy.getItems()) {
                item.getExpr().setParent(item);
            }
        }

        public SQLOrderBy getOrderBy() {
            return this.orderBy;
        }

        @Override
        public boolean visit(SQLIdentifierExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLPropertyExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }

        @Override
        public boolean visit(SQLIntegerExpr x) {
            return SchemaStatVisitor.this.visitOrderBy(x);
        }
    }
}

