/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import com.alibaba.druid.support.jconsole.model.ColumnGroup;
import com.alibaba.druid.support.jconsole.model.GroupableTableHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    private int m_height;

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    private int getColCountUnderColGroup(ColumnGroup cg, int iCount) {
        Vector<Object> v = cg.vector;
        for (int i2 = 0; i2 < v.size(); ++i2) {
            Object obj = v.elementAt(i2);
            if (obj instanceof ColumnGroup) {
                iCount = this.getColCountUnderColGroup((ColumnGroup)obj, iCount);
                continue;
            }
            ++iCount;
        }
        return iCount;
    }

    public int getHeaderHeight() {
        int height = 0;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                renderer = new DefaultTableCellRenderer(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JTableHeader header = table.getTableHeader();
                        if (header != null) {
                            this.setForeground(header.getForeground());
                            this.setBackground(header.getBackground());
                            this.setFont(header.getFont());
                        }
                        this.setHorizontalAlignment(0);
                        this.setText(value == null ? "" : value.toString());
                        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                        return this;
                    }
                };
            }
            Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
            int cHeight = comp.getPreferredSize().height;
            Enumeration<ColumnGroup> enumeration = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ColumnGroup cGroup = enumeration.nextElement();
                    cHeight += cGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            height = Math.max(height, cHeight);
        }
        height = Math.max(height, this.m_height);
        return height;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        ((GroupableTableHeader)this.header).setColumnMargin();
        int column = 0;
        Dimension size = this.header.getSize();
        Rectangle cellRect = new Rectangle(0, 0, size.width, size.height);
        Hashtable<ColumnGroup, Rectangle> h = new Hashtable<ColumnGroup, Rectangle>();
        int columnMargin = this.header.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            cellRect.height = size.height;
            cellRect.y = 0;
            TableColumn aColumn = enumeration.nextElement();
            Enumeration<ColumnGroup> cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (cGroups != null) {
                int groupHeight = 0;
                while (cGroups.hasMoreElements()) {
                    ColumnGroup cGroup = cGroups.nextElement();
                    Rectangle groupRect = (Rectangle)h.get(cGroup);
                    if (groupRect == null) {
                        groupRect = new Rectangle(cellRect);
                        Dimension d = cGroup.getSize(this.header.getTable());
                        if (!System.getProperty("java.vm.version").startsWith("1.2")) {
                            int iColCount = this.getColCountUnderColGroup(cGroup, 0);
                            groupRect.width = d.width - iColCount * columnMargin;
                        } else {
                            groupRect.width = d.width;
                        }
                        groupRect.height = d.height;
                        h.put(cGroup, groupRect);
                    }
                    this.paintCell(g, groupRect, cGroup);
                    cellRect.height = size.height - (groupHeight += groupRect.height);
                    cellRect.y = groupHeight;
                }
            }
            cellRect.width = !System.getProperty("java.vm.version").startsWith("1.2") ? aColumn.getWidth() : aColumn.getWidth() + columnMargin;
            if (cellRect.intersects(clipBounds)) {
                this.paintCell(g, cellRect, column);
            }
            cellRect.x += cellRect.width;
            ++column;
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTableHeader header = table.getTableHeader();
                    if (header != null) {
                        this.setForeground(header.getForeground());
                        this.setBackground(header.getBackground());
                        this.setFont(header.getFont());
                    }
                    this.setHorizontalAlignment(0);
                    this.setText(value == null ? "" : value.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            };
        }
        String headerValue = aColumn.getHeaderValue().toString();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), headerValue, false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private void paintCell(Graphics g, Rectangle cellRect, ColumnGroup cGroup) {
        TableCellRenderer renderer = cGroup.getHeaderRenderer();
        if (renderer == null) {
            renderer = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTableHeader header = table.getTableHeader();
                    if (header != null) {
                        this.setForeground(header.getForeground());
                        this.setBackground(header.getBackground());
                        this.setFont(header.getFont());
                    }
                    this.setHorizontalAlignment(0);
                    this.setText(value == null ? "" : value.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            };
        }
        String headerValue = cGroup.getHeaderValue().toString();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), headerValue, false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    public void setHeaderHeight(int iHeight) {
        this.m_height = iHeight;
    }
}

