/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.parser.ObjectDeserializerWrapper;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;

public class ParserConfig {
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static ParserConfig global = new ParserConfig(JSONFactory.getDefaultObjectReaderProvider(), false);
    final ObjectReaderProvider provider;
    public final boolean fieldBase;
    private boolean asmEnable;
    private boolean autoTypeSupport;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    ParserConfig(ObjectReaderProvider provider, boolean fieldBase) {
        this.provider = provider;
        this.fieldBase = fieldBase;
    }

    public ParserConfig() {
        this(new ObjectReaderProvider(), false);
    }

    public ParserConfig(ClassLoader parentClassLoader) {
        this(new ObjectReaderProvider(), false);
    }

    public ParserConfig(boolean fieldBase) {
        this(new ObjectReaderProvider(), fieldBase);
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public ObjectReaderProvider getProvider() {
        return this.provider;
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.getProvider().register(type, deserializer);
    }

    public Class<?> checkAutoType(Class type) {
        return JSONFactory.getDefaultObjectReaderProvider().checkAutoType(type.getName(), null, 0L);
    }

    public boolean isSafeMode() {
        return ObjectReaderProvider.SAFE_MODE;
    }

    public void setSafeMode(boolean safeMode) {
        if (safeMode != ObjectReaderProvider.SAFE_MODE) {
            throw new JSONException("not support operation");
        }
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean autoTypeSupport) {
        this.autoTypeSupport = autoTypeSupport;
    }

    public void addAccept(String name) {
        this.getProvider().addAutoTypeAccept(name);
    }

    public void addDeny(String name) {
        this.getProvider().addAutoTypeDeny(name);
    }

    public void addDenyInternal(String name) {
        this.getProvider().addAutoTypeDeny(name);
    }

    @Deprecated
    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
    }

    public void addAutoTypeCheckHandler(AutoTypeCheckHandler h) {
        if (this.getProvider().getAutoTypeBeforeHandler() != null) {
            throw new JSONException("not support operation");
        }
        this.getProvider().setAutoTypeBeforeHandler(h);
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty(DENY_PROPERTY);
        String[] items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToDeny(items);
        property = properties.getProperty(AUTOTYPE_ACCEPT);
        items = ParserConfig.splitItemsFormProperty(property);
        this.addItemsToAccept(items);
    }

    private void addItemsToDeny(String[] items) {
        if (items == null) {
            return;
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            String item = items[i2];
            this.addDeny(item);
        }
    }

    private void addItemsToAccept(String[] items) {
        if (items == null) {
            return;
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            String item = items[i2];
            this.addAccept(item);
        }
    }

    private static String[] splitItemsFormProperty(String property) {
        if (property != null && property.length() > 0) {
            return property.split(",");
        }
        return null;
    }

    public ObjectDeserializer get(Type type) {
        ObjectReader objectReader = this.getProvider().getObjectReader(type);
        if (objectReader instanceof ObjectDeserializer) {
            return (ObjectDeserializer)objectReader;
        }
        return new ObjectDeserializerWrapper(objectReader);
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectReader objectReader = this.getProvider().getObjectReader(type);
        if (objectReader instanceof ObjectDeserializer) {
            return (ObjectDeserializer)objectReader;
        }
        return new ObjectDeserializerWrapper(objectReader);
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        ObjectReader objectReader;
        if (type == null) {
            type = clazz;
        }
        if ((objectReader = this.getProvider().getObjectReader(type)) instanceof ObjectDeserializer) {
            return (ObjectDeserializer)objectReader;
        }
        return new ObjectDeserializerWrapper(objectReader);
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> fieldCacheMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldCacheMap.containsKey(fieldName)) continue;
            fieldCacheMap.put(fieldName, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), fieldCacheMap);
        }
    }

    public static Field getFieldFromCache(String fieldName, Map<String, Field> fieldCacheMap) {
        Field field = fieldCacheMap.get(fieldName);
        if (field == null) {
            field = fieldCacheMap.get("_" + fieldName);
        }
        if (field == null) {
            field = fieldCacheMap.get("m_" + fieldName);
        }
        if (field == null) {
            char c0 = fieldName.charAt(0);
            if (c0 >= 'a' && c0 <= 'z') {
                char[] chars = fieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                String fieldNameX = new String(chars);
                field = fieldCacheMap.get(fieldNameX);
            }
            if (fieldName.length() > 2) {
                char c1 = fieldName.charAt(1);
                if (c0 >= 'a' && c0 <= 'z' && c1 >= 'A' && c1 <= 'Z') {
                    for (Map.Entry<String, Field> entry : fieldCacheMap.entrySet()) {
                        if (!fieldName.equalsIgnoreCase(entry.getKey())) continue;
                        field = entry.getValue();
                        break;
                    }
                }
            }
        }
        return field;
    }

    public static interface AutoTypeCheckHandler
    extends JSONReader.AutoTypeBeforeHandler {
        public Class<?> handler(String var1, Class<?> var2, int var3);

        @Override
        default public Class<?> apply(long typeNameHash, Class<?> expectClass, long features) {
            return null;
        }

        @Override
        default public Class<?> apply(String typeName, Class<?> expectClass, long features) {
            return this.handler(typeName, expectClass, (int)features);
        }
    }
}

