/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathFilter;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

abstract class JSONPathSegment {
    JSONPathSegment() {
    }

    public abstract void accept(JSONReader var1, JSONPath.Context var2);

    public abstract void eval(JSONPath.Context var1);

    public boolean contains(JSONPath.Context context) {
        this.eval(context);
        return context.value != null;
    }

    public boolean remove(JSONPath.Context context) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void set(JSONPath.Context context, Object value) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void setCallback(JSONPath.Context context, BiFunction callback) {
        throw new JSONException("UnsupportedOperation " + this.getClass());
    }

    public void setInt(JSONPath.Context context, int value) {
        this.set(context, value);
    }

    public void setLong(JSONPath.Context context, long value) {
        this.set(context, value);
    }

    static final class EntrySetSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final EntrySetSegment INSTANCE = new EntrySetSegment();

        EntrySetSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    Object value = jsonReader.readAny();
                    array.add(JSONObject.of("key", fieldName, "value", value));
                }
                context.value = array;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    array.add(JSONObject.of("key", entry.getKey(), "value", entry.getValue()));
                }
                context.value = array;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class KeysSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final KeysSegment INSTANCE = new KeysSegment();

        KeysSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (jsonReader.isObject()) {
                jsonReader.next();
                JSONArray array = new JSONArray();
                while (!jsonReader.nextIfObjectEnd()) {
                    String fieldName = jsonReader.readFieldName();
                    array.add(fieldName);
                    jsonReader.skipValue();
                }
                context.value = array;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).keySet());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class ValuesSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final ValuesSegment INSTANCE = new ValuesSegment();

        ValuesSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                context.value = new JSONArray((Collection<?>)((Map)object).values());
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class LengthSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final LengthSegment INSTANCE = new LengthSegment();

        LengthSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent == null) {
                context.root = jsonReader.readAny();
                context.eval = true;
            }
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            int length = 1;
            if (value instanceof Collection) {
                length = ((Collection)value).size();
            } else if (value.getClass().isArray()) {
                length = Array.getLength(value);
            } else if (value instanceof Map) {
                length = ((Map)value).size();
            } else if (value instanceof String) {
                length = ((String)value).length();
            } else if (value instanceof JSONPath.Sequence) {
                length = ((JSONPath.Sequence)value).values.size();
            }
            context.value = length;
        }
    }

    static final class SumSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final SumSegment INSTANCE = new SumSegment();

        SumSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        static Number add(Number a, Number b) {
            boolean bIsInt;
            boolean aIsInt = a instanceof Byte || a instanceof Short || a instanceof Integer || a instanceof Long;
            boolean bl = bIsInt = b instanceof Byte || b instanceof Short || b instanceof Integer || b instanceof Long;
            if (aIsInt && bIsInt) {
                return a.longValue() + b.longValue();
            }
            throw new JSONException("not support operation");
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Number sum = 0;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    sum = SumSegment.add(sum, (Number)item);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = sum;
            context.eval = true;
        }
    }

    static final class MaxSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final MaxSegment INSTANCE = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object max = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    if (max == null) {
                        max = item;
                        continue;
                    }
                    if (TypeUtils.compare(max, item) >= 0) continue;
                    max = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = max;
            context.eval = true;
        }
    }

    static final class MinSegment
    extends JSONPathSegment
    implements EvalSegment {
        static final MinSegment INSTANCE = new MinSegment();

        MinSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            this.eval(context);
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object value;
            Object object = value = context.parent == null ? context.root : context.parent.value;
            if (value == null) {
                return;
            }
            Object min = null;
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof Object[]) {
                Object[] array;
                for (Object item : array = (Object[])value) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else if (value instanceof JSONPath.Sequence) {
                for (Object item : ((JSONPath.Sequence)value).values) {
                    if (item == null) continue;
                    if (min == null) {
                        min = item;
                        continue;
                    }
                    if (TypeUtils.compare(min, item) <= 0) continue;
                    min = item;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            context.value = min;
            context.eval = true;
        }
    }

    static final class CycleNameSegment
    extends JSONPathSegment {
        static final long HASH_STAR = Fnv.hashCode64("*");
        final String name;
        final long nameHashCode;

        public CycleNameSegment(String name, long nameHashCode) {
            this.name = name;
            this.nameHashCode = nameHashCode;
        }

        public String toString() {
            return ".." + this.name;
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            this.set(context, null);
            context.eval = true;
            return true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            ObjectWriter<?> objectWriter;
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray values = new JSONArray();
            MapLoop action = new MapLoop(context, values);
            if (object instanceof Map) {
                Map map = (Map)object;
                map.forEach(action);
            } else if (object instanceof Collection) {
                ((Collection)object).forEach(action);
            } else if (object != null && (objectWriter = context.path.getWriterContext().getObjectWriter(object.getClass())) instanceof ObjectWriterAdapter) {
                action.accept(object);
            }
            context.value = values.size() == 1 && values.get(0) instanceof Collection ? values.get(0) : values;
            if (context.value instanceof List && context.next instanceof JSONPathFilter) {
                context.value = new JSONPath.Sequence((List)context.value);
            }
            context.eval = true;
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopSet action = new LoopSet(context, value);
            action.accept(object);
        }

        @Override
        public void setCallback(JSONPath.Context context, BiFunction callback) {
            Object object = context.parent == null ? context.root : context.parent.value;
            LoopCallback action = new LoopCallback(context, callback);
            action.accept(object);
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            JSONArray values = new JSONArray();
            this.accept(jsonReader, context, values);
            context.value = values;
            context.eval = true;
        }

        public void accept(JSONReader jsonReader, JSONPath.Context context, List<Object> values) {
            if (jsonReader.isJSONB()) {
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        boolean match;
                        long nameHashCode = jsonReader.readFieldNameHashCode();
                        if (nameHashCode == 0L) continue;
                        boolean bl = match = nameHashCode == this.nameHashCode;
                        if (match) {
                            if (jsonReader.isArray()) {
                                values.addAll(jsonReader.readArray());
                                continue;
                            }
                            values.add(jsonReader.readAny());
                            continue;
                        }
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                    return;
                }
                if (jsonReader.isArray()) {
                    int itemCnt = jsonReader.startArray();
                    for (int i2 = 0; i2 < itemCnt; ++i2) {
                        if (jsonReader.isObject() || jsonReader.isArray()) {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                } else {
                    jsonReader.skipValue();
                }
                return;
            }
            if (jsonReader.ch == '{') {
                jsonReader.next();
                block9: while (true) {
                    Object val2;
                    if (jsonReader.ch == '}') break;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (!match && ch != '{' && ch != '[') {
                        jsonReader.skipValue();
                        continue;
                    }
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val2 = jsonReader.getNumber();
                            break;
                        }
                        case '[': 
                        case '{': {
                            if (match) {
                                val2 = ch == '[' ? jsonReader.readArray() : jsonReader.readObject();
                                break;
                            }
                            this.accept(jsonReader, context, values);
                            continue block9;
                        }
                        case '\"': 
                        case '\'': {
                            val2 = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val2 = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val2 = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val2 instanceof Collection) {
                        values.addAll((Collection)val2);
                    } else {
                        values.add(val2);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else if (jsonReader.ch == '[') {
                block31: {
                    jsonReader.next();
                    do {
                        if (jsonReader.ch == ']') {
                            jsonReader.next();
                            break block31;
                        }
                        if (jsonReader.ch == '{' || jsonReader.ch == '[') {
                            this.accept(jsonReader, context, values);
                            continue;
                        }
                        jsonReader.skipValue();
                    } while (jsonReader.ch != ',');
                    jsonReader.next();
                }
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                jsonReader.skipValue();
            }
        }

        class MapLoop
        implements BiConsumer,
        Consumer {
            final JSONPath.Context context;
            final List values;

            public MapLoop(JSONPath.Context context, List values) {
                this.context = context;
                this.values = values;
            }

            public void accept(Object key, Object value) {
                if (CycleNameSegment.this.name.equals(key)) {
                    this.values.add(value);
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                    this.values.add(value);
                }
            }

            public void accept(Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof Map) {
                    ((Map)value).forEach(this);
                } else if (value instanceof List) {
                    ((List)value).forEach(this);
                } else {
                    ObjectWriter<?> objectWriter = this.context.path.getWriterContext().getObjectWriter(value.getClass());
                    if (objectWriter instanceof ObjectWriterAdapter) {
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null) {
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            if (fieldValue != null) {
                                this.values.add(fieldValue);
                            }
                            return;
                        }
                        for (int i2 = 0; i2 < objectWriter.getFieldWriters().size(); ++i2) {
                            fieldWriter = objectWriter.getFieldWriters().get(i2);
                            Object fieldValue = fieldWriter.getFieldValue(value);
                            this.accept(fieldValue);
                        }
                    } else if (CycleNameSegment.this.nameHashCode == HASH_STAR) {
                        this.values.add(value);
                    }
                }
            }
        }

        class LoopSet {
            final JSONPath.Context context;
            final Object value;

            public LoopSet(JSONPath.Context context, Object value) {
                this.context = context;
                this.value = value;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            entry.setValue(this.value);
                            this.context.eval = true;
                            continue;
                        }
                        Object entryValue = entry.getValue();
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    FieldReader fieldReader;
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean && (fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode)) != null) {
                        fieldReader.accept(object, this.value);
                        this.context.eval = true;
                        return;
                    }
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }

        class LoopCallback {
            final JSONPath.Context context;
            final BiFunction callback;

            public LoopCallback(JSONPath.Context context, BiFunction callback) {
                this.context = context;
                this.callback = callback;
            }

            public void accept(Object object) {
                if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        Object entryValue = entry.getValue();
                        if (CycleNameSegment.this.name.equals(entry.getKey())) {
                            Object applyValue = this.callback.apply(object, entryValue);
                            entry.setValue(applyValue);
                            this.context.eval = true;
                            continue;
                        }
                        if (entryValue == null) continue;
                        this.accept(entryValue);
                    }
                } else if (object instanceof Collection) {
                    for (Object e : (List)object) {
                        this.accept(e);
                    }
                } else {
                    Class<?> entryValueClass = object.getClass();
                    ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(entryValueClass);
                    ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(entryValueClass);
                    if (objectReader instanceof ObjectReaderBean) {
                        FieldReader fieldReader = objectReader.getFieldReader(CycleNameSegment.this.nameHashCode);
                        FieldWriter fieldWriter = objectWriter.getFieldWriter(CycleNameSegment.this.nameHashCode);
                        if (fieldWriter != null && fieldReader != null) {
                            Object fieldValue = fieldWriter.getFieldValue(object);
                            fieldValue = this.callback.apply(object, fieldValue);
                            fieldReader.accept(object, fieldValue);
                            this.context.eval = true;
                            return;
                        }
                    }
                    List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
                    for (FieldWriter fieldWriter : fieldWriters) {
                        Object fieldValue = fieldWriter.getFieldValue(object);
                        this.accept(fieldValue);
                    }
                }
            }
        }
    }

    static final class RootSegment
    extends JSONPathSegment {
        static final RootSegment INSTANCE = new RootSegment();

        protected RootSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null) {
                throw new JSONException("not support operation");
            }
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            context.value = object = context.parent == null ? context.root : context.parent.root;
        }
    }

    static final class SelfSegment
    extends JSONPathSegment {
        static final SelfSegment INSTANCE = new SelfSegment();

        protected SelfSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            context.value = jsonReader.readAny();
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            context.value = context.parent == null ? context.root : context.parent.value;
        }
    }

    static final class AllSegment
    extends JSONPathSegment {
        static final AllSegment INSTANCE = new AllSegment(false);
        static final AllSegment INSTANCE_ARRAY = new AllSegment(true);
        final boolean array;

        AllSegment(boolean array) {
            this.array = array;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                context.value = null;
                context.eval = true;
                return;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(map.size());
                for (Object value : map.values()) {
                    if (this.array && value instanceof Collection) {
                        array.addAll((Collection)value);
                        continue;
                    }
                    array.add(value);
                }
                context.value = context.next != null ? new JSONPath.Sequence(array) : array;
                context.eval = true;
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null && !this.array) {
                    for (Object item : list) {
                        if (item instanceof Map) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = context.next != null ? new JSONPath.Sequence(list) : object;
                context.eval = true;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                context.eval = true;
                return;
            }
            if (object instanceof JSONPath.Sequence) {
                List list = ((JSONPath.Sequence)object).values;
                JSONArray values = new JSONArray(list.size());
                if (context.next == null) {
                    for (Object item : list) {
                        if (item instanceof Map && !this.array) {
                            values.addAll(((Map)item).values());
                            continue;
                        }
                        if (item instanceof Collection) {
                            Collection collection = (Collection)item;
                            values.addAll(collection);
                            continue;
                        }
                        values.add(item);
                    }
                    context.value = values;
                    context.eval = true;
                    return;
                }
                context.value = new JSONPath.Sequence(list);
                context.eval = true;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            int size = fieldWriters.size();
            JSONArray array = new JSONArray(size);
            for (int i2 = 0; i2 < size; ++i2) {
                Object fieldValue = fieldWriters.get(i2).getFieldValue(object);
                array.add(fieldValue);
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                ((Map)object).clear();
                return true;
            }
            if (object instanceof Collection) {
                ((Collection)object).clear();
                return true;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    entry.setValue(value);
                }
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    list.set(i2, value);
                }
                return;
            }
            if (object != null && object.getClass().isArray()) {
                int len = Array.getLength(object);
                for (int i3 = 0; i3 < len; ++i3) {
                    Array.set(object, i3, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public void setCallback(JSONPath.Context context, BiFunction callback) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object apply = callback.apply(object, value);
                    if (apply == value) continue;
                    entry.setValue(apply);
                }
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e = list.get(i2);
                    Object apply = callback.apply(object, e);
                    if (apply == e) continue;
                    list.set(i2, apply);
                }
                return;
            }
            if (object != null && object.getClass().isArray()) {
                int len = Array.getLength(object);
                for (int i3 = 0; i3 < len; ++i3) {
                    Object object3 = Array.get(object, i3);
                    Object apply = callback.apply(object, object3);
                    if (apply == object3) continue;
                    Array.set(object, i3, apply);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && context.parent.eval) {
                this.eval(context);
                return;
            }
            if (jsonReader.isEnd()) {
                context.eval = true;
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray values = new JSONArray();
                if (jsonReader.nextIfMatch((byte)-90)) {
                    while (!jsonReader.nextIfMatch((byte)-91)) {
                        if (!jsonReader.skipName()) continue;
                        Object val2 = jsonReader.readAny();
                        if (this.array && val2 instanceof Collection) {
                            values.addAll((Collection)val2);
                            continue;
                        }
                        values.add(val2);
                    }
                    context.value = values;
                    return;
                }
                if (jsonReader.isArray() && context.next != null) {
                    return;
                }
                throw new JSONException("TODO");
            }
            boolean alwaysReturnList = context.next == null && (context.path.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L;
            JSONArray values = new JSONArray();
            if (jsonReader.nextIfMatch('{')) {
                block10: while (true) {
                    Object val3;
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                        break;
                    }
                    jsonReader.skipName();
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val3 = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val3 = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val3 = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val3 = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val3 = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val3 = null;
                            break;
                        }
                        case ']': {
                            jsonReader.next();
                            break block10;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    if (val3 instanceof Collection) {
                        if (alwaysReturnList) {
                            values.add(val3);
                        } else {
                            values.addAll((Collection)val3);
                        }
                    } else {
                        values.add(val3);
                    }
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                context.value = values;
                context.eval = true;
                return;
            }
            if (jsonReader.ch == '[') {
                jsonReader.next();
                while (true) {
                    if (jsonReader.ch == ']') break;
                    Object value = jsonReader.readAny();
                    values.add(value);
                    if (jsonReader.ch != ',') continue;
                    jsonReader.next();
                }
                jsonReader.next();
                context.value = context.next != null ? new JSONPath.Sequence(values) : values;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static final class MultiNameSegment
    extends JSONPathSegment {
        final String[] names;
        final long[] nameHashCodes;
        final Set<String> nameSet;

        public MultiNameSegment(String[] names) {
            this.names = names;
            this.nameHashCodes = new long[names.length];
            this.nameSet = new HashSet<String>();
            for (int i2 = 0; i2 < names.length; ++i2) {
                this.nameHashCodes[i2] = Fnv.hashCode64(names[i2]);
                this.nameSet.add(names[i2]);
            }
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i2]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof JSONPathFilter || context.parent.current instanceof MultiIndexSegment)) {
                this.eval(context);
                return;
            }
            Object object = jsonReader.readAny();
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONArray array = new JSONArray(this.names.length);
                for (String name : this.names) {
                    Object value = map.get(name);
                    array.add(value);
                }
                context.value = array;
                return;
            }
            if (object instanceof Collection) {
                context.value = object;
                return;
            }
            ObjectWriterProvider provider = context.path.getWriterContext().provider;
            ObjectWriter objectWriter = provider.getObjectWriter(object.getClass());
            JSONArray array = new JSONArray(this.names.length);
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCodes[i2]);
                Object fieldValue = null;
                if (fieldWriter != null) {
                    fieldValue = fieldWriter.getFieldValue(object);
                }
                array.add(fieldValue);
            }
            context.value = array;
        }
    }

    static final class MultiIndexSegment
    extends JSONPathSegment {
        final int[] indexes;

        public MultiIndexSegment(int[] indexes) {
            this.indexes = indexes;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof JSONPath.Sequence) {
                List list = ((JSONPath.Sequence)object).values;
                for (Object item : list) {
                    context.value = item;
                    JSONPath.Context itemContext = new JSONPath.Context(context.path, context, context.current, context.next, context.readerFeatures);
                    this.eval(itemContext);
                    Object value = itemContext.value;
                    if (value instanceof Collection) {
                        result.addAll((Collection)value);
                        continue;
                    }
                    result.add(value);
                }
                context.value = result;
                return;
            }
            for (int index : this.indexes) {
                int itemIndex;
                Object value;
                if (object instanceof List) {
                    List list = (List)object;
                    if (index >= 0) {
                        if (index >= list.size()) continue;
                        value = list.get(index);
                    } else {
                        itemIndex = list.size() + index;
                        if (itemIndex < 0) continue;
                        value = list.get(itemIndex);
                    }
                } else {
                    if (!(object instanceof Object[])) continue;
                    Object[] array = (Object[])object;
                    if (index >= 0) {
                        if (index >= array.length) continue;
                        value = array[index];
                    } else {
                        itemIndex = array.length + index;
                        if (itemIndex < 0) continue;
                        value = array[itemIndex];
                    }
                }
                if (value instanceof Collection) {
                    result.addAll((Collection)value);
                    continue;
                }
                result.add(value);
            }
            context.value = result;
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && context.parent.current instanceof CycleNameSegment && context.next == null) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i2 = 0; i2 < itemCnt; ++i2) {
                    boolean match;
                    boolean bl = match = Arrays.binarySearch(this.indexes, i2) >= 0;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                context.value = array;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i3 = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = Arrays.binarySearch(this.indexes, i3) >= 0;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val2;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val2 = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val2 = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val2 = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val2 = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val2 = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val2 = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val2);
                }
                ++i3;
            }
            context.value = array;
        }
    }

    static final class RangeIndexSegment
    extends JSONPathSegment {
        final int begin;
        final int end;

        public RangeIndexSegment(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object = context.parent == null ? context.root : context.parent.value;
            JSONArray result = new JSONArray();
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i2 >= this.begin && i2 < this.end;
                    } else {
                        int ni = i2 - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    result.add(list.get(i2));
                }
                context.value = result;
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                for (int i3 = 0; i3 < array.length; ++i3) {
                    boolean match;
                    boolean bl = match = i3 >= this.begin && i3 <= this.end || i3 - array.length > this.begin && i3 - array.length <= this.end;
                    if (!match) continue;
                    result.add(array[i3]);
                }
                context.value = result;
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                int i2;
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (i2 = 0; i2 < itemCnt; ++i2) {
                    boolean match;
                    boolean bl = match = this.begin < 0 || i2 >= this.begin && i2 < this.end;
                    if (!match) {
                        jsonReader.skipValue();
                        continue;
                    }
                    array.add(jsonReader.readAny());
                }
                if (this.begin < 0) {
                    int size = array.size();
                    for (i2 = size - 1; i2 >= 0; --i2) {
                        int ni = i2 - size;
                        if (ni >= this.begin && ni < this.end) continue;
                        array.remove(i2);
                    }
                }
                context.value = array;
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i3 = 0;
            while (jsonReader.ch != '\u001a') {
                boolean match;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                boolean bl = match = this.begin < 0 || i3 >= this.begin && i3 < this.end;
                if (!match) {
                    jsonReader.skipValue();
                    if (jsonReader.ch == ',') {
                        jsonReader.next();
                    }
                } else {
                    Object val2;
                    switch (jsonReader.ch) {
                        case '+': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            jsonReader.readNumber0();
                            val2 = jsonReader.getNumber();
                            break;
                        }
                        case '[': {
                            val2 = jsonReader.readArray();
                            break;
                        }
                        case '{': {
                            val2 = jsonReader.readObject();
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            val2 = jsonReader.readString();
                            break;
                        }
                        case 'f': 
                        case 't': {
                            val2 = jsonReader.readBoolValue();
                            break;
                        }
                        case 'n': {
                            jsonReader.readNull();
                            val2 = null;
                            break;
                        }
                        default: {
                            throw new JSONException("TODO : " + jsonReader.ch);
                        }
                    }
                    array.add(val2);
                }
                ++i3;
            }
            if (this.begin < 0) {
                int size = array.size();
                for (int i4 = size - 1; i4 >= 0; --i4) {
                    int ni = i4 - size;
                    if (ni >= this.begin && ni < this.end) continue;
                    array.remove(i4);
                }
            }
            context.value = array;
            context.eval = true;
        }

        @Override
        public void set(JSONPath.Context context, Object value) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int size = list.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i2 >= this.begin && i2 < this.end;
                    } else {
                        int ni = i2 - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.set(i2, value);
                }
                return;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }

        @Override
        public boolean remove(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                int removeCount = 0;
                int size = list.size();
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    boolean match;
                    if (this.begin >= 0) {
                        match = i2 >= this.begin && i2 < this.end;
                    } else {
                        int ni = i2 - size;
                        boolean bl = match = ni >= this.begin && ni < this.end;
                    }
                    if (!match) continue;
                    list.remove(i2);
                    ++removeCount;
                }
                return removeCount > 0;
            }
            throw new JSONException("UnsupportedOperation " + this.getClass());
        }
    }

    static final class RandomIndexSegment
    extends JSONPathSegment {
        public static final RandomIndexSegment INSTANCE = new RandomIndexSegment();
        Random random;

        RandomIndexSegment() {
        }

        @Override
        public void accept(JSONReader jsonReader, JSONPath.Context context) {
            if (context.parent != null && (context.parent.eval || context.parent.current instanceof CycleNameSegment && context.next == null)) {
                this.eval(context);
                return;
            }
            if (jsonReader.isJSONB()) {
                JSONArray array = new JSONArray();
                int itemCnt = jsonReader.startArray();
                for (int i2 = 0; i2 < itemCnt; ++i2) {
                    array.add(jsonReader.readAny());
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int index = Math.abs(this.random.nextInt()) % array.size();
                context.value = array.get(index);
                context.eval = true;
                return;
            }
            JSONArray array = new JSONArray();
            jsonReader.next();
            int i3 = 0;
            while (jsonReader.ch != '\u001a') {
                Object val2;
                if (jsonReader.ch == ']') {
                    jsonReader.next();
                    break;
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val2 = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        val2 = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        val2 = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val2 = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val2 = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val2 = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                array.add(val2);
                ++i3;
            }
            if (this.random == null) {
                this.random = new Random();
            }
            int index = Math.abs(this.random.nextInt()) % array.size();
            context.value = array.get(index);
            context.eval = true;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = Math.abs(this.random.nextInt()) % list.size();
                context.value = list.get(randomIndex);
                context.eval = true;
                return;
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                if (array.length == 0) {
                    return;
                }
                if (this.random == null) {
                    this.random = new Random();
                }
                int randomIndex = this.random.nextInt() % array.length;
                context.value = array[randomIndex];
                context.eval = true;
                return;
            }
            throw new JSONException("TODO");
        }
    }

    static interface EvalSegment {
    }
}

