/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiFunction;

final class JSONPathSegmentIndex
extends JSONPathSegment {
    static final JSONPathSegmentIndex ZERO = new JSONPathSegmentIndex(0);
    static final JSONPathSegmentIndex ONE = new JSONPathSegmentIndex(1);
    static final JSONPathSegmentIndex TWO = new JSONPathSegmentIndex(2);
    static final JSONPathSegmentIndex LAST = new JSONPathSegmentIndex(-1);
    final int index;

    public JSONPathSegmentIndex(int index) {
        this.index = index;
    }

    static JSONPathSegmentIndex of(int index) {
        if (index == 0) {
            return ZERO;
        }
        if (index == 1) {
            return ONE;
        }
        if (index == 2) {
            return TWO;
        }
        if (index == -1) {
            return LAST;
        }
        return new JSONPathSegmentIndex(index);
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            context.eval = true;
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    context.value = list.get(this.index);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0 && itemIndex < list.size()) {
                    context.value = list.get(itemIndex);
                }
            }
            context.eval = true;
            return;
        }
        if (object instanceof SortedSet || object instanceof LinkedHashSet || this.index == 0 && object instanceof Collection && ((Collection)object).size() == 1) {
            Collection collection = (Collection)object;
            int i2 = 0;
            for (Object item : collection) {
                if (i2 == this.index) {
                    context.value = item;
                    break;
                }
                ++i2;
            }
            context.eval = true;
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    context.value = array[this.index];
                }
            } else {
                int itemIndex = array.length + this.index;
                if (itemIndex >= 0 && itemIndex < array.length) {
                    context.value = array[itemIndex];
                }
            }
            context.eval = true;
            return;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    context.value = Array.get(object, this.index);
                }
            } else {
                int itemIndex = length + this.index;
                if (itemIndex >= 0 && itemIndex < length) {
                    context.value = Array.get(object, itemIndex);
                }
            }
            context.eval = true;
            return;
        }
        if (object instanceof JSONPath.Sequence) {
            List sequence = ((JSONPath.Sequence)object).values;
            JSONArray values = new JSONArray(sequence.size());
            for (int i3 = 0; i3 < sequence.size(); ++i3) {
                context.value = sequence.get(i3);
                JSONPath.Context itemContext = new JSONPath.Context(context.path, context, context.current, context.next, context.readerFeatures);
                this.eval(itemContext);
                values.add(itemContext.value);
            }
            context.value = context.next != null ? new JSONPath.Sequence(values) : values;
            context.eval = true;
            return;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            context.value = this.eval((Map)object);
            context.eval = true;
            return;
        }
        if (this.index == 0) {
            context.value = object;
            context.eval = true;
            return;
        }
        throw new JSONException("jsonpath not support operate : " + context.path + ", objectClass" + objectClass.getName());
    }

    private Object eval(Map object) {
        Object value;
        block6: {
            Map map = object;
            value = map.get(this.index);
            if (value == null) {
                value = map.get(Integer.toString(this.index));
            }
            if (value != null) break block6;
            int size = map.size();
            Iterator it = map.entrySet().iterator();
            if (size == 1 || map instanceof LinkedHashMap || map instanceof SortedMap) {
                for (int i2 = 0; i2 <= this.index && i2 < size && it.hasNext(); ++i2) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (entryKey instanceof Long) {
                        if (!entryKey.equals(this.index)) continue;
                        value = entryValue;
                        break;
                    }
                    if (i2 != this.index) continue;
                    value = entryValue;
                }
            } else {
                for (int i3 = 0; i3 <= this.index && i3 < map.size() && it.hasNext(); ++i3) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (!(entryKey instanceof Long) || !entryKey.equals(this.index)) continue;
                    value = entryValue;
                    break;
                }
            }
        }
        return value;
    }

    @Override
    public void set(JSONPath.Context context, Object value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index > list.size()) {
                    for (int i2 = list.size(); i2 < this.index; ++i2) {
                        list.add(null);
                    }
                }
                if (this.index < list.size()) {
                    list.set(this.index, value);
                } else if (this.index <= list.size()) {
                    list.add(value);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    list.set(itemIndex, value);
                }
            }
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            int length = array.length;
            if (this.index >= 0) {
                if (this.index < length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0 && arrayIndex < length) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        if (object != null && object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    Array.set(object, this.index, value);
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0 && arrayIndex < length) {
                    Array.set(object, arrayIndex, value);
                }
            }
            return;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void setCallback(JSONPath.Context context, BiFunction callback) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    Object value = list.get(this.index);
                    value = callback.apply(object, value);
                    list.set(this.index, value);
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    Object value = list.get(itemIndex);
                    value = callback.apply(object, value);
                    list.set(itemIndex, value);
                }
            }
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    Object value = array[this.index];
                    array[this.index] = value = callback.apply(object, value);
                }
            } else {
                int itemIndex = array.length + this.index;
                if (itemIndex >= 0) {
                    Object value = array[itemIndex];
                    array[itemIndex] = value = callback.apply(object, value);
                }
            }
            return;
        }
        if (object != null && object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (this.index >= 0) {
                if (this.index < length) {
                    Object value = Array.get(object, this.index);
                    value = callback.apply(object, value);
                    Array.set(object, this.index, value);
                }
            } else {
                int arrayIndex = length + this.index;
                if (arrayIndex >= 0) {
                    Object value = Array.get(object, arrayIndex);
                    value = callback.apply(object, value);
                    Array.set(object, arrayIndex, value);
                }
            }
            return;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public boolean remove(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof List) {
            List list = (List)object;
            if (this.index >= 0) {
                if (this.index < list.size()) {
                    list.remove(this.index);
                    return true;
                }
            } else {
                int itemIndex = list.size() + this.index;
                if (itemIndex >= 0) {
                    list.remove(itemIndex);
                    return true;
                }
            }
            return false;
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public void setInt(JSONPath.Context context, int value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof int[]) {
            int[] array = (int[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        this.set(context, value);
    }

    @Override
    public void setLong(JSONPath.Context context, long value) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object instanceof int[]) {
            int[] array = (int[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = (int)value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = (int)value;
                }
            }
            return;
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            if (this.index >= 0) {
                if (this.index < array.length) {
                    array[this.index] = value;
                }
            } else {
                int arrayIndex = array.length + this.index;
                if (arrayIndex >= 0) {
                    array[arrayIndex] = value;
                }
            }
            return;
        }
        this.set(context, value);
    }

    @Override
    public void accept(JSONReader jsonReader, JSONPath.Context context) {
        if (context.parent != null && (context.parent.eval || context.parent.current instanceof JSONPathSegment.CycleNameSegment && context.next == null)) {
            this.eval(context);
            return;
        }
        if (jsonReader.isJSONB()) {
            int itemCnt = jsonReader.startArray();
            for (int i2 = 0; i2 < itemCnt; ++i2) {
                boolean match;
                boolean bl = match = this.index == i2;
                if (match) {
                    if ((jsonReader.isArray() || jsonReader.isObject()) && context.next != null) break;
                    context.value = jsonReader.readAny();
                    context.eval = true;
                    break;
                }
                jsonReader.skipValue();
            }
            return;
        }
        if (jsonReader.ch == '{') {
            Map<String, Object> object = jsonReader.readObject();
            context.value = this.eval(object);
            context.eval = true;
            return;
        }
        jsonReader.next();
        int i3 = 0;
        block9: while (jsonReader.ch != '\u001a') {
            boolean match;
            if (jsonReader.ch == ']') {
                jsonReader.next();
                break;
            }
            boolean bl = match = this.index == -1 || this.index == i3;
            if (!match) {
                jsonReader.skipValue();
                if (jsonReader.ch == ',') {
                    jsonReader.next();
                }
            } else {
                Map<String, Object> val2;
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        jsonReader.readNumber0();
                        val2 = jsonReader.getNumber();
                        break;
                    }
                    case '[': {
                        if (context.next != null && !(context.next instanceof JSONPathSegment.EvalSegment)) break block9;
                        val2 = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        if (context.next != null && !(context.next instanceof JSONPathSegment.EvalSegment)) break block9;
                        val2 = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val2 = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val2 = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val2 = null;
                        break;
                    }
                    default: {
                        throw new JSONException(jsonReader.info("not support : " + jsonReader.ch));
                    }
                }
                if (this.index == -1) {
                    if (jsonReader.ch == ']') {
                        context.value = val2;
                    }
                } else {
                    context.value = val2;
                }
            }
            ++i3;
        }
    }

    public String toString() {
        int size = this.index < 0 ? IOUtils.stringSize(-this.index) + 1 : IOUtils.stringSize(this.index);
        byte[] bytes = new byte[size + 2];
        bytes[0] = 91;
        IOUtils.getChars(this.index, bytes.length - 1, bytes);
        bytes[bytes.length - 1] = 93;
        String str = JDKUtils.STRING_CREATOR_JDK11 != null ? JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1) : new String(bytes, StandardCharsets.ISO_8859_1);
        return str;
    }
}

