/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.asm;

import com.alibaba.fastjson2.internal.asm.ByteVector;
import com.alibaba.fastjson2.internal.asm.ClassWriter;
import com.alibaba.fastjson2.internal.asm.Symbol;

final class SymbolTable {
    final ClassWriter classWriter;
    private int majorVersion;
    String className;
    private int entryCount;
    private Entry[] entries;
    int constantPoolCount;
    ByteVector constantPool;
    private int typeCount;
    Entry[] typeTable;

    SymbolTable(ClassWriter classWriter) {
        this.classWriter = classWriter;
        this.entries = new Entry[256];
        this.constantPoolCount = 1;
        this.constantPool = new ByteVector(4096);
    }

    int setMajorVersionAndClassName(int majorVersion, String className) {
        this.majorVersion = majorVersion;
        this.className = className;
        return this.addConstantUtf8Reference((int)7, (String)className).index;
    }

    private Entry put(Entry entry) {
        if (this.entryCount > this.entries.length * 3 / 4) {
            int currentCapacity = this.entries.length;
            int newCapacity = currentCapacity * 2 + 1;
            Entry[] newEntries = new Entry[newCapacity];
            for (int i2 = currentCapacity - 1; i2 >= 0; --i2) {
                Entry currentEntry = this.entries[i2];
                while (currentEntry != null) {
                    int newCurrentEntryIndex = currentEntry.hashCode % newCapacity;
                    Entry nextEntry = currentEntry.next;
                    currentEntry.next = newEntries[newCurrentEntryIndex];
                    newEntries[newCurrentEntryIndex] = currentEntry;
                    currentEntry = nextEntry;
                }
            }
            this.entries = newEntries;
        }
        ++this.entryCount;
        int index = entry.hashCode % this.entries.length;
        entry.next = this.entries[index];
        this.entries[index] = entry;
        return this.entries[index];
    }

    Entry addConstantMemberReference(int tag, String owner, String name, String descriptor) {
        int hashCode = Integer.MAX_VALUE & tag + owner.hashCode() * name.hashCode() * descriptor.hashCode();
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.owner.equals(owner) && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(tag, this.addConstantUtf8Reference((int)7, (String)owner).index, this.addConstantNameAndType(name, descriptor));
        return this.put(new Entry(this.constantPoolCount++, tag, owner, name, descriptor, 0L, hashCode));
    }

    Symbol addConstantIntegerOrFloat(int tag, int value) {
        int hashCode = Integer.MAX_VALUE & tag + value;
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.data == (long)value) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(tag).putInt(value);
        return this.put(new Entry(this.constantPoolCount++, tag, value, hashCode));
    }

    Symbol addConstantLongOrDouble(int tag, long value) {
        int hashCode = Integer.MAX_VALUE & tag + (int)value + (int)(value >>> 32);
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.data == value) {
                return entry;
            }
            entry = entry.next;
        }
        int index = this.constantPoolCount;
        this.constantPool.putByte(tag).putLong(value);
        this.constantPoolCount += 2;
        return this.put(new Entry(index, tag, value, hashCode));
    }

    int addConstantNameAndType(String name, String descriptor) {
        int CONSTANT_NAME_AND_TYPE_TAG = 12;
        int tag = 12;
        int hashCode = Integer.MAX_VALUE & 12 + name.hashCode() * descriptor.hashCode();
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == 12 && entry.hashCode == hashCode && entry.name.equals(name) && entry.value.equals(descriptor)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(name), this.addConstantUtf8(descriptor));
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)12, (String)name, (String)descriptor, (int)hashCode)).index;
    }

    int addConstantUtf8(String value) {
        boolean CONSTANT_UTF8_TAG = true;
        int hashCode = Integer.MAX_VALUE & 1 + value.hashCode();
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == 1 && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(1).putUTF8(value);
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)1, (String)value, (int)hashCode)).index;
    }

    Symbol addConstantUtf8Reference(int tag, String value) {
        int hashCode = Integer.MAX_VALUE & tag + value.hashCode();
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == tag && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put12(tag, this.addConstantUtf8(value));
        return this.put(new Entry(this.constantPoolCount++, tag, value, hashCode));
    }

    int addType(String value) {
        int TYPE_TAG = 128;
        int hashCode = Integer.MAX_VALUE & 128 + value.hashCode();
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == 128 && entry.hashCode == hashCode && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 128, value, hashCode));
    }

    int addUninitializedType(String value, int bytecodeOffset) {
        int UNINITIALIZED_TYPE_TAG = 129;
        int hashCode = Integer.MAX_VALUE & 129 + value.hashCode() + bytecodeOffset;
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == 129 && entry.hashCode == hashCode && entry.data == (long)bytecodeOffset && entry.value.equals(value)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 129, value, bytecodeOffset, hashCode));
    }

    int addMergedType(int typeTableIndex1, int typeTableIndex2) {
        int commonSuperTypeIndex;
        int MERGED_TYPE_TAG = 130;
        long data = typeTableIndex1 < typeTableIndex2 ? (long)typeTableIndex1 | (long)typeTableIndex2 << 32 : (long)typeTableIndex2 | (long)typeTableIndex1 << 32;
        int hashCode = Integer.MAX_VALUE & 130 + typeTableIndex1 + typeTableIndex2;
        Entry entry = this.entries[hashCode % this.entries.length];
        while (entry != null) {
            if (entry.tag == 130 && entry.hashCode == hashCode && entry.data == data) {
                return entry.info;
            }
            entry = entry.next;
        }
        String type1 = this.typeTable[typeTableIndex1].value;
        String type2 = this.typeTable[typeTableIndex2].value;
        this.put((Entry)new Entry((int)this.typeCount, (int)130, (long)data, (int)hashCode)).info = commonSuperTypeIndex = this.addType(this.classWriter.getCommonSuperClass(type1, type2));
        return commonSuperTypeIndex;
    }

    private int addTypeInternal(Entry entry) {
        if (this.typeTable == null) {
            this.typeTable = new Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            Entry[] newTypeTable = new Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, newTypeTable, 0, this.typeTable.length);
            this.typeTable = newTypeTable;
        }
        this.typeTable[this.typeCount++] = entry;
        return this.put((Entry)entry).index;
    }

    static class Entry
    extends Symbol {
        final int hashCode;
        Entry next;

        Entry(int index, int tag, String owner, String name, String value, long data, int hashCode) {
            super(index, tag, owner, name, value, data);
            this.hashCode = hashCode;
        }

        Entry(int index, int tag, String value, int hashCode) {
            super(index, tag, null, null, value, 0L);
            this.hashCode = hashCode;
        }

        Entry(int index, int tag, String value, long data, int hashCode) {
            super(index, tag, null, null, value, data);
            this.hashCode = hashCode;
        }

        Entry(int index, int tag, String name, String value, int hashCode) {
            super(index, tag, null, name, value, 0L);
            this.hashCode = hashCode;
        }

        Entry(int index, int tag, long data, int hashCode) {
            super(index, tag, null, null, null, data);
            this.hashCode = hashCode;
        }
    }
}

