/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderAnySetter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderAdapter<T>
extends ObjectReaderBean<T> {
    protected final String typeKey;
    protected final long typeKeyHashCode;
    final FieldReader[] fieldReaders;
    final long[] hashCodes;
    final short[] mapping;
    final long[] hashCodesLCase;
    final short[] mappingLCase;
    final Constructor constructor;
    volatile boolean instantiationError;
    final Class[] seeAlso;
    final String[] seeAlsoNames;
    final Class seeAlsoDefault;
    final Map<Long, Class> seeAlsoMapping;

    public ObjectReaderAdapter(Class objectClass, Supplier<T> creator, FieldReader ... fieldReaders) {
        this(objectClass, null, null, 0L, null, creator, null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        this(objectClass, typeKey, typeName, features, schema, creator, buildFunction, (Class[])null, (String[])null, (Class)null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        this(objectClass, typeKey, typeName, features, schema, creator, buildFunction, seeAlso, seeAlsoNames, (Class)null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, Class[] seeAlso, String[] seeAlsoNames, Class seeAlsoDefault, FieldReader ... fieldReaders) {
        super(objectClass, creator, typeName, features, schema, buildFunction);
        int index;
        int i2;
        Constructor constructor = this.constructor = objectClass == null ? null : BeanUtils.getDefaultConstructor(objectClass, true);
        if (this.constructor != null) {
            this.constructor.setAccessible(true);
        }
        if (typeKey == null || typeKey.isEmpty()) {
            this.typeKey = "@type";
            this.typeKeyHashCode = HASH_TYPE;
        } else {
            this.typeKey = typeKey;
            this.typeKeyHashCode = Fnv.hashCode64(typeKey);
        }
        this.fieldReaders = fieldReaders;
        long[] hashCodes = new long[fieldReaders.length];
        long[] hashCodesLCase = new long[fieldReaders.length];
        for (i2 = 0; i2 < fieldReaders.length; ++i2) {
            FieldReader fieldReader = fieldReaders[i2];
            hashCodes[i2] = fieldReader.fieldNameHash;
            hashCodesLCase[i2] = fieldReader.fieldNameHashLCase;
            if (fieldReader.isUnwrapped() && (this.extraFieldReader == null || !(this.extraFieldReader instanceof FieldReaderAnySetter))) {
                this.extraFieldReader = fieldReader;
            }
            if (fieldReader.defaultValue == null) continue;
            this.hasDefaultValue = true;
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i2 = 0; i2 < hashCodes.length; ++i2) {
            long hashCode = hashCodes[i2];
            index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i2;
        }
        this.hashCodesLCase = Arrays.copyOf(hashCodesLCase, hashCodesLCase.length);
        Arrays.sort(this.hashCodesLCase);
        this.mappingLCase = new short[this.hashCodesLCase.length];
        for (i2 = 0; i2 < hashCodesLCase.length; ++i2) {
            long hashCode = hashCodesLCase[i2];
            index = Arrays.binarySearch(this.hashCodesLCase, hashCode);
            this.mappingLCase[index] = (short)i2;
        }
        this.seeAlso = seeAlso;
        if (seeAlso != null) {
            this.seeAlsoMapping = new HashMap<Long, Class>(seeAlso.length);
            this.seeAlsoNames = new String[seeAlso.length];
            for (i2 = 0; i2 < seeAlso.length; ++i2) {
                Class seeAlsoClass = seeAlso[i2];
                String seeAlsoTypeName = null;
                if (seeAlsoNames != null && seeAlsoNames.length >= i2 + 1) {
                    seeAlsoTypeName = seeAlsoNames[i2];
                }
                if (seeAlsoTypeName == null || seeAlsoTypeName.isEmpty()) {
                    seeAlsoTypeName = seeAlsoClass.getSimpleName();
                }
                long hashCode = Fnv.hashCode64(seeAlsoTypeName);
                this.seeAlsoMapping.put(hashCode, seeAlsoClass);
                this.seeAlsoNames[i2] = seeAlsoTypeName;
            }
        } else {
            this.seeAlsoMapping = null;
            this.seeAlsoNames = null;
        }
        this.seeAlsoDefault = seeAlsoDefault;
    }

    @Override
    public final String getTypeKey() {
        return this.typeKey;
    }

    @Override
    public final long getTypeKeyHash() {
        return this.typeKeyHashCode;
    }

    @Override
    public final long getFeatures() {
        return this.features;
    }

    public FieldReader[] getFieldReaders() {
        return Arrays.copyOf(this.fieldReaders, this.fieldReaders.length);
    }

    public Object auoType(JSONReader jsonReader, Class expectClass, long features) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), expectClass, this.features | features | context.getFeatures())) == null) {
            throw new JSONException(jsonReader.info("auotype not support : " + typeName));
        }
        return autoTypeObjectReader.readObject(jsonReader, null, null, features);
    }

    @Override
    public final Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T readArrayMappingObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        jsonReader.nextIfMatch('[');
        Object object = this.creator.get();
        for (FieldReader fieldReader : this.fieldReaders) {
            fieldReader.readFieldValue(jsonReader, object);
        }
        if (!jsonReader.nextIfMatch(']')) {
            throw new JSONException(jsonReader.info("array to bean end error"));
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        int i2;
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features)) != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        int entryCnt = jsonReader.startArray();
        T object = this.createInstance(0L);
        for (i2 = 0; i2 < this.fieldReaders.length; ++i2) {
            if (i2 >= entryCnt) continue;
            FieldReader fieldReader = this.fieldReaders[i2];
            fieldReader.readFieldValue(jsonReader, object);
        }
        for (i2 = this.fieldReaders.length; i2 < entryCnt; ++i2) {
            jsonReader.skipValue();
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    protected Object createInstance0(long features) throws InstantiationException {
        if ((features & JSONReader.Feature.UseDefaultConstructorAsPossible.mask) != 0L && this.constructor != null && this.constructor.getParameterCount() == 0) {
            Object object;
            try {
                object = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return object;
        }
        if (this.creator == null) {
            throw new JSONException("create instance error, " + this.objectClass);
        }
        return this.creator.get();
    }

    @Override
    protected void initDefaultValue(T object) {
        for (FieldReader fieldReader : this.fieldReaders) {
            Object defaultValue = fieldReader.defaultValue;
            if (defaultValue == null) continue;
            fieldReader.accept(object, defaultValue);
        }
    }

    @Override
    public T createInstance(Collection collection) {
        T object = this.createInstance(0L);
        int index = 0;
        for (Object fieldValue : collection) {
            if (index >= this.fieldReaders.length) break;
            FieldReader fieldReader = this.fieldReaders[index];
            fieldReader.accept(object, fieldValue);
            ++index;
        }
        return object;
    }

    @Override
    public T createInstance(long features) {
        if (this.instantiationError && this.constructor != null) {
            Object object;
            try {
                object = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return object;
        }
        try {
            Object object = this.createInstance0(features);
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return (T)object;
        }
        catch (InstantiationException ex) {
            InstantiationException error = ex;
            this.instantiationError = true;
            if (this.constructor != null) {
                try {
                    Object object = this.constructor.newInstance(new Object[0]);
                    if (this.hasDefaultValue) {
                        this.initDefaultValue(object);
                    }
                    return object;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex2) {
                    throw new JSONException("create instance error, " + this.objectClass, ex2);
                }
            }
            throw new JSONException("create instance error, " + this.objectClass, error);
        }
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mapping[m];
        return this.fieldReaders[index];
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodesLCase, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mappingLCase[m];
        return this.fieldReaders[index];
    }

    protected T autoType(JSONReader jsonReader) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
            throw new JSONException(jsonReader.info("auotype not support : " + typeName));
        }
        return autoTypeObjectReader.readJSONBObject(jsonReader, null, null, this.features);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.isArray()) {
            if (jsonReader.isSupportBeanArray()) {
                return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
            }
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        boolean objectStart = jsonReader.nextIfObjectStart();
        Object object = null;
        int i2 = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.typeKeyHashCode && i2 == 0) {
                String typeName;
                long typeHash = jsonReader.readValueHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("auotype not support : " + typeName));
                }
                if (autoTypeObjectReader != this) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hash != 0L) {
                long nameHashCodeLCase;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.features) && (nameHashCodeLCase = jsonReader.getNameHashCodeLCase()) != hash) {
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    this.processExtra(jsonReader, object);
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i2;
        }
        if (object == null) {
            object = this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public ObjectReader autoType(ObjectReaderProvider provider, long typeHash) {
        if (this.seeAlsoMapping != null && this.seeAlsoMapping.size() > 0) {
            Class seeAlsoClass = this.seeAlsoMapping.get(typeHash);
            if (seeAlsoClass == null) {
                return null;
            }
            return provider.getObjectReader(seeAlsoClass);
        }
        return provider.getObjectReader(typeHash);
    }

    @Override
    public ObjectReader autoType(JSONReader.Context context, long typeHash) {
        if (this.seeAlsoMapping != null && this.seeAlsoMapping.size() > 0) {
            Class seeAlsoClass = this.seeAlsoMapping.get(typeHash);
            if (seeAlsoClass == null) {
                return null;
            }
            return context.getObjectReader(seeAlsoClass);
        }
        return context.getObjectReaderAutoType(typeHash);
    }

    @Override
    protected void initStringFieldAsEmpty(Object object) {
        for (FieldReader fieldReader : this.fieldReaders) {
            if (fieldReader.fieldClass != String.class) continue;
            fieldReader.accept(object, "");
        }
    }
}

