/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectReaderInterface<T>
extends ObjectReaderAdapter<T> {
    public ObjectReaderInterface(Class objectClass, String typeKey, String typeName, long features, Supplier creator, Function buildFunction, FieldReader[] fieldReaders) {
        super(objectClass, typeKey, typeName, features, null, creator, buildFunction, fieldReaders);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.isArray()) {
            if (jsonReader.isSupportBeanArray()) {
                return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
            }
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        boolean objectStart = jsonReader.nextIfObjectStart();
        JSONObject jsonObject = new JSONObject();
        T object = null;
        int i2 = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.typeKeyHashCode && i2 == 0) {
                String typeName;
                long typeHash = jsonReader.readValueHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("auotype not support : " + typeName));
                }
                if (autoTypeObjectReader != this) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hash != 0L) {
                long nameHashCodeLCase;
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.features) && (nameHashCodeLCase = jsonReader.getNameHashCodeLCase()) != hash) {
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonObject.put(jsonReader.getFieldName(), jsonReader.readAny());
                } else {
                    Object fieldValue = fieldReader.readFieldValue(jsonReader);
                    jsonObject.put(fieldReader.fieldName, fieldValue);
                }
            }
            ++i2;
        }
        object = TypeUtils.newProxyInstance(this.objectClass, jsonObject);
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray(this.getFeatures() | features)) {
            return this.readArrayMappingObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = null;
        JSONObject jsonObject = new JSONObject();
        boolean objectStart = jsonReader.nextIfMatch('{');
        if (!objectStart) {
            char ch = jsonReader.current();
            if (ch == 't' || ch == 'f') {
                jsonReader.readBoolValue();
                return null;
            }
            if (ch != '\"' && ch != '\'' && ch != '}') {
                throw new JSONException(jsonReader.info());
            }
        }
        int i2 = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long features3;
            JSONReader.Context context = jsonReader.getContext();
            long hash = jsonReader.readFieldNameHashCode();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            if (i2 == 0 && hash == this.getTypeKeyHash() && (((features3 = features | this.getFeatures() | context.getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L || autoTypeFilter != null)) {
                Class<?> filterClass;
                ObjectReader reader = null;
                long typeHash = jsonReader.readTypeHashCode();
                if (autoTypeFilter != null && (filterClass = autoTypeFilter.apply(typeHash, this.objectClass, features3)) == null && (filterClass = autoTypeFilter.apply(jsonReader.getString(), this.objectClass, features3)) != null) {
                    reader = context.getObjectReader(filterClass);
                }
                if (reader == null) {
                    reader = this.autoType(context, typeHash);
                }
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass, features3)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = jsonReader.getString();
                    }
                    object = reader.readObject(jsonReader, null, null, features | this.getFeatures());
                    if (fieldReader != null) {
                        fieldReader.accept(object, typeName);
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonObject.put(jsonReader.getFieldName(), jsonReader.readAny());
                } else {
                    Object fieldValue = fieldReader.readFieldValue(jsonReader);
                    jsonObject.put(fieldReader.fieldName, fieldValue);
                }
            }
            ++i2;
        }
        jsonReader.nextIfMatch(',');
        object = TypeUtils.newProxyInstance(this.objectClass, jsonObject);
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            object = buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T createInstance(long features) {
        JSONObject object = new JSONObject();
        return TypeUtils.newProxyInstance(this.objectClass, object);
    }

    @Override
    public T createInstance(Map map, long features) {
        JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
        return TypeUtils.newProxyInstance(this.objectClass, object);
    }
}

