/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import java.math.BigInteger;

public final class RyuDouble {
    private static final int[][] D_POW5_SPLIT;
    private static final int[][] D_POW5_INV_SPLIT;
    private static final int[][] F_POW5_SPLIT;
    private static final int[][] F_POW5_INV_SPLIT;

    public static String toString(double value) {
        char[] result = new char[24];
        int len = RyuDouble.toString(value, result, 0);
        return new String(result, 0, len);
    }

    public static int toString(double value, char[] result, int off) {
        long output;
        int e10;
        long dm;
        long dp;
        long dv;
        int q;
        long m2;
        int e2;
        long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
        int DOUBLE_EXPONENT_MASK = 2047;
        int DOUBLE_EXPONENT_BIAS = 1023;
        long LOG10_5_NUMERATOR = 6989700L;
        long LOG10_2_NUMERATOR = 3010299L;
        int index = off;
        if (Double.isNaN(value)) {
            result[index++] = 78;
            result[index++] = 97;
            result[index++] = 78;
            return index - off;
        }
        if (value == Double.POSITIVE_INFINITY) {
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            result[index++] = 45;
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L) {
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        if (bits == Long.MIN_VALUE) {
            result[index++] = 45;
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        int DOUBLE_MANTISSA_BITS = 52;
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m2 = ieeeMantissa | 0x10000000000000L;
        }
        boolean sign = bits < 0L;
        boolean even = (m2 & 1L) == 0L;
        long mv = 4L * m2;
        long mp = 4L * m2 + 2L;
        int mmShift = m2 != 0x10000000000000L || ieeeExponent <= 1 ? 1 : 0;
        long mm = 4L * m2 - 1L - (long)mmShift;
        boolean dmIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        if ((e2 -= 2) >= 0) {
            int k = 122 + ((q = Math.max(0, (int)((long)e2 * 3010299L / 10000000L) - 1)) == 0 ? 1 : (int)(((long)q * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
            int i2 = -e2 + q + k;
            int actualShift = i2 - 93 - 21;
            if (actualShift < 0) {
                throw new IllegalArgumentException("" + actualShift);
            }
            int[] ints = D_POW5_INV_SPLIT[q];
            long mHigh = mv >>> 31;
            long mLow = mv & Integer.MAX_VALUE;
            long bits13 = mHigh * (long)ints[0];
            long bits03 = mLow * (long)ints[0];
            long bits12 = mHigh * (long)ints[1];
            long bits02 = mLow * (long)ints[1];
            long bits11 = mHigh * (long)ints[2];
            long bits01 = mLow * (long)ints[2];
            long bits10 = mHigh * (long)ints[3];
            long bits00 = mLow * (long)ints[3];
            dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mp >>> 31;
            mLow = mp & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mm >>> 31;
            mLow = mm & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            e10 = q;
            if (q <= 21) {
                long v;
                if (mv % 5L == 0L) {
                    int pow5Factor_mv;
                    v = mv;
                    if (v % 5L != 0L) {
                        pow5Factor_mv = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mv = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mv = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mv = 3;
                    } else {
                        pow5Factor_mv = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mv;
                        }
                    }
                    dvIsTrailingZeros = pow5Factor_mv >= q;
                } else if (even) {
                    int pow5Factor_mm;
                    v = mm;
                    if (v % 5L != 0L) {
                        pow5Factor_mm = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mm = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mm = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mm = 3;
                    } else {
                        pow5Factor_mm = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mm;
                        }
                    }
                    dmIsTrailingZeros = pow5Factor_mm >= q;
                } else {
                    int pow5Factor_mp;
                    v = mp;
                    if (v % 5L != 0L) {
                        pow5Factor_mp = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mp = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mp = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mp = 3;
                    } else {
                        pow5Factor_mp = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mp;
                        }
                    }
                    if (pow5Factor_mp >= q) {
                        --dp;
                    }
                }
            }
        } else {
            int i3 = -e2 - (q = Math.max(0, (int)((long)(-e2) * 6989700L / 10000000L) - 1));
            int k = (i3 == 0 ? 1 : (int)(((long)i3 * 23219280L + 10000000L - 1L) / 10000000L)) - 121;
            int j = q - k;
            int actualShift = j - 93 - 21;
            if (actualShift < 0) {
                throw new IllegalArgumentException("" + actualShift);
            }
            int[] ints = D_POW5_SPLIT[i3];
            long mHigh = mv >>> 31;
            long mLow = mv & Integer.MAX_VALUE;
            long bits13 = mHigh * (long)ints[0];
            long bits03 = mLow * (long)ints[0];
            long bits12 = mHigh * (long)ints[1];
            long bits02 = mLow * (long)ints[1];
            long bits11 = mHigh * (long)ints[2];
            long bits01 = mLow * (long)ints[2];
            long bits10 = mHigh * (long)ints[3];
            long bits00 = mLow * (long)ints[3];
            dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mp >>> 31;
            mLow = mp & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mm >>> 31;
            mLow = mm & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            e10 = q + e2;
            if (q <= 1) {
                dvIsTrailingZeros = true;
                if (even) {
                    dmIsTrailingZeros = mmShift == 1;
                } else {
                    --dp;
                }
            } else if (q < 63) {
                boolean bl = dvIsTrailingZeros = (mv & (1L << q - 1) - 1L) == 0L;
            }
        }
        int vplength = dp >= 1000000000000000000L ? 19 : (dp >= 100000000000000000L ? 18 : (dp >= 10000000000000000L ? 17 : (dp >= 1000000000000000L ? 16 : (dp >= 100000000000000L ? 15 : (dp >= 10000000000000L ? 14 : (dp >= 1000000000000L ? 13 : (dp >= 100000000000L ? 12 : (dp >= 10000000000L ? 11 : (dp >= 1000000000L ? 10 : (dp >= 100000000L ? 9 : (dp >= 10000000L ? 8 : (dp >= 1000000L ? 7 : (dp >= 100000L ? 6 : (dp >= 10000L ? 5 : (dp >= 1000L ? 4 : (dp >= 100L ? 3 : (dp >= 10L ? 2 : 1)))))))))))))))));
        int exp = e10 + vplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros || dvIsTrailingZeros) {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dvIsTrailingZeros &= lastRemovedDigit == 0;
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            if (dmIsTrailingZeros && even) {
                while (!(dm % 10L != 0L || dp < 100L && scientificNotation)) {
                    dvIsTrailingZeros &= lastRemovedDigit == 0;
                    lastRemovedDigit = (int)(dv % 10L);
                    dp /= 10L;
                    dv /= 10L;
                    dm /= 10L;
                    ++removed;
                }
            }
            if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                lastRemovedDigit = 4;
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        int olength = vplength - removed;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i4 = 0; i4 < olength - 1; ++i4) {
                int c = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i4] = (char)(48 + c);
            }
            result[index] = (char)(48L + output % 10L);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 100) {
                result[index++] = (char)(48 + exp / 100);
                result[index++] = (char)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
            return index - off;
        }
        if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i5 = -1; i5 > exp; --i5) {
                result[index++] = 48;
            }
            int current = index;
            for (int i6 = 0; i6 < olength; ++i6) {
                result[current + olength - i6 - 1] = (char)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i7;
            for (i7 = 0; i7 < olength; ++i7) {
                result[index + olength - i7 - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i7 = olength; i7 < exp + 1; ++i7) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            int current = index + 1;
            for (int i8 = 0; i8 < olength; ++i8) {
                if (olength - i8 - 1 == exp) {
                    result[current + olength - i8 - 1] = 46;
                    --current;
                }
                result[current + olength - i8 - 1] = (char)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        return index - off;
    }

    public static int toString(double value, byte[] result, int off) {
        long output;
        int e10;
        long dm;
        long dp;
        long dv;
        int q;
        long m2;
        int e2;
        long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
        int DOUBLE_EXPONENT_MASK = 2047;
        int DOUBLE_EXPONENT_BIAS = 1023;
        long LOG10_5_NUMERATOR = 6989700L;
        long LOG10_2_NUMERATOR = 3010299L;
        int index = off;
        if (Double.isNaN(value)) {
            result[index++] = 78;
            result[index++] = 97;
            result[index++] = 78;
            return index - off;
        }
        if (value == Double.POSITIVE_INFINITY) {
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            result[index++] = 45;
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L) {
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        if (bits == Long.MIN_VALUE) {
            result[index++] = 45;
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        int DOUBLE_MANTISSA_BITS = 52;
        int ieeeExponent = (int)(bits >>> 52 & 0x7FFL);
        long ieeeMantissa = bits & 0xFFFFFFFFFFFFFL;
        if (ieeeExponent == 0) {
            e2 = -1074;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 1023 - 52;
            m2 = ieeeMantissa | 0x10000000000000L;
        }
        boolean sign = bits < 0L;
        boolean even = (m2 & 1L) == 0L;
        long mv = 4L * m2;
        long mp = 4L * m2 + 2L;
        int mmShift = m2 != 0x10000000000000L || ieeeExponent <= 1 ? 1 : 0;
        long mm = 4L * m2 - 1L - (long)mmShift;
        boolean dmIsTrailingZeros = false;
        boolean dvIsTrailingZeros = false;
        if ((e2 -= 2) >= 0) {
            int k = 122 + ((q = Math.max(0, (int)((long)e2 * 3010299L / 10000000L) - 1)) == 0 ? 1 : (int)(((long)q * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
            int i2 = -e2 + q + k;
            int actualShift = i2 - 93 - 21;
            if (actualShift < 0) {
                throw new IllegalArgumentException("" + actualShift);
            }
            int[] ints = D_POW5_INV_SPLIT[q];
            long mHigh = mv >>> 31;
            long mLow = mv & Integer.MAX_VALUE;
            long bits13 = mHigh * (long)ints[0];
            long bits03 = mLow * (long)ints[0];
            long bits12 = mHigh * (long)ints[1];
            long bits02 = mLow * (long)ints[1];
            long bits11 = mHigh * (long)ints[2];
            long bits01 = mLow * (long)ints[2];
            long bits10 = mHigh * (long)ints[3];
            long bits00 = mLow * (long)ints[3];
            dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mp >>> 31;
            mLow = mp & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mm >>> 31;
            mLow = mm & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            e10 = q;
            if (q <= 21) {
                long v;
                if (mv % 5L == 0L) {
                    int pow5Factor_mv;
                    v = mv;
                    if (v % 5L != 0L) {
                        pow5Factor_mv = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mv = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mv = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mv = 3;
                    } else {
                        pow5Factor_mv = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mv;
                        }
                    }
                    dvIsTrailingZeros = pow5Factor_mv >= q;
                } else if (even) {
                    int pow5Factor_mm;
                    v = mm;
                    if (v % 5L != 0L) {
                        pow5Factor_mm = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mm = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mm = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mm = 3;
                    } else {
                        pow5Factor_mm = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mm;
                        }
                    }
                    dmIsTrailingZeros = pow5Factor_mm >= q;
                } else {
                    int pow5Factor_mp;
                    v = mp;
                    if (v % 5L != 0L) {
                        pow5Factor_mp = 0;
                    } else if (v % 25L != 0L) {
                        pow5Factor_mp = 1;
                    } else if (v % 125L != 0L) {
                        pow5Factor_mp = 2;
                    } else if (v % 625L != 0L) {
                        pow5Factor_mp = 3;
                    } else {
                        pow5Factor_mp = 4;
                        v /= 625L;
                        while (v > 0L && v % 5L == 0L) {
                            v /= 5L;
                            ++pow5Factor_mp;
                        }
                    }
                    if (pow5Factor_mp >= q) {
                        --dp;
                    }
                }
            }
        } else {
            int i3 = -e2 - (q = Math.max(0, (int)((long)(-e2) * 6989700L / 10000000L) - 1));
            int k = (i3 == 0 ? 1 : (int)(((long)i3 * 23219280L + 10000000L - 1L) / 10000000L)) - 121;
            int j = q - k;
            int actualShift = j - 93 - 21;
            if (actualShift < 0) {
                throw new IllegalArgumentException("" + actualShift);
            }
            int[] ints = D_POW5_SPLIT[i3];
            long mHigh = mv >>> 31;
            long mLow = mv & Integer.MAX_VALUE;
            long bits13 = mHigh * (long)ints[0];
            long bits03 = mLow * (long)ints[0];
            long bits12 = mHigh * (long)ints[1];
            long bits02 = mLow * (long)ints[1];
            long bits11 = mHigh * (long)ints[2];
            long bits01 = mLow * (long)ints[2];
            long bits10 = mHigh * (long)ints[3];
            long bits00 = mLow * (long)ints[3];
            dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mp >>> 31;
            mLow = mp & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            mHigh = mm >>> 31;
            mLow = mm & Integer.MAX_VALUE;
            bits13 = mHigh * (long)ints[0];
            bits03 = mLow * (long)ints[0];
            bits12 = mHigh * (long)ints[1];
            bits02 = mLow * (long)ints[1];
            bits11 = mHigh * (long)ints[2];
            bits01 = mLow * (long)ints[2];
            bits10 = mHigh * (long)ints[3];
            bits00 = mLow * (long)ints[3];
            dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
            e10 = q + e2;
            if (q <= 1) {
                dvIsTrailingZeros = true;
                if (even) {
                    dmIsTrailingZeros = mmShift == 1;
                } else {
                    --dp;
                }
            } else if (q < 63) {
                boolean bl = dvIsTrailingZeros = (mv & (1L << q - 1) - 1L) == 0L;
            }
        }
        int vplength = dp >= 1000000000000000000L ? 19 : (dp >= 100000000000000000L ? 18 : (dp >= 10000000000000000L ? 17 : (dp >= 1000000000000000L ? 16 : (dp >= 100000000000000L ? 15 : (dp >= 10000000000000L ? 14 : (dp >= 1000000000000L ? 13 : (dp >= 100000000000L ? 12 : (dp >= 10000000000L ? 11 : (dp >= 1000000000L ? 10 : (dp >= 100000000L ? 9 : (dp >= 10000000L ? 8 : (dp >= 1000000L ? 7 : (dp >= 100000L ? 6 : (dp >= 10000L ? 5 : (dp >= 1000L ? 4 : (dp >= 100L ? 3 : (dp >= 10L ? 2 : 1)))))))))))))))));
        int exp = e10 + vplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        int lastRemovedDigit = 0;
        if (dmIsTrailingZeros || dvIsTrailingZeros) {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                dmIsTrailingZeros &= dm % 10L == 0L;
                dvIsTrailingZeros &= lastRemovedDigit == 0;
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            if (dmIsTrailingZeros && even) {
                while (!(dm % 10L != 0L || dp < 100L && scientificNotation)) {
                    dvIsTrailingZeros &= lastRemovedDigit == 0;
                    lastRemovedDigit = (int)(dv % 10L);
                    dp /= 10L;
                    dv /= 10L;
                    dm /= 10L;
                    ++removed;
                }
            }
            if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                lastRemovedDigit = 4;
            }
            output = dv + (long)(dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        } else {
            while (!(dp / 10L <= dm / 10L || dp < 100L && scientificNotation)) {
                lastRemovedDigit = (int)(dv % 10L);
                dp /= 10L;
                dv /= 10L;
                dm /= 10L;
                ++removed;
            }
            output = dv + (long)(dv == dm || lastRemovedDigit >= 5 ? 1 : 0);
        }
        int olength = vplength - removed;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (int i4 = 0; i4 < olength - 1; ++i4) {
                int c = (int)(output % 10L);
                output /= 10L;
                result[index + olength - i4] = (byte)(48 + c);
            }
            result[index] = (byte)(48L + output % 10L);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 100) {
                result[index++] = (byte)(48 + exp / 100);
                result[index++] = (byte)(48 + (exp %= 100) / 10);
            } else if (exp >= 10) {
                result[index++] = (byte)(48 + exp / 10);
            }
            result[index++] = (byte)(48 + exp % 10);
            return index - off;
        }
        if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (int i5 = -1; i5 > exp; --i5) {
                result[index++] = 48;
            }
            int current = index;
            for (int i6 = 0; i6 < olength; ++i6) {
                result[current + olength - i6 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            int i7;
            for (i7 = 0; i7 < olength; ++i7) {
                result[index + olength - i7 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
            }
            index += olength;
            for (i7 = olength; i7 < exp + 1; ++i7) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            int current = index + 1;
            for (int i8 = 0; i8 < olength; ++i8) {
                if (olength - i8 - 1 == exp) {
                    result[current + olength - i8 - 1] = 46;
                    --current;
                }
                result[current + olength - i8 - 1] = (byte)(48L + output % 10L);
                output /= 10L;
            }
            index += olength + 1;
        }
        return index - off;
    }

    public static String toString(float value) {
        char[] result = new char[15];
        int len = RyuDouble.toString(value, result, 0);
        return new String(result, 0, len);
    }

    public static int toString(float value, char[] result, int off) {
        int i2;
        int current;
        int i3;
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int e10;
        int dm;
        int dp;
        int dv;
        int q;
        int m2;
        int e2;
        int FLOAT_MANTISSA_MASK = 0x7FFFFF;
        int FLOAT_EXPONENT_MASK = 255;
        int FLOAT_EXPONENT_BIAS = 127;
        long LOG10_2_NUMERATOR = 3010299L;
        long LOG10_5_DENOMINATOR = 10000000L;
        long LOG10_5_NUMERATOR = 6989700L;
        int index = off;
        if (Float.isNaN(value)) {
            result[index++] = 78;
            result[index++] = 97;
            result[index++] = 78;
            return index - off;
        }
        if (value == Float.POSITIVE_INFINITY) {
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            result[index++] = 45;
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        int bits = Float.floatToIntBits(value);
        if (bits == 0) {
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        if (bits == Integer.MIN_VALUE) {
            result[index++] = 45;
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = 4 * m2;
        int mp = 4 * m2 + 2;
        int mm = 4 * m2 - ((long)m2 != 0x800000L || ieeeExponent <= 1 ? 2 : 1);
        int lastRemovedDigit = 0;
        if ((e2 -= 2) >= 0) {
            q = (int)((long)e2 * 3010299L / 10000000L);
            int k = 59 + (q == 0 ? 1 : (int)(((long)q * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
            int i4 = -e2 + q + k;
            long pis0 = F_POW5_INV_SPLIT[q][0];
            long pis1 = F_POW5_INV_SPLIT[q][1];
            dv = (int)((long)mv * pis0 + ((long)mv * pis1 >> 31) >> i4 - 31);
            dp = (int)((long)mp * pis0 + ((long)mp * pis1 >> 31) >> i4 - 31);
            dm = (int)((long)mm * pis0 + ((long)mm * pis1 >> 31) >> i4 - 31);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int e = q - 1;
                int l = 59 + (e == 0 ? 1 : (int)(((long)e * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
                int qx = q - 1;
                int ii = -e2 + q - 1 + l;
                long mulPow5InvDivPow2 = (long)mv * (long)F_POW5_INV_SPLIT[qx][0] + ((long)mv * (long)F_POW5_INV_SPLIT[qx][1] >> 31) >> ii - 31;
                lastRemovedDigit = (int)(mulPow5InvDivPow2 % 10L);
            }
            e10 = q;
            int pow5Factor_mp = 0;
            int v = mp;
            while (v > 0 && v % 5 == 0) {
                v /= 5;
                ++pow5Factor_mp;
            }
            int pow5Factor_mv = 0;
            int v2 = mv;
            while (v2 > 0 && v2 % 5 == 0) {
                v2 /= 5;
                ++pow5Factor_mv;
            }
            int pow5Factor_mm = 0;
            int v3 = mm;
            while (v3 > 0 && v3 % 5 == 0) {
                v3 /= 5;
                ++pow5Factor_mm;
            }
            dpIsTrailingZeros = pow5Factor_mp >= q;
            dvIsTrailingZeros = pow5Factor_mv >= q;
            dmIsTrailingZeros = pow5Factor_mm >= q;
        } else {
            q = (int)((long)(-e2) * 6989700L / 10000000L);
            int i5 = -e2 - q;
            int k = (i5 == 0 ? 1 : (int)(((long)i5 * 23219280L + 10000000L - 1L) / 10000000L)) - 61;
            int j = q - k;
            long ps0 = F_POW5_SPLIT[i5][0];
            long ps1 = F_POW5_SPLIT[i5][1];
            int j31 = j - 31;
            dv = (int)((long)mv * ps0 + ((long)mv * ps1 >> 31) >> j31);
            dp = (int)((long)mp * ps0 + ((long)mp * ps1 >> 31) >> j31);
            dm = (int)((long)mm * ps0 + ((long)mm * ps1 >> 31) >> j31);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int e = i5 + 1;
                j = q - 1 - ((e == 0 ? 1 : (int)(((long)e * 23219280L + 10000000L - 1L) / 10000000L)) - 61);
                int ix = i5 + 1;
                long mulPow5divPow2 = (long)mv * (long)F_POW5_SPLIT[ix][0] + ((long)mv * (long)F_POW5_SPLIT[ix][1] >> 31) >> j - 31;
                lastRemovedDigit = (int)(mulPow5divPow2 % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (mm % 2 == 1 ? 0 : 1) >= q;
        }
        int dplength = 10;
        for (int factor = 1000000000; dplength > 0 && dp < factor; factor /= 10, --dplength) {
        }
        int exp = e10 + dplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        if (dpIsTrailingZeros && !even) {
            --dp;
        }
        while (!(dp / 10 <= dm / 10 || dp < 100 && scientificNotation)) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && even) {
            while (!(dm % 10 != 0 || dp < 100 && scientificNotation)) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2 == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (i3 = 0; i3 < olength - 1; ++i3) {
                int c = output % 10;
                output /= 10;
                result[index + olength - i3] = (char)(48 + c);
            }
            result[index] = (char)(48 + output % 10);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 10) {
                result[index++] = (char)(48 + exp / 10);
            }
            result[index++] = (char)(48 + exp % 10);
        } else if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (i3 = -1; i3 > exp; --i3) {
                result[index++] = 48;
            }
            current = index;
            for (i2 = 0; i2 < olength; ++i2) {
                result[current + olength - i2 - 1] = (char)(48 + output % 10);
                output /= 10;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            for (i3 = 0; i3 < olength; ++i3) {
                result[index + olength - i3 - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength;
            for (i3 = olength; i3 < exp + 1; ++i3) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            current = index + 1;
            for (i2 = 0; i2 < olength; ++i2) {
                if (olength - i2 - 1 == exp) {
                    result[current + olength - i2 - 1] = 46;
                    --current;
                }
                result[current + olength - i2 - 1] = (char)(48 + output % 10);
                output /= 10;
            }
            index += olength + 1;
        }
        return index - off;
    }

    public static int toString(float value, byte[] result, int off) {
        int i2;
        int current;
        int i3;
        boolean dmIsTrailingZeros;
        boolean dvIsTrailingZeros;
        boolean dpIsTrailingZeros;
        int e10;
        int dm;
        int dp;
        int dv;
        int q;
        int m2;
        int e2;
        int FLOAT_MANTISSA_MASK = 0x7FFFFF;
        int FLOAT_EXPONENT_MASK = 255;
        int FLOAT_EXPONENT_BIAS = 127;
        long LOG10_2_NUMERATOR = 3010299L;
        long LOG10_5_DENOMINATOR = 10000000L;
        long LOG10_5_NUMERATOR = 6989700L;
        int index = off;
        if (Float.isNaN(value)) {
            result[index++] = 78;
            result[index++] = 97;
            result[index++] = 78;
            return index - off;
        }
        if (value == Float.POSITIVE_INFINITY) {
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            result[index++] = 45;
            result[index++] = 73;
            result[index++] = 110;
            result[index++] = 102;
            result[index++] = 105;
            result[index++] = 110;
            result[index++] = 105;
            result[index++] = 116;
            result[index++] = 121;
            return index - off;
        }
        int bits = Float.floatToIntBits(value);
        if (bits == 0) {
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        if (bits == Integer.MIN_VALUE) {
            result[index++] = 45;
            result[index++] = 48;
            result[index++] = 46;
            result[index++] = 48;
            return index - off;
        }
        int ieeeExponent = bits >> 23 & 0xFF;
        int ieeeMantissa = bits & 0x7FFFFF;
        if (ieeeExponent == 0) {
            e2 = -149;
            m2 = ieeeMantissa;
        } else {
            e2 = ieeeExponent - 127 - 23;
            m2 = ieeeMantissa | 0x800000;
        }
        boolean sign = bits < 0;
        boolean even = (m2 & 1) == 0;
        int mv = 4 * m2;
        int mp = 4 * m2 + 2;
        int mm = 4 * m2 - ((long)m2 != 0x800000L || ieeeExponent <= 1 ? 2 : 1);
        int lastRemovedDigit = 0;
        if ((e2 -= 2) >= 0) {
            q = (int)((long)e2 * 3010299L / 10000000L);
            int k = 59 + (q == 0 ? 1 : (int)(((long)q * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
            int i4 = -e2 + q + k;
            long pis0 = F_POW5_INV_SPLIT[q][0];
            long pis1 = F_POW5_INV_SPLIT[q][1];
            dv = (int)((long)mv * pis0 + ((long)mv * pis1 >> 31) >> i4 - 31);
            dp = (int)((long)mp * pis0 + ((long)mp * pis1 >> 31) >> i4 - 31);
            dm = (int)((long)mm * pis0 + ((long)mm * pis1 >> 31) >> i4 - 31);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int e = q - 1;
                int l = 59 + (e == 0 ? 1 : (int)(((long)e * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
                int qx = q - 1;
                int ii = -e2 + q - 1 + l;
                long mulPow5InvDivPow2 = (long)mv * (long)F_POW5_INV_SPLIT[qx][0] + ((long)mv * (long)F_POW5_INV_SPLIT[qx][1] >> 31) >> ii - 31;
                lastRemovedDigit = (int)(mulPow5InvDivPow2 % 10L);
            }
            e10 = q;
            int pow5Factor_mp = 0;
            int v = mp;
            while (v > 0 && v % 5 == 0) {
                v /= 5;
                ++pow5Factor_mp;
            }
            int pow5Factor_mv = 0;
            int v2 = mv;
            while (v2 > 0 && v2 % 5 == 0) {
                v2 /= 5;
                ++pow5Factor_mv;
            }
            int pow5Factor_mm = 0;
            int v3 = mm;
            while (v3 > 0 && v3 % 5 == 0) {
                v3 /= 5;
                ++pow5Factor_mm;
            }
            dpIsTrailingZeros = pow5Factor_mp >= q;
            dvIsTrailingZeros = pow5Factor_mv >= q;
            dmIsTrailingZeros = pow5Factor_mm >= q;
        } else {
            q = (int)((long)(-e2) * 6989700L / 10000000L);
            int i5 = -e2 - q;
            int k = (i5 == 0 ? 1 : (int)(((long)i5 * 23219280L + 10000000L - 1L) / 10000000L)) - 61;
            int j = q - k;
            long ps0 = F_POW5_SPLIT[i5][0];
            long ps1 = F_POW5_SPLIT[i5][1];
            int j31 = j - 31;
            dv = (int)((long)mv * ps0 + ((long)mv * ps1 >> 31) >> j31);
            dp = (int)((long)mp * ps0 + ((long)mp * ps1 >> 31) >> j31);
            dm = (int)((long)mm * ps0 + ((long)mm * ps1 >> 31) >> j31);
            if (q != 0 && (dp - 1) / 10 <= dm / 10) {
                int e = i5 + 1;
                j = q - 1 - ((e == 0 ? 1 : (int)(((long)e * 23219280L + 10000000L - 1L) / 10000000L)) - 61);
                int ix = i5 + 1;
                long mulPow5divPow2 = (long)mv * (long)F_POW5_SPLIT[ix][0] + ((long)mv * (long)F_POW5_SPLIT[ix][1] >> 31) >> j - 31;
                lastRemovedDigit = (int)(mulPow5divPow2 % 10L);
            }
            e10 = q + e2;
            dpIsTrailingZeros = 1 >= q;
            dvIsTrailingZeros = q < 23 && (mv & (1 << q - 1) - 1) == 0;
            dmIsTrailingZeros = (mm % 2 == 1 ? 0 : 1) >= q;
        }
        int dplength = 10;
        for (int factor = 1000000000; dplength > 0 && dp < factor; factor /= 10, --dplength) {
        }
        int exp = e10 + dplength - 1;
        boolean scientificNotation = exp < -3 || exp >= 7;
        int removed = 0;
        if (dpIsTrailingZeros && !even) {
            --dp;
        }
        while (!(dp / 10 <= dm / 10 || dp < 100 && scientificNotation)) {
            dmIsTrailingZeros &= dm % 10 == 0;
            dp /= 10;
            lastRemovedDigit = dv % 10;
            dv /= 10;
            dm /= 10;
            ++removed;
        }
        if (dmIsTrailingZeros && even) {
            while (!(dm % 10 != 0 || dp < 100 && scientificNotation)) {
                dp /= 10;
                lastRemovedDigit = dv % 10;
                dv /= 10;
                dm /= 10;
                ++removed;
            }
        }
        if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2 == 0) {
            lastRemovedDigit = 4;
        }
        int output = dv + (dv == dm && (!dmIsTrailingZeros || !even) || lastRemovedDigit >= 5 ? 1 : 0);
        int olength = dplength - removed;
        if (sign) {
            result[index++] = 45;
        }
        if (scientificNotation) {
            for (i3 = 0; i3 < olength - 1; ++i3) {
                int c = output % 10;
                output /= 10;
                result[index + olength - i3] = (byte)(48 + c);
            }
            result[index] = (byte)(48 + output % 10);
            result[index + 1] = 46;
            index += olength + 1;
            if (olength == 1) {
                result[index++] = 48;
            }
            result[index++] = 69;
            if (exp < 0) {
                result[index++] = 45;
                exp = -exp;
            }
            if (exp >= 10) {
                result[index++] = (byte)(48 + exp / 10);
            }
            result[index++] = (byte)(48 + exp % 10);
        } else if (exp < 0) {
            result[index++] = 48;
            result[index++] = 46;
            for (i3 = -1; i3 > exp; --i3) {
                result[index++] = 48;
            }
            current = index;
            for (i2 = 0; i2 < olength; ++i2) {
                result[current + olength - i2 - 1] = (byte)(48 + output % 10);
                output /= 10;
                ++index;
            }
        } else if (exp + 1 >= olength) {
            for (i3 = 0; i3 < olength; ++i3) {
                result[index + olength - i3 - 1] = (byte)(48 + output % 10);
                output /= 10;
            }
            index += olength;
            for (i3 = olength; i3 < exp + 1; ++i3) {
                result[index++] = 48;
            }
            result[index++] = 46;
            result[index++] = 48;
        } else {
            current = index + 1;
            for (i2 = 0; i2 < olength; ++i2) {
                if (olength - i2 - 1 == exp) {
                    result[current + olength - i2 - 1] = 46;
                    --current;
                }
                result[current + olength - i2 - 1] = (byte)(48 + output % 10);
                output /= 10;
            }
            index += olength + 1;
        }
        return index - off;
    }

    static {
        BigInteger mask;
        D_POW5_SPLIT = new int[326][4];
        D_POW5_INV_SPLIT = new int[291][4];
        BigInteger invMask = mask = BigInteger.valueOf(Integer.MAX_VALUE);
        for (int i2 = 0; i2 < 326; ++i2) {
            int j;
            int expectedPow5Bits;
            BigInteger pow = BigInteger.valueOf(5L).pow(i2);
            int pow5len = pow.bitLength();
            int n = expectedPow5Bits = i2 == 0 ? 1 : (int)(((long)i2 * 23219280L + 10000000L - 1L) / 10000000L);
            if (expectedPow5Bits != pow5len) {
                throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
            }
            if (i2 < D_POW5_SPLIT.length) {
                for (j = 0; j < 4; ++j) {
                    RyuDouble.D_POW5_SPLIT[i2][j] = pow.shiftRight(pow5len - 121 + (3 - j) * 31).and(mask).intValue();
                }
            }
            if (i2 >= D_POW5_INV_SPLIT.length) continue;
            j = pow5len + 121;
            BigInteger inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);
            for (int k = 0; k < 4; ++k) {
                RyuDouble.D_POW5_INV_SPLIT[i2][k] = k == 0 ? inv.shiftRight((3 - k) * 31).intValue() : inv.shiftRight((3 - k) * 31).and(invMask).intValue();
            }
        }
        F_POW5_SPLIT = new int[][]{{0x20000000, 0}, {0x28000000, 0}, {0x32000000, 0}, {1048576000, 0}, {655360000, 0}, {819200000, 0}, {1024000000, 0}, {640000000, 0}, {800000000, 0}, {1000000000, 0}, {625000000, 0}, {781250000, 0}, {976562500, 0}, {610351562, 0x40000000}, {762939453, 0x10000000}, {953674316, 0x34000000}, {596046447, 0x60800000}, {745058059, 1486880768}, {931322574, 1321730048}, {582076609, 289210368}, {727595761, 898383872}, {909494701, 1659850752}, {568434188, 1305842176}, {710542735, 1632302720}, {888178419, 1503507488}, {555111512, 671256724}, {693889390, 839070905}, {867361737, 2122580455}, {542101086, 521306416}, {677626357, 1725374844}, {847032947, 546105819}, {1058791184, 145761362}, {661744490, 91100851}, {827180612, 1187617888}, {1033975765, 1484522360}, {646234853, 1196261931}, {807793566, 2032198326}, {1009741958, 1466506084}, {631088724, 379695390}, {788860905, 474619238}, {986076131, 1130144959}, {616297582, 437905143}, {770371977, 1621123253}, {962964972, 415791331}, {601853107, 1333611405}, {752316384, 1130143345}, {940395480, 1412679181}};
        F_POW5_INV_SPLIT = new int[][]{{0x10000000, 1}, {0xCCCCCCC, 0x66666667}, {171798691, 1803886265}, {137438953, 1013612282}, {219902325, 1192282922}, {175921860, 953826338}, {140737488, 763061070}, {225179981, 791400982}, {180143985, 203624056}, {144115188, 162899245}, {230584300, 1978625710}, {184467440, 1582900568}, {147573952, 1266320455}, {236118324, 308125809}, {188894659, 675997377}, {151115727, 970294631}, {241785163, 1981968139}, {193428131, 297084323}, {154742504, 1955654377}, {247588007, 1840556814}, {198070406, 613451992}, {158456325, 61264864}, {253530120, 98023782}, {202824096, 78419026}, {162259276, 1780722139}, {259614842, 1990161963}, {207691874, 733136111}, {166153499, 1016005619}, {265845599, 337118801}, {212676479, 699191770}, {170141183, 988850146}};
    }
}

