/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.lang.reflect.Type;
import java.util.List;

public class ObjectWriterException
extends ObjectWriterAdapter<Exception> {
    public ObjectWriterException(Class objectType, long features, List<FieldWriter> fieldWriters) {
        super(objectType, null, null, features, fieldWriters);
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        this.writeClassInfo(jsonWriter);
        int size = this.fieldWriters.size();
        jsonWriter.startObject();
        for (int i2 = 0; i2 < size; ++i2) {
            FieldWriter fw = (FieldWriter)this.fieldWriters.get(i2);
            fw.write(jsonWriter, object);
        }
        jsonWriter.endObject();
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.jsonb) {
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (this.hasFilter(jsonWriter)) {
            this.writeWithFilter(jsonWriter, object);
            return;
        }
        jsonWriter.startObject();
        if ((jsonWriter.getFeatures(features) & (JSONWriter.Feature.WriteClassName.mask | JSONWriter.Feature.WriteThrowableClassName.mask)) != 0L) {
            this.writeTypeInfo(jsonWriter);
        }
        int size = this.fieldWriters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            FieldWriter fieldWriter = (FieldWriter)this.fieldWriters.get(i2);
            fieldWriter.write(jsonWriter, object);
        }
        jsonWriter.endObject();
    }
}

