/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;
import java.math.BigDecimal;

final class ObjectWriterImpDecimalArray
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImpDecimalArray INSTANCE = new ObjectWriterImpDecimalArray();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[BigDecimal");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[BigDecimal");

    ObjectWriterImpDecimalArray() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) {
                jsonWriter.startArray();
                jsonWriter.endArray();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        BigDecimal[] array = (BigDecimal[])object;
        jsonWriter.startArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            jsonWriter.writeDecimal(array[i2], 0L, null);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        BigDecimal[] array = (BigDecimal[])object;
        jsonWriter.startArray(array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            jsonWriter.writeDecimal(array[i2], 0L, null);
        }
    }
}

