/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.UnexpectedFrameError;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class CommandAssembler {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private CAState state;
    private Method method;
    private AMQContentHeader contentHeader;
    private final List<byte[]> bodyN;
    private int bodyLength;
    private long remainingBodyBytes;

    public CommandAssembler(Method method, AMQContentHeader contentHeader, byte[] body2) {
        this.method = method;
        this.contentHeader = contentHeader;
        this.bodyN = new ArrayList<byte[]>(2);
        this.bodyLength = 0;
        this.remainingBodyBytes = 0L;
        this.appendBodyFragment(body2);
        if (method == null) {
            this.state = CAState.EXPECTING_METHOD;
        } else if (contentHeader == null) {
            this.state = method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
        } else {
            this.remainingBodyBytes = contentHeader.getBodySize() - (long)this.bodyLength;
            this.updateContentBodyState();
        }
    }

    public synchronized Method getMethod() {
        return this.method;
    }

    public synchronized AMQContentHeader getContentHeader() {
        return this.contentHeader;
    }

    public synchronized boolean isComplete() {
        return this.state == CAState.COMPLETE;
    }

    private void updateContentBodyState() {
        this.state = this.remainingBodyBytes > 0L ? CAState.EXPECTING_CONTENT_BODY : CAState.COMPLETE;
    }

    private void consumeMethodFrame(Frame f) throws IOException {
        if (f.type != 1) {
            throw new UnexpectedFrameError(f, 1);
        }
        this.method = AMQImpl.readMethodFrom(f.getInputStream());
        this.state = this.method.hasContent() ? CAState.EXPECTING_CONTENT_HEADER : CAState.COMPLETE;
    }

    private void consumeHeaderFrame(Frame f) throws IOException {
        if (f.type != 2) {
            throw new UnexpectedFrameError(f, 2);
        }
        this.contentHeader = AMQImpl.readContentHeaderFrom(f.getInputStream());
        this.remainingBodyBytes = this.contentHeader.getBodySize();
        this.updateContentBodyState();
    }

    private void consumeBodyFrame(Frame f) {
        byte[] fragment;
        if (f.type == 3) {
            fragment = f.getPayload();
            this.remainingBodyBytes -= (long)fragment.length;
            this.updateContentBodyState();
            if (this.remainingBodyBytes < 0L) {
                throw new UnsupportedOperationException("%%%%%% FIXME unimplemented");
            }
        } else {
            throw new UnexpectedFrameError(f, 3);
        }
        this.appendBodyFragment(fragment);
    }

    private byte[] coalesceContentBody() {
        if (this.bodyLength == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (this.bodyN.size() == 1) {
            return this.bodyN.get(0);
        }
        byte[] body2 = new byte[this.bodyLength];
        int offset = 0;
        for (byte[] fragment : this.bodyN) {
            System.arraycopy(fragment, 0, body2, offset, fragment.length);
            offset += fragment.length;
        }
        this.bodyN.clear();
        this.bodyN.add(body2);
        return body2;
    }

    public synchronized byte[] getContentBody() {
        return this.coalesceContentBody();
    }

    private void appendBodyFragment(byte[] fragment) {
        if (fragment == null || fragment.length == 0) {
            return;
        }
        this.bodyN.add(fragment);
        this.bodyLength += fragment.length;
    }

    public synchronized boolean handleFrame(Frame f) throws IOException {
        switch (this.state) {
            case EXPECTING_METHOD: {
                this.consumeMethodFrame(f);
                break;
            }
            case EXPECTING_CONTENT_HEADER: {
                this.consumeHeaderFrame(f);
                break;
            }
            case EXPECTING_CONTENT_BODY: {
                this.consumeBodyFrame(f);
                break;
            }
            default: {
                throw new IllegalStateException("Bad Command State " + (Object)((Object)this.state));
            }
        }
        return this.isComplete();
    }

    private static enum CAState {
        EXPECTING_METHOD,
        EXPECTING_CONTENT_HEADER,
        EXPECTING_CONTENT_BODY,
        COMPLETE;

    }
}

