/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.Invoker;
import org.apache.ibatis.reflection.invoker.MethodInvoker;
import org.apache.ibatis.reflection.invoker.SetFieldInvoker;
import org.apache.ibatis.reflection.property.PropertyNamer;

public class Reflector {
    private final Class<?> type;
    private final String[] readablePropertyNames;
    private final String[] writeablePropertyNames;
    private final Map<String, Invoker> setMethods = new HashMap<String, Invoker>();
    private final Map<String, Invoker> getMethods = new HashMap<String, Invoker>();
    private final Map<String, Class<?>> setTypes = new HashMap();
    private final Map<String, Class<?>> getTypes = new HashMap();
    private Constructor<?> defaultConstructor;
    private Map<String, String> caseInsensitivePropertyMap = new HashMap<String, String>();

    public Reflector(Class<?> clazz) {
        this.type = clazz;
        this.addDefaultConstructor(clazz);
        this.addGetMethods(clazz);
        this.addSetMethods(clazz);
        this.addFields(clazz);
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
        for (String propName : this.readablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
        for (String propName : this.writeablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
    }

    private void addDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] consts;
        for (Constructor<?> constructor : consts = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!constructor.isAccessible()) continue;
            this.defaultConstructor = constructor;
        }
    }

    private void addGetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingGetters = new HashMap<String, List<Method>>();
        for (Method method : methods = this.getClassMethods(cls)) {
            String name;
            if (method.getParameterTypes().length > 0 || (!(name = method.getName()).startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2)) continue;
            name = PropertyNamer.methodToProperty(name);
            this.addMethodConflict(conflictingGetters, name, method);
        }
        this.resolveGetterConflicts(conflictingGetters);
    }

    private void resolveGetterConflicts(Map<String, List<Method>> conflictingGetters) {
        for (Map.Entry<String, List<Method>> entry : conflictingGetters.entrySet()) {
            Method winner = null;
            String propName = entry.getKey();
            for (Method candidate : entry.getValue()) {
                if (winner == null) {
                    winner = candidate;
                    continue;
                }
                Class<?> winnerType = winner.getReturnType();
                Class<?> candidateType = candidate.getReturnType();
                if (candidateType.equals(winnerType)) {
                    if (!Boolean.TYPE.equals(candidateType)) {
                        throw new ReflectionException("Illegal overloaded getter method with ambiguous type for property " + propName + " in class " + winner.getDeclaringClass() + ". This breaks the JavaBeans specification and can cause unpredictable results.");
                    }
                    if (!candidate.getName().startsWith("is")) continue;
                    winner = candidate;
                    continue;
                }
                if (candidateType.isAssignableFrom(winnerType)) continue;
                if (winnerType.isAssignableFrom(candidateType)) {
                    winner = candidate;
                    continue;
                }
                throw new ReflectionException("Illegal overloaded getter method with ambiguous type for property " + propName + " in class " + winner.getDeclaringClass() + ". This breaks the JavaBeans specification and can cause unpredictable results.");
            }
            this.addGetMethod(propName, winner);
        }
    }

    private void addGetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.getMethods.put(name, new MethodInvoker(method));
            Type returnType = TypeParameterResolver.resolveReturnType(method, this.type);
            this.getTypes.put(name, this.typeToClass(returnType));
        }
    }

    private void addSetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        for (Method method : methods = this.getClassMethods(cls)) {
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            name = PropertyNamer.methodToProperty(name);
            this.addMethodConflict(conflictingSetters, name, method);
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addMethodConflict(Map<String, List<Method>> conflictingMethods, String name, Method method) {
        List<Method> list = conflictingMethods.get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            conflictingMethods.put(name, list);
        }
        list.add(method);
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List<Method> setters = conflictingSetters.get(propName);
            Class<?> getterType = this.getTypes.get(propName);
            Method match = null;
            ReflectionException exception = null;
            for (Method setter : setters) {
                Class<?> paramType = setter.getParameterTypes()[0];
                if (paramType.equals(getterType)) {
                    match = setter;
                    break;
                }
                if (exception != null) continue;
                try {
                    match = this.pickBetterSetter(match, setter, propName);
                }
                catch (ReflectionException e) {
                    match = null;
                    exception = e;
                }
            }
            if (match == null) {
                throw exception;
            }
            this.addSetMethod(propName, match);
        }
    }

    private Method pickBetterSetter(Method setter1, Method setter2, String property) {
        Class<?> paramType2;
        if (setter1 == null) {
            return setter2;
        }
        Class<?> paramType1 = setter1.getParameterTypes()[0];
        if (paramType1.isAssignableFrom(paramType2 = setter2.getParameterTypes()[0])) {
            return setter2;
        }
        if (paramType2.isAssignableFrom(paramType1)) {
            return setter1;
        }
        throw new ReflectionException("Ambiguous setters defined for property '" + property + "' in class '" + setter2.getDeclaringClass() + "' with types '" + paramType1.getName() + "' and '" + paramType2.getName() + "'.");
    }

    private void addSetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.setMethods.put(name, new MethodInvoker(method));
            Type[] paramTypes = TypeParameterResolver.resolveParamTypes(method, this.type);
            this.setTypes.put(name, this.typeToClass(paramTypes[0]));
        }
    }

    private Class<?> typeToClass(Type src) {
        Class<?> result = null;
        if (src instanceof Class) {
            result = (Class<?>)src;
        } else if (src instanceof ParameterizedType) {
            result = (Class<?>)((ParameterizedType)src).getRawType();
        } else if (src instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)src).getGenericComponentType();
            if (componentType instanceof Class) {
                result = Array.newInstance((Class)componentType, 0).getClass();
            } else {
                Class<?> componentClass = this.typeToClass(componentType);
                result = Array.newInstance(componentClass, 0).getClass();
            }
        }
        if (result == null) {
            result = Object.class;
        }
        return result;
    }

    private void addFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            int modifiers;
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!field.isAccessible()) continue;
            if (!(this.setMethods.containsKey(field.getName()) || Modifier.isFinal(modifiers = field.getModifiers()) && Modifier.isStatic(modifiers))) {
                this.addSetField(field);
            }
            if (this.getMethods.containsKey(field.getName())) continue;
            this.addGetField(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private void addSetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.setMethods.put(field.getName(), new SetFieldInvoker(field));
            Type fieldType = TypeParameterResolver.resolveFieldType(field, this.type);
            this.setTypes.put(field.getName(), this.typeToClass(fieldType));
        }
    }

    private void addGetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.getMethods.put(field.getName(), new GetFieldInvoker(field));
            Type fieldType = TypeParameterResolver.resolveFieldType(field, this.type);
            this.getTypes.put(field.getName(), this.typeToClass(fieldType));
        }
    }

    private boolean isValidPropertyName(String name) {
        return !name.startsWith("$") && !"serialVersionUID".equals(name) && !"class".equals(name);
    }

    private Method[] getClassMethods(Class<?> cls) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        for (Class<?> currentClass = cls; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            for (Class<?> anInterface : interfaces = currentClass.getInterfaces()) {
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(Map<String, Method> uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    currentMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        Class<?> returnType = method.getReturnType();
        if (returnType != null) {
            sb.append(returnType.getName()).append('#');
        }
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (i2 == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i2].getName());
        }
        return sb.toString();
    }

    private static boolean canAccessPrivateMethods() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Constructor<?> getDefaultConstructor() {
        if (this.defaultConstructor != null) {
            return this.defaultConstructor;
        }
        throw new ReflectionException("There is no default constructor for " + this.type);
    }

    public boolean hasDefaultConstructor() {
        return this.defaultConstructor != null;
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = this.setMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = this.getMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Class<?> getSetterType(String propertyName) {
        Class<?> clazz = this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public Class<?> getGetterType(String propertyName) {
        Class<?> clazz = this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public String[] getGetablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getSetablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasSetter(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasGetter(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public String findPropertyName(String name) {
        return this.caseInsensitivePropertyMap.get(name.toUpperCase(Locale.ENGLISH));
    }
}

