/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionHolder;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class SqlSessionUtils {
    private static final Log LOGGER = LogFactory.getLog(SqlSessionUtils.class);
    private static final String NO_EXECUTOR_TYPE_SPECIFIED = "No ExecutorType specified";
    private static final String NO_SQL_SESSION_FACTORY_SPECIFIED = "No SqlSessionFactory specified";
    private static final String NO_SQL_SESSION_SPECIFIED = "No SqlSession specified";

    private SqlSessionUtils() {
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        ExecutorType executorType = sessionFactory.getConfiguration().getDefaultExecutorType();
        return SqlSessionUtils.getSqlSession(sessionFactory, executorType, null);
    }

    public static SqlSession getSqlSession(SqlSessionFactory sessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)sessionFactory, NO_SQL_SESSION_FACTORY_SPECIFIED);
        Assert.notNull((Object)executorType, NO_EXECUTOR_TYPE_SPECIFIED);
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        SqlSession session = SqlSessionUtils.sessionHolder(executorType, holder);
        if (session != null) {
            return session;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating a new SqlSession");
        }
        session = sessionFactory.openSession(executorType);
        SqlSessionUtils.registerSessionHolder(sessionFactory, executorType, exceptionTranslator, session);
        return session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void registerSessionHolder(SqlSessionFactory sessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator, SqlSession session) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Environment environment2 = sessionFactory.getConfiguration().getEnvironment();
            if (environment2.getTransactionFactory() instanceof SpringManagedTransactionFactory) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Registering transaction synchronization for SqlSession [" + session + "]");
                }
                SqlSessionHolder holder = new SqlSessionHolder(session, executorType, exceptionTranslator);
                TransactionSynchronizationManager.bindResource(sessionFactory, holder);
                TransactionSynchronizationManager.registerSynchronization(new SqlSessionSynchronization(holder, sessionFactory));
                holder.setSynchronizedWithTransaction(true);
                holder.requested();
                return;
            } else {
                if (TransactionSynchronizationManager.getResource(environment2.getDataSource()) != null) throw new TransientDataAccessResourceException("SqlSessionFactory must be using a SpringManagedTransactionFactory in order to use Spring transaction synchronization");
                if (!LOGGER.isDebugEnabled()) return;
                LOGGER.debug("SqlSession [" + session + "] was not registered for synchronization because DataSource is not transactional");
            }
            return;
        } else {
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug("SqlSession [" + session + "] was not registered for synchronization because synchronization is not active");
        }
    }

    private static SqlSession sessionHolder(ExecutorType executorType, SqlSessionHolder holder) {
        SqlSession session = null;
        if (holder != null && holder.isSynchronizedWithTransaction()) {
            if (holder.getExecutorType() != executorType) {
                throw new TransientDataAccessResourceException("Cannot change the ExecutorType when there is an existing transaction");
            }
            holder.requested();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Fetched SqlSession [" + holder.getSqlSession() + "] from current transaction");
            }
            session = holder.getSqlSession();
        }
        return session;
    }

    public static void closeSqlSession(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, NO_SQL_SESSION_SPECIFIED);
        Assert.notNull((Object)sessionFactory, NO_SQL_SESSION_FACTORY_SPECIFIED);
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (holder != null && holder.getSqlSession() == session) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Releasing transactional SqlSession [" + session + "]");
            }
            holder.released();
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Closing non transactional SqlSession [" + session + "]");
            }
            session.close();
        }
    }

    public static boolean isSqlSessionTransactional(SqlSession session, SqlSessionFactory sessionFactory) {
        Assert.notNull((Object)session, NO_SQL_SESSION_SPECIFIED);
        Assert.notNull((Object)sessionFactory, NO_SQL_SESSION_FACTORY_SPECIFIED);
        SqlSessionHolder holder = (SqlSessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        return holder != null && holder.getSqlSession() == session;
    }

    private static final class SqlSessionSynchronization
    extends TransactionSynchronizationAdapter {
        private final SqlSessionHolder holder;
        private final SqlSessionFactory sessionFactory;
        private boolean holderActive = true;

        public SqlSessionSynchronization(SqlSessionHolder holder, SqlSessionFactory sessionFactory) {
            Assert.notNull((Object)holder, "Parameter 'holder' must be not null");
            Assert.notNull((Object)sessionFactory, "Parameter 'sessionFactory' must be not null");
            this.holder = holder;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public int getOrder() {
            return 999;
        }

        @Override
        public void suspend() {
            if (this.holderActive) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization suspending SqlSession [" + this.holder.getSqlSession() + "]");
                }
                TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            }
        }

        @Override
        public void resume() {
            if (this.holderActive) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization resuming SqlSession [" + this.holder.getSqlSession() + "]");
                }
                TransactionSynchronizationManager.bindResource(this.sessionFactory, this.holder);
            }
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transaction synchronization committing SqlSession [" + this.holder.getSqlSession() + "]");
                    }
                    this.holder.getSqlSession().commit();
                }
                catch (PersistenceException p) {
                    DataAccessException translated;
                    if (this.holder.getPersistenceExceptionTranslator() != null && (translated = this.holder.getPersistenceExceptionTranslator().translateExceptionIfPossible(p)) != null) {
                        throw translated;
                    }
                    throw p;
                }
            }
        }

        @Override
        public void beforeCompletion() {
            if (!this.holder.isOpen()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization deregistering SqlSession [" + this.holder.getSqlSession() + "]");
                }
                TransactionSynchronizationManager.unbindResource(this.sessionFactory);
                this.holderActive = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization closing SqlSession [" + this.holder.getSqlSession() + "]");
                }
                this.holder.getSqlSession().close();
            }
        }

        @Override
        public void afterCompletion(int status) {
            if (this.holderActive) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization deregistering SqlSession [" + this.holder.getSqlSession() + "]");
                }
                TransactionSynchronizationManager.unbindResourceIfPossible(this.sessionFactory);
                this.holderActive = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transaction synchronization closing SqlSession [" + this.holder.getSqlSession() + "]");
                }
                this.holder.getSqlSession().close();
            }
            this.holder.reset();
        }
    }
}

