/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.ListenerContainerFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class RabbitNamespaceUtils {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    private static final String ACKNOWLEDGE_AUTO = "auto";
    private static final String ACKNOWLEDGE_MANUAL = "manual";
    private static final String ACKNOWLEDGE_NONE = "none";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String CONCURRENCY_ATTRIBUTE = "concurrency";
    private static final String MAX_CONCURRENCY_ATTRIBUTE = "max-concurrency";
    private static final String MIN_START_INTERVAL_ATTRIBUTE = "min-start-interval";
    private static final String MIN_STOP_INTERVAL_ATTRIBUTE = "min-stop-interval";
    private static final String MIN_CONSECUTIVE_ACTIVE_ATTRIBUTE = "min-consecutive-active";
    private static final String MIN_CONSECUTIVE_IDLE_ATTRIBUTE = "min-consecutive-idle";
    private static final String PREFETCH_ATTRIBUTE = "prefetch";
    private static final String RECEIVE_TIMEOUT_ATTRIBUTE = "receive-timeout";
    private static final String CHANNEL_TRANSACTED_ATTRIBUTE = "channel-transacted";
    private static final String TRANSACTION_SIZE_ATTRIBUTE = "transaction-size";
    private static final String PHASE_ATTRIBUTE = "phase";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String ADVICE_CHAIN_ATTRIBUTE = "advice-chain";
    private static final String REQUEUE_REJECTED_ATTRIBUTE = "requeue-rejected";
    private static final String RECOVERY_INTERVAL = "recovery-interval";
    private static final String RECOVERY_BACK_OFF = "recovery-back-off";
    private static final String MISSING_QUEUES_FATAL = "missing-queues-fatal";
    private static final String POSSIBLE_AUTHENTICATION_FAILURE_FATAL = "possible-authentication-failure-fatal";
    private static final String MISMATCHED_QUEUES_FATAL = "mismatched-queues-fatal";
    private static final String AUTO_DECLARE = "auto-declare";
    private static final String DECLARATION_RETRIES = "declaration-retries";
    private static final String FAILED_DECLARATION_RETRY_INTERVAL = "failed-declaration-retry-interval";
    private static final String MISSING_QUEUE_RETRY_INTERVAL = "missing-queue-retry-interval";
    private static final String CONSUMER_TAG_STRATEGY = "consumer-tag-strategy";
    private static final String IDLE_EVENT_INTERVAL = "idle-event-interval";
    private static final String CONSUMERS_PER_QUEUE = "consumers-per-queue";
    private static final String TASK_SCHEDULER = "task-scheduler";
    private static final String MONITOR_INTERVAL = "monitor-interval";
    private static final String TYPE = "type";
    private static final String AFTER_RECEIVE_POST_PROCESSORS = "after-receive-post-processors";

    private RabbitNamespaceUtils() {
    }

    public static BeanDefinition parseContainer(Element containerEle, ParserContext parserContext) {
        String afterReceivePostProcessors;
        String monitorInterval;
        String taskScheduler;
        String consumersPerQueue;
        String idleEventInterval;
        String consumerTagStrategy;
        String retryDeclarationInterval;
        String failedDeclarationRetryInterval;
        String declarationRetries;
        String autoDeclare;
        String mismatchedQueuesFatal;
        String possibleAuthenticationFailureFatal;
        String missingQueuesFatal;
        String adviceChain;
        String autoStartup;
        String phase;
        String requeueRejected;
        String transactionSize;
        String channelTransacted;
        String receiveTimeout;
        String prefetch;
        String minConsecutiveIdle;
        String minConsecutiveMessages;
        String minStopInterval;
        String minStartInterval;
        String maxConcurrency;
        String concurrency;
        String transactionManagerBeanName;
        AcknowledgeMode acknowledgeMode;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        String type;
        RootBeanDefinition containerDef = new RootBeanDefinition(ListenerContainerFactoryBean.class);
        containerDef.setSource(parserContext.extractSource(containerEle));
        String connectionFactoryBeanName = "rabbitConnectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", containerEle);
        }
        if (StringUtils.hasText(connectionFactoryBeanName)) {
            containerDef.getPropertyValues().add("connectionFactory", new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (containerEle.hasAttribute(TYPE) && StringUtils.hasText(type = containerEle.getAttribute(TYPE))) {
            containerDef.getPropertyValues().add(TYPE, new TypedStringValue(type));
        }
        if (StringUtils.hasText(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("taskExecutor", new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("errorHandler", new RuntimeBeanReference(errorHandlerBeanName));
        }
        if ((acknowledgeMode = RabbitNamespaceUtils.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            containerDef.getPropertyValues().add("acknowledgeMode", (Object)acknowledgeMode);
        }
        if (StringUtils.hasText(transactionManagerBeanName = containerEle.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("transactionManager", new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText(concurrency = containerEle.getAttribute(CONCURRENCY_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("concurrentConsumers", new TypedStringValue(concurrency));
        }
        if (StringUtils.hasText(maxConcurrency = containerEle.getAttribute(MAX_CONCURRENCY_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("maxConcurrentConsumers", new TypedStringValue(maxConcurrency));
        }
        if (StringUtils.hasText(minStartInterval = containerEle.getAttribute(MIN_START_INTERVAL_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("startConsumerMinInterval", new TypedStringValue(minStartInterval));
        }
        if (StringUtils.hasText(minStopInterval = containerEle.getAttribute(MIN_STOP_INTERVAL_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("stopConsumerMinInterval", new TypedStringValue(minStopInterval));
        }
        if (StringUtils.hasText(minConsecutiveMessages = containerEle.getAttribute(MIN_CONSECUTIVE_ACTIVE_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("consecutiveActiveTrigger", new TypedStringValue(minConsecutiveMessages));
        }
        if (StringUtils.hasText(minConsecutiveIdle = containerEle.getAttribute(MIN_CONSECUTIVE_IDLE_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("consecutiveIdleTrigger", new TypedStringValue(minConsecutiveIdle));
        }
        if (StringUtils.hasText(prefetch = containerEle.getAttribute(PREFETCH_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("prefetchCount", new TypedStringValue(prefetch));
        }
        if (StringUtils.hasText(receiveTimeout = containerEle.getAttribute(RECEIVE_TIMEOUT_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("receiveTimeout", new TypedStringValue(receiveTimeout));
        }
        if (StringUtils.hasText(channelTransacted = containerEle.getAttribute(CHANNEL_TRANSACTED_ATTRIBUTE))) {
            if (AcknowledgeMode.NONE == acknowledgeMode && channelTransacted.equalsIgnoreCase("true")) {
                parserContext.getReaderContext().error("Listener Container - cannot set channel-transacted with acknowledge='NONE'", containerEle);
            }
            containerDef.getPropertyValues().add("channelTransacted", new TypedStringValue(channelTransacted));
        }
        if (StringUtils.hasText(transactionSize = containerEle.getAttribute(TRANSACTION_SIZE_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("txSize", new TypedStringValue(transactionSize));
        }
        if (StringUtils.hasText(requeueRejected = containerEle.getAttribute(REQUEUE_REJECTED_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("defaultRequeueRejected", new TypedStringValue(requeueRejected));
        }
        if (StringUtils.hasText(phase = containerEle.getAttribute(PHASE_ATTRIBUTE))) {
            containerDef.getPropertyValues().add(PHASE_ATTRIBUTE, phase);
        }
        if (StringUtils.hasText(autoStartup = containerEle.getAttribute(AUTO_STARTUP_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("autoStartup", new TypedStringValue(autoStartup));
        }
        if (StringUtils.hasText(adviceChain = containerEle.getAttribute(ADVICE_CHAIN_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("adviceChain", new RuntimeBeanReference(adviceChain));
        }
        String recoveryInterval = containerEle.getAttribute(RECOVERY_INTERVAL);
        String recoveryBackOff = containerEle.getAttribute(RECOVERY_BACK_OFF);
        if (StringUtils.hasText(recoveryInterval)) {
            if (StringUtils.hasText(recoveryBackOff)) {
                parserContext.getReaderContext().error("'recovery-interval' and 'recovery-back-off' are mutually exclusive", containerEle);
            }
            containerDef.getPropertyValues().add("recoveryInterval", new TypedStringValue(recoveryInterval));
        }
        if (StringUtils.hasText(recoveryBackOff)) {
            containerDef.getPropertyValues().add("recoveryBackOff", new RuntimeBeanReference(recoveryBackOff));
        }
        if (StringUtils.hasText(missingQueuesFatal = containerEle.getAttribute(MISSING_QUEUES_FATAL))) {
            containerDef.getPropertyValues().add("missingQueuesFatal", new TypedStringValue(missingQueuesFatal));
        }
        if (StringUtils.hasText(possibleAuthenticationFailureFatal = containerEle.getAttribute(POSSIBLE_AUTHENTICATION_FAILURE_FATAL))) {
            containerDef.getPropertyValues().add("possibleAuthenticationFailureFatal", new TypedStringValue(possibleAuthenticationFailureFatal));
        }
        if (StringUtils.hasText(mismatchedQueuesFatal = containerEle.getAttribute(MISMATCHED_QUEUES_FATAL))) {
            containerDef.getPropertyValues().add("mismatchedQueuesFatal", new TypedStringValue(mismatchedQueuesFatal));
        }
        if (StringUtils.hasText(autoDeclare = containerEle.getAttribute(AUTO_DECLARE))) {
            containerDef.getPropertyValues().add("autoDeclare", new TypedStringValue(autoDeclare));
        }
        if (StringUtils.hasText(declarationRetries = containerEle.getAttribute(DECLARATION_RETRIES))) {
            containerDef.getPropertyValues().add("declarationRetries", new TypedStringValue(declarationRetries));
        }
        if (StringUtils.hasText(failedDeclarationRetryInterval = containerEle.getAttribute(FAILED_DECLARATION_RETRY_INTERVAL))) {
            containerDef.getPropertyValues().add("failedDeclarationRetryInterval", new TypedStringValue(failedDeclarationRetryInterval));
        }
        if (StringUtils.hasText(retryDeclarationInterval = containerEle.getAttribute(MISSING_QUEUE_RETRY_INTERVAL))) {
            containerDef.getPropertyValues().add("retryDeclarationInterval", new TypedStringValue(retryDeclarationInterval));
        }
        if (StringUtils.hasText(consumerTagStrategy = containerEle.getAttribute(CONSUMER_TAG_STRATEGY))) {
            containerDef.getPropertyValues().add("consumerTagStrategy", new RuntimeBeanReference(consumerTagStrategy));
        }
        if (StringUtils.hasText(idleEventInterval = containerEle.getAttribute(IDLE_EVENT_INTERVAL))) {
            containerDef.getPropertyValues().add("idleEventInterval", new TypedStringValue(idleEventInterval));
        }
        if (StringUtils.hasText(consumersPerQueue = containerEle.getAttribute(CONSUMERS_PER_QUEUE))) {
            containerDef.getPropertyValues().add("consumersPerQueue", new TypedStringValue(consumersPerQueue));
        }
        if (StringUtils.hasText(taskScheduler = containerEle.getAttribute(TASK_SCHEDULER))) {
            containerDef.getPropertyValues().add("taskScheduler", new RuntimeBeanReference(taskScheduler));
        }
        if (StringUtils.hasText(monitorInterval = containerEle.getAttribute(MONITOR_INTERVAL))) {
            containerDef.getPropertyValues().add("monitorInterval", new TypedStringValue(monitorInterval));
        }
        if (StringUtils.hasText(afterReceivePostProcessors = containerEle.getAttribute(AFTER_RECEIVE_POST_PROCESSORS))) {
            String[] names = StringUtils.delimitedListToStringArray(afterReceivePostProcessors, ",", " ");
            ManagedList<RuntimeBeanReference> values = new ManagedList<RuntimeBeanReference>();
            for (String name : names) {
                values.add(new RuntimeBeanReference(name));
            }
            containerDef.getPropertyValues().add("afterReceivePostProcessors", values);
        }
        return containerDef;
    }

    private static AcknowledgeMode parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        AcknowledgeMode acknowledgeMode = null;
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText(acknowledge)) {
            if (ACKNOWLEDGE_AUTO.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.AUTO;
            } else if (ACKNOWLEDGE_MANUAL.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.MANUAL;
            } else if (ACKNOWLEDGE_NONE.equals(acknowledge)) {
                acknowledgeMode = AcknowledgeMode.NONE;
            } else {
                parserContext.getReaderContext().error("Invalid listener container 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"manual\", and \"none\" supported.", ele);
            }
            return acknowledgeMode;
        }
        return null;
    }
}

