/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitMessageOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public class RabbitMessagingTemplate
extends AbstractMessagingTemplate<String>
implements RabbitMessageOperations,
InitializingBean {
    private RabbitTemplate rabbitTemplate;
    private MessageConverter amqpMessageConverter = new MessagingMessageConverter();
    private boolean converterSet;

    public RabbitMessagingTemplate() {
    }

    public RabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
        Assert.notNull((Object)rabbitTemplate, "'rabbitTemplate' must not be null");
        this.rabbitTemplate = rabbitTemplate;
    }

    public void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void setAmqpMessageConverter(MessageConverter amqpMessageConverter) {
        this.amqpMessageConverter = amqpMessageConverter;
        this.converterSet = true;
    }

    public MessageConverter getAmqpMessageConverter() {
        return this.amqpMessageConverter;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getRabbitTemplate(), "Property 'rabbitTemplate' is required");
        Assert.notNull((Object)this.getAmqpMessageConverter(), "Property 'amqpMessageConverter' is required");
        if (!this.converterSet && this.rabbitTemplate.getMessageConverter() != null) {
            ((MessagingMessageConverter)this.amqpMessageConverter).setPayloadConverter(this.rabbitTemplate.getMessageConverter());
        }
    }

    @Override
    public void send(String exchange2, String routingKey, Message<?> message) throws MessagingException {
        this.doSend(exchange2, routingKey, message);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object payload) throws MessagingException {
        this.convertAndSend(exchange2, routingKey, payload, (Map<String, Object>)null);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object payload, @Nullable Map<String, Object> headers) throws MessagingException {
        this.convertAndSend(exchange2, routingKey, payload, headers, null);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object payload, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        this.convertAndSend(exchange2, routingKey, payload, null, postProcessor);
    }

    @Override
    public void convertAndSend(String exchange2, String routingKey, Object payload, @Nullable Map<String, Object> headers, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Message<?> message = this.doConvert(payload, headers, postProcessor);
        this.send(exchange2, routingKey, message);
    }

    @Override
    @Nullable
    public Message<?> sendAndReceive(String exchange2, String routingKey, Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(exchange2, routingKey, requestMessage);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(String exchange2, String routingKey, Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(exchange2, routingKey, request, null, targetClass);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(String exchange2, String routingKey, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(exchange2, routingKey, request, headers, targetClass, null);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(String exchange2, String routingKey, Object request, Class<T> targetClass, @Nullable MessagePostProcessor requestPostProcessor) throws MessagingException {
        return this.convertSendAndReceive(exchange2, routingKey, request, null, targetClass, requestPostProcessor);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(String exchange2, String routingKey, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor requestPostProcessor) throws MessagingException {
        Message<?> requestMessage = this.doConvert(request, headers, requestPostProcessor);
        Message<?> replyMessage = this.sendAndReceive(exchange2, routingKey, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    @Override
    protected void doSend(String destination, Message<?> message) {
        try {
            this.rabbitTemplate.send(destination, this.createMessage(message));
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    protected void doSend(String exchange2, String routingKey, Message<?> message) {
        try {
            this.rabbitTemplate.send(exchange2, routingKey, this.createMessage(message));
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    @Override
    protected Message<?> doReceive(String destination) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.receive(destination);
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    @Override
    @Nullable
    protected Message<?> doSendAndReceive(String destination, Message<?> requestMessage) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.sendAndReceive(destination, this.createMessage(requestMessage));
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    @Nullable
    protected Message<?> doSendAndReceive(String exchange2, String routingKey, Message<?> requestMessage) {
        try {
            org.springframework.amqp.core.Message amqpMessage = this.rabbitTemplate.sendAndReceive(exchange2, routingKey, this.createMessage(requestMessage));
            return this.convertAmqpMessage(amqpMessage);
        }
        catch (RuntimeException ex) {
            throw this.convertAmqpException(ex);
        }
    }

    private org.springframework.amqp.core.Message createMessage(Message<?> message) {
        try {
            return this.getAmqpMessageConverter().toMessage(message, new MessageProperties());
        }
        catch (org.springframework.amqp.support.converter.MessageConversionException ex) {
            throw new MessageConversionException("Could not convert '" + message + "'", (Throwable)ex);
        }
    }

    @Nullable
    protected Message<?> convertAmqpMessage(@Nullable org.springframework.amqp.core.Message message) {
        if (message == null) {
            return null;
        }
        try {
            return (Message)this.getAmqpMessageConverter().fromMessage(message);
        }
        catch (Exception ex) {
            throw new MessageConversionException("Could not convert '" + message + "'", (Throwable)ex);
        }
    }

    protected MessagingException convertAmqpException(RuntimeException ex) {
        if (ex instanceof MessagingException) {
            return (MessagingException)ex;
        }
        if (ex instanceof org.springframework.amqp.support.converter.MessageConversionException) {
            return new MessageConversionException(ex.getMessage(), (Throwable)ex);
        }
        return new MessagingException(ex.getMessage(), (Throwable)ex);
    }
}

