/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import org.springframework.amqp.AmqpRemoteException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.Assert;

public class RemoteInvocationAwareMessageConverterAdapter
implements MessageConverter,
BeanClassLoaderAware {
    private final MessageConverter delegate;
    private final boolean shouldSetClassLoader;

    public RemoteInvocationAwareMessageConverterAdapter() {
        this.delegate = new SimpleMessageConverter();
        this.shouldSetClassLoader = true;
    }

    public RemoteInvocationAwareMessageConverterAdapter(MessageConverter delegate) {
        Assert.notNull((Object)delegate, "'delegate' converter cannot be null");
        this.delegate = delegate;
        this.shouldSetClassLoader = false;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        if (this.shouldSetClassLoader) {
            ((SimpleMessageConverter)this.delegate).setBeanClassLoader(classLoader);
        }
    }

    @Override
    public Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        return this.delegate.toMessage(object, messageProperties);
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object result = this.delegate.fromMessage(message);
        if (result instanceof RemoteInvocationResult) {
            try {
                result = ((RemoteInvocationResult)result).recreate();
                if (result == null) {
                    throw new MessageConversionException("RemoteInvocationResult returned null");
                }
            }
            catch (Throwable e) {
                throw new AmqpRemoteException(e);
            }
        }
        return result;
    }
}

