/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;
import org.springframework.core.Ordered;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractCompressingPostProcessor
implements MessagePostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final boolean autoDecompress;
    private int order;
    private boolean copyProperties = false;

    public AbstractCompressingPostProcessor() {
        this(true);
    }

    public AbstractCompressingPostProcessor(boolean autoDecompress) {
        this.autoDecompress = autoDecompress;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    @Override
    public Message postProcessMessage(Message message) throws AmqpException {
        try {
            MessagePropertiesBuilder messagePropertiesBuilder;
            ByteArrayOutputStream zipped = new ByteArrayOutputStream();
            OutputStream zipper = this.getCompressorStream(zipped);
            FileCopyUtils.copy(new ByteArrayInputStream(message.getBody()), zipper);
            byte[] compressed = zipped.toByteArray();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Compressed " + message.getBody().length + " to " + compressed.length);
            }
            MessageProperties originalProperties = message.getMessageProperties();
            MessagePropertiesBuilder messagePropertiesBuilder2 = messagePropertiesBuilder = this.copyProperties ? MessagePropertiesBuilder.fromClonedProperties(originalProperties) : MessagePropertiesBuilder.fromProperties(originalProperties);
            if (this.autoDecompress) {
                messagePropertiesBuilder.setHeader("springAutoDecompress", true);
            }
            MessageProperties messageProperties = (MessageProperties)messagePropertiesBuilder.setContentEncoding(this.getEncoding() + (originalProperties.getContentEncoding() == null ? "" : ":" + originalProperties.getContentEncoding())).build();
            return new Message(compressed, messageProperties);
        }
        catch (IOException e) {
            throw new AmqpIOException(e);
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    protected void setOrder(int order) {
        this.order = order;
    }

    protected abstract OutputStream getCompressorStream(OutputStream var1) throws IOException;

    protected abstract String getEncoding();
}

