/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.couchbase")
public class CouchbaseProperties {
    private List<String> bootstrapHosts;
    private String username;
    private String password;
    private final Bucket bucket = new Bucket();
    private final Env env = new Env();

    public List<String> getBootstrapHosts() {
        return this.bootstrapHosts;
    }

    public void setBootstrapHosts(List<String> bootstrapHosts) {
        this.bootstrapHosts = bootstrapHosts;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public Env getEnv() {
        return this.env;
    }

    public static class Bootstrap {
        private Integer httpDirectPort;
        private Integer httpSslPort;

        public Integer getHttpDirectPort() {
            return this.httpDirectPort;
        }

        public void setHttpDirectPort(Integer httpDirectPort) {
            this.httpDirectPort = httpDirectPort;
        }

        public Integer getHttpSslPort() {
            return this.httpSslPort;
        }

        public void setHttpSslPort(Integer httpSslPort) {
            this.httpSslPort = httpSslPort;
        }
    }

    public static class Timeouts {
        private Duration connect = Duration.ofMillis(5000L);
        private Duration keyValue = Duration.ofMillis(2500L);
        private Duration query = Duration.ofMillis(7500L);
        private Duration socketConnect = Duration.ofMillis(1000L);
        private Duration view = Duration.ofMillis(7500L);

        public Duration getConnect() {
            return this.connect;
        }

        public void setConnect(Duration connect) {
            this.connect = connect;
        }

        public Duration getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(Duration keyValue) {
            this.keyValue = keyValue;
        }

        public Duration getQuery() {
            return this.query;
        }

        public void setQuery(Duration query2) {
            this.query = query2;
        }

        public Duration getSocketConnect() {
            return this.socketConnect;
        }

        public void setSocketConnect(Duration socketConnect) {
            this.socketConnect = socketConnect;
        }

        public Duration getView() {
            return this.view;
        }

        public void setView(Duration view) {
            this.view = view;
        }
    }

    public static class Ssl {
        private Boolean enabled;
        private String keyStore;
        private String keyStorePassword;

        public Boolean getEnabled() {
            return this.enabled != null ? this.enabled : StringUtils.hasText(this.keyStore);
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }
    }

    public static class Endpoints {
        private int keyValue = 1;
        private final CouchbaseService queryservice = new CouchbaseService();
        private final CouchbaseService viewservice = new CouchbaseService();

        public int getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(int keyValue) {
            this.keyValue = keyValue;
        }

        public CouchbaseService getQueryservice() {
            return this.queryservice;
        }

        public CouchbaseService getViewservice() {
            return this.viewservice;
        }

        public static class CouchbaseService {
            private int minEndpoints = 1;
            private int maxEndpoints = 1;

            public int getMinEndpoints() {
                return this.minEndpoints;
            }

            public void setMinEndpoints(int minEndpoints) {
                this.minEndpoints = minEndpoints;
            }

            public int getMaxEndpoints() {
                return this.maxEndpoints;
            }

            public void setMaxEndpoints(int maxEndpoints) {
                this.maxEndpoints = maxEndpoints;
            }
        }
    }

    public static class Env {
        private final Bootstrap bootstrap = new Bootstrap();
        private final Endpoints endpoints = new Endpoints();
        private final Ssl ssl = new Ssl();
        private final Timeouts timeouts = new Timeouts();

        public Bootstrap getBootstrap() {
            return this.bootstrap;
        }

        public Endpoints getEndpoints() {
            return this.endpoints;
        }

        public Ssl getSsl() {
            return this.ssl;
        }

        public Timeouts getTimeouts() {
            return this.timeouts;
        }
    }

    public static class Bucket {
        private String name = "default";
        private String password = "";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

