/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PersistentEntities
implements Streamable<PersistentEntity<?, ? extends PersistentProperty<?>>> {
    private final Streamable<? extends MappingContext<?, ? extends PersistentProperty<?>>> contexts;

    public PersistentEntities(Iterable<? extends MappingContext<?, ?>> contexts) {
        Assert.notNull(contexts, "MappingContexts must not be null!");
        this.contexts = Streamable.of(contexts);
    }

    public static PersistentEntities of(MappingContext<?, ?> ... contexts) {
        Assert.notNull(contexts, "MappingContexts must not be null!");
        return new PersistentEntities(Arrays.asList(contexts));
    }

    public Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> getPersistentEntity(Class<?> type) {
        return this.contexts.stream().filter(it -> it.hasPersistentEntityFor(type)).findFirst().map((? super T it) -> it.getRequiredPersistentEntity(type));
    }

    public PersistentEntity<?, ? extends PersistentProperty<?>> getRequiredPersistentEntity(Class<?> type) {
        Assert.notNull(type, "Domain type must not be null!");
        return this.getPersistentEntity(type).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find PersistentEntity for type %s!", type)));
    }

    public <T> Optional<T> mapOnContext(Class<?> type, BiFunction<MappingContext<?, ? extends PersistentProperty<?>>, PersistentEntity<?, ?>, T> combiner) {
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull(combiner, "Combining BiFunction must not be null!");
        return this.contexts.stream().filter(it -> it.hasPersistentEntityFor(type)).map(it -> combiner.apply((MappingContext<?, ? extends PersistentProperty<?>>)it, (PersistentEntity<?, ?>)it.getRequiredPersistentEntity(type))).findFirst();
    }

    public Streamable<TypeInformation<?>> getManagedTypes() {
        return Streamable.of(this.contexts.stream().flatMap(it -> it.getManagedTypes().stream()).collect(Collectors.toSet()));
    }

    @Override
    public Iterator<PersistentEntity<?, ? extends PersistentProperty<?>>> iterator() {
        return this.contexts.stream().flatMap(it -> it.getPersistentEntities().stream()).collect(Collectors.toList()).iterator();
    }

    @Nullable
    public PersistentEntity<?, ?> getEntityUltimatelyReferredToBy(PersistentProperty<?> property) {
        TypeInformation<?> propertyType = property.getTypeInformation().getActualType();
        if (propertyType == null || !property.isAssociation()) {
            return null;
        }
        Class<?> associationTargetType = property.getAssociationTargetType();
        return associationTargetType == null ? this.getEntityIdentifiedBy(propertyType) : this.getPersistentEntity(associationTargetType).orElseGet(() -> this.getEntityIdentifiedBy(propertyType));
    }

    public TypeInformation<?> getTypeUltimatelyReferredToBy(PersistentProperty<?> property) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        PersistentEntity<?, ?> entity = this.getEntityUltimatelyReferredToBy(property);
        return entity == null ? property.getTypeInformation().getRequiredActualType() : entity.getTypeInformation();
    }

    @Nullable
    private PersistentEntity<?, ?> getEntityIdentifiedBy(TypeInformation<?> type) {
        Collection entities = this.contexts.stream().flatMap(it -> it.getPersistentEntities().stream()).map(it -> it.getIdProperty()).filter(it -> it != null && type.equals(it.getTypeInformation().getActualType())).map(it -> it.getOwner()).collect(Collectors.toList());
        if (entities.size() > 1) {
            String message = "Found multiple entities identified by " + type.getType() + ": ";
            message = message + entities.stream().map(it -> it.getType().getName()).collect(Collectors.joining(", "));
            message = message + "! Introduce dedciated unique identifier types or explicitly define the target type in @Reference!";
            throw new IllegalStateException(message);
        }
        return entities.isEmpty() ? null : (PersistentEntity)entities.iterator().next();
    }
}

