/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import springfox.documentation.builders.ContentSpecificationBuilder;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.ParameterSpecificationContext;
import springfox.documentation.builders.ParameterSpecificationProvider;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ContentSpecification;
import springfox.documentation.service.Encoding;
import springfox.documentation.service.ParameterSpecification;
import springfox.documentation.service.Representation;
import springfox.documentation.service.SimpleParameterSpecification;

public class MultipartFormDataParameterSpecificationProvider
implements ParameterSpecificationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartFormDataParameterSpecificationProvider.class);

    @Override
    public ParameterSpecification create(ParameterSpecificationContext context) {
        SimpleParameterSpecification simpleParameter = context.getSimpleParameter();
        ContentSpecification contentParameter = context.getContentParameter();
        ContentSpecificationBuilder contentSpecificationBuilder = context.getContentSpecificationBuilder();
        if (context.getAccepts().stream().noneMatch(mediaType -> mediaType.equalsTypeAndSubtype(MediaType.APPLICATION_FORM_URLENCODED))) {
            if (simpleParameter != null && simpleParameter.getModel() != null) {
                contentSpecificationBuilder.copyOf(contentParameter).requestBody(true).representation(MediaType.MULTIPART_FORM_DATA).apply(r -> r.model(m -> m.copyOf(simpleParameter.getModel())).encoding(context.getName()).apply(e -> e.propertyRef(context.getName()).contentType("text/plain").build()));
            } else if (contentParameter != null) {
                for (Representation each : contentParameter.getRepresentations()) {
                    Optional<Representation> mediaType2 = contentParameter.representationFor(each.getMediaType());
                    contentSpecificationBuilder.copyOf(contentParameter).requestBody(true).representation(each.getMediaType()).apply(r -> {
                        r.model(m -> m.copyOf(mediaType2.map(Representation::getModel).orElse(new ModelSpecificationBuilder().name(context.getName()).scalarModel(ScalarType.STRING).build())));
                        contentParameter.getRepresentations().stream().flatMap(rep -> rep.getEncodings().stream()).forEach(encoding -> r.encoding(encoding.getPropertyRef()).apply(e -> e.copyOf((Encoding)encoding)));
                    });
                }
            } else {
                LOGGER.warn("Parameter should either be a simple or a content type");
                contentSpecificationBuilder.requestBody(true).representation(MediaType.TEXT_PLAIN).apply(r -> r.model(m -> m.copyOf(new ModelSpecificationBuilder().name(context.getName()).scalarModel(ScalarType.STRING).build())).clearEncodings());
            }
        }
        return new ParameterSpecification(null, contentSpecificationBuilder.build());
    }
}

