/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import org.springframework.core.Ordered;
import springfox.documentation.schema.WildcardType;

public class AlternateTypeRule
implements Ordered {
    private final ResolvedType original;
    private final ResolvedType alternate;
    private final int order;

    public AlternateTypeRule(ResolvedType original, ResolvedType alternate) {
        this(original, alternate, Integer.MIN_VALUE);
    }

    public AlternateTypeRule(ResolvedType original, ResolvedType alternate, int order) {
        this.original = original;
        this.alternate = alternate;
        this.order = order;
    }

    public ResolvedType alternateFor(ResolvedType type) {
        if (this.appliesTo(type)) {
            if (WildcardType.hasWildcards(this.original)) {
                return WildcardType.replaceWildcardsFrom(WildcardType.collectReplaceables(type, this.original), this.alternate);
            }
            return this.alternate;
        }
        return type;
    }

    public boolean appliesTo(ResolvedType type) {
        return WildcardType.hasWildcards(this.original) && WildcardType.wildcardMatch(type, this.original) || WildcardType.exactMatch(this.original, type);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public ResolvedType getOriginal() {
        return this.original;
    }

    public ResolvedType getAlternate() {
        return this.alternate;
    }
}

