/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.JaxbPresentInClassPathCondition;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Conditional(value={JaxbPresentInClassPathCondition.class})
public class XmlModelPlugin
implements ModelBuilderPlugin {
    private final TypeResolver typeResolver;

    @Autowired
    public XmlModelPlugin(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Override
    public void apply(ModelContext context) {
        XmlRootElement root;
        XmlType annotation = AnnotationUtils.findAnnotation(this.forClass(context), XmlType.class);
        if (annotation != null) {
            context.getBuilder().xml(this.buildXml(annotation));
            context.getModelSpecificationBuilder().facets(f -> f.xml(this.buildXml(annotation)));
        }
        if ((root = AnnotationUtils.findAnnotation(this.forClass(context), XmlRootElement.class)) != null) {
            context.getBuilder().xml(this.buildXml(root));
            context.getModelSpecificationBuilder().facets(f -> f.xml(this.buildXml(root)));
        }
    }

    private Xml buildXml(XmlType annotation) {
        return new Xml().name(this.defaultToNull(annotation.name())).attribute(false).namespace(this.defaultToNull(annotation.namespace())).wrapped(false);
    }

    private Xml buildXml(XmlRootElement annotation) {
        return new Xml().name(this.defaultToNull(annotation.name())).attribute(false).namespace(this.defaultToNull(annotation.namespace())).wrapped(false);
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    private Class<?> forClass(ModelContext context) {
        return this.typeResolver.resolve(context.getType(), new Type[0]).getErasedType();
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

