/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

@Component
public class BasePathAwareServicesProvider
implements RequestHandlerProvider {
    private final BasePathAwareHandlerMapping basePathAwareMappings;
    private final HandlerMethodResolver methodResolver;
    private final String contextPath;

    @Autowired
    public BasePathAwareServicesProvider(RepositoryRestConfiguration repositoryConfiguration, ApplicationContext applicationContext, HandlerMethodResolver methodResolver, ServletContext servletContext) {
        this.basePathAwareMappings = new BasePathAwareHandlerMapping(repositoryConfiguration);
        this.methodResolver = methodResolver;
        this.basePathAwareMappings.setApplicationContext(applicationContext);
        this.basePathAwareMappings.afterPropertiesSet();
        this.contextPath = Paths.contextPath(servletContext.getContextPath());
    }

    private static boolean isEntitySchemaService(HandlerMethod input) {
        return input.getBeanType().getSimpleName().equals("RepositorySchemaController");
    }

    private static boolean isAlpsProfileServices(HandlerMethod input) {
        return AlpsController.class.equals(input.getBeanType());
    }

    @Override
    public List<RequestHandler> requestHandlers() {
        ArrayList<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
        for (Map.Entry each : this.basePathAwareMappings.getHandlerMethods().entrySet()) {
            if (BasePathAwareServicesProvider.isEntitySchemaService((HandlerMethod)each.getValue()) || BasePathAwareServicesProvider.isAlpsProfileServices((HandlerMethod)each.getValue())) continue;
            requestHandlers.add(new WebMvcRequestHandler(this.contextPath, this.methodResolver, (RequestMappingInfo)each.getKey(), (HandlerMethod)each.getValue()));
        }
        return requestHandlers;
    }
}

