/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityAssociationContext;
import springfox.documentation.spring.data.rest.EntityAssociationOperationsExtractor;
import springfox.documentation.spring.data.rest.SpecificationBuilder;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

public class EntityAssociationSaveExtractor
implements EntityAssociationOperationsExtractor {
    @Override
    public List<RequestHandler> extract(EntityAssociationContext context) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        PersistentProperty<?> property = context.getAssociation().getInverse();
        String mappingPath = context.associationMetadata().map(metadata -> metadata.getMappingFor(property)).map(ResourceMapping::getPath).map(Path::toString).orElse("");
        context.getEntityContext().entity().filter(entity -> property.isWritable() && property.getOwner().equals(entity)).ifPresent(entity -> {
            String path = String.format("%s%s/{id}/%s", context.getEntityContext().basePath(), context.getEntityContext().resourcePath(), mappingPath);
            SpecificationBuilder.associationAction(context, path).supportsMethod(RequestMethod.PUT).supportsMethod(RequestMethod.PATCH).supportsMethod(RequestMethod.POST).consumes(RestMediaTypes.TEXT_URI_LIST).consumes(RestMediaTypes.SPRING_DATA_COMPACT_JSON).parameterType(SpecificationBuilder.ParameterType.ID).parameterType(SpecificationBuilder.ParameterType.RESOURCE).build().map(update -> new SpringDataRestRequestHandler(context.getEntityContext(), (ActionSpecification)update)).ifPresent(handlers::add);
        });
        return handlers;
    }
}

