/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;

class RequestExtractionUtils {
    private RequestExtractionUtils() {
        throw new UnsupportedOperationException();
    }

    static String lowerCamelCaseName(String stringValue) {
        return Character.toLowerCase(stringValue.charAt(0)) + stringValue.substring(1);
    }

    static String upperCamelCaseName(String stringValue) {
        return Character.toUpperCase(stringValue.charAt(0)) + stringValue.substring(1);
    }

    static String actionName(PersistentEntity<?, ?> entity, Method method) {
        return String.format("%s%s", method.getName(), entity.getType().getSimpleName());
    }

    static List<Annotation> pathAnnotations(String name) {
        return RequestExtractionUtils.pathAnnotations(name, null);
    }

    static List<Annotation> pathAnnotations(String name, HandlerMethod handler) {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(handler);
        if (name != null) {
            annotations.add(SynthesizedAnnotations.pathVariable(name));
        }
        return annotations;
    }

    static List<Annotation> bodyAnnotations(HandlerMethod handler) {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(handler);
        annotations.add(SynthesizedAnnotations.REQUEST_BODY_ANNOTATION);
        return annotations;
    }

    private static List<Annotation> handlerAnnotations(HandlerMethod handler) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (handler != null) {
            annotations.addAll(Arrays.asList(AnnotationUtils.getAnnotations(handler.getMethod())));
        }
        return annotations;
    }

    static List<Annotation> bodyAnnotations() {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(null);
        annotations.add(SynthesizedAnnotations.REQUEST_BODY_ANNOTATION);
        return annotations;
    }

    static String propertyIdentifierName(PersistentProperty<?> property) {
        String propertyName = property.getName();
        if (property.isCollectionLike()) {
            propertyName = property.getComponentType().getSimpleName();
        } else if (property.isMap()) {
            propertyName = property.getMapValueType().getSimpleName();
        }
        return String.format("%sId", propertyName.toLowerCase());
    }

    static ResolvedType propertyResponse(PersistentProperty<?> property, TypeResolver resolver) {
        if (property.isCollectionLike()) {
            return resolver.resolve((Type)((Object)CollectionModel.class), property.getComponentType());
        }
        if (property.isMap()) {
            return resolver.resolve((Type)((Object)EntityModel.class), resolver.resolve((Type)((Object)Map.class), new Type[]{String.class, property.getMapValueType()}));
        }
        return resolver.resolve((Type)((Object)EntityModel.class), property.getType());
    }

    static ResolvedType propertyItemResponse(PersistentProperty<?> property, TypeResolver resolver) {
        if (property.isCollectionLike()) {
            return resolver.resolve((Type)((Object)EntityModel.class), property.getComponentType());
        }
        if (property.isMap()) {
            return resolver.resolve((Type)((Object)EntityModel.class), property.getMapValueType());
        }
        return resolver.resolve((Type)((Object)EntityModel.class), property.getType());
    }
}

