/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.service.ResourceGroup;

class ResourcePathProvider {
    private final ResourceGroup resourceGroup;

    ResourcePathProvider(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public Optional<String> resourcePath() {
        return Optional.ofNullable(this.controllerClass().map(this.resourcePathExtractor()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null));
    }

    private Function<Class<?>, String> resourcePathExtractor() {
        return input -> {
            Optional<String> path = Arrays.stream(this.paths((Class<?>)input)).findFirst().filter(((Predicate<String>)String::isEmpty).negate());
            if (!path.isPresent()) {
                return "";
            }
            if (path.get().startsWith("/")) {
                return path.get();
            }
            return "/" + path.get();
        };
    }

    String[] paths(Class<?> controller) {
        RequestMapping annotation = AnnotationUtils.findAnnotation(controller, RequestMapping.class);
        if (annotation != null) {
            return annotation.path();
        }
        return new String[0];
    }

    private Optional<? extends Class<?>> controllerClass() {
        return this.resourceGroup.getControllerClass();
    }
}

