/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import io.swagger.models.Swagger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger2.web.SwaggerTransformationContext;
import springfox.documentation.swagger2.web.WebMvcSwaggerTransformationFilter;

@Order(value=-2147483648)
public class WebMvcBasePathAndHostnameTransformationFilter
implements WebMvcSwaggerTransformationFilter {
    private final Environment env;

    public WebMvcBasePathAndHostnameTransformationFilter(Environment env) {
        this.env = env;
    }

    @Override
    public Swagger transform(SwaggerTransformationContext<HttpServletRequest> context) {
        Swagger swagger = context.getSpecification();
        String hostNameOverride = this.env.getProperty("springfox.documentation.swagger.v2.host", "DEFAULT");
        context.request().ifPresent(servletRequest -> {
            UriComponents uriComponents = HostNameProvider.componentsFrom(servletRequest, swagger.getBasePath());
            String basePath = StringUtils.isEmpty(uriComponents.getPath()) ? "/" : uriComponents.getPath();
            swagger.basePath(basePath.replace(servletRequest.getContextPath(), ""));
            if (StringUtils.isEmpty(swagger.getHost())) {
                swagger.host(this.hostName(uriComponents, hostNameOverride));
            }
        });
        return swagger;
    }

    private String hostName(UriComponents uriComponents, String hostNameOverride) {
        if ("DEFAULT".equals(hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return hostNameOverride;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.SWAGGER_2;
    }
}

