package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.openai.ChatResponse;
import com.aiup.service.domain.query.GptChatQuery;
import com.aiup.service.domain.response.GptChatResponse;
import com.aiup.service.service.OpenAiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "OpenAI相关接口")
@RestController
@RequestMapping("/v1/bot")
@RequiredArgsConstructor
public class BotController {

    @Autowired
    private OpenAiService openAiService;

    @ApiOperation(value = "向chatGpt发起会话请求")
    @PostMapping("/chat")
    public R<GptChatResponse> chat(@RequestBody GptChatQuery query) {
        return R.ok(openAiService.chat(query));
    }
}
