package com.aiup.service.config;

import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.RSAConfig;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.service.payments.jsapi.JsapiService;
import com.wechat.pay.java.service.payments.jsapi.JsapiServiceExtension;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

//@Configuration
public class WXPayConfig {

    /** 商户号 */
    @Value("${wxPay.mchId}")
    private String merchantId ;
    /** 商户API私钥路径 */
    @Value("${wxPay.privateKeyPath}")
    private String privateKeyPath ;
    /** 微信支付秘钥 **/
    @Value("${wxPay.wechatPayCertificatePath}")
    private String wechatPayCertificatePath;
    /** 商户证书序列号 */
    @Value("${wxPay.merchantSerialNumber}")
    private String merchantSerialNumber ;
    /** 商户APIV3密钥 */
    public String apiV3Key ;


    public RSAConfig initConfig(){
        return new RSAConfig.Builder()  .
                merchantId(merchantId)
                .privateKeyFromPath(privateKeyPath)
                .merchantSerialNumber(merchantSerialNumber)
                .wechatPayCertificatesFromPath(wechatPayCertificatePath)
                .build();
    }

    @Bean
    public JsapiService jsapiService(){
        RSAConfig config = initConfig();
        return new JsapiService.Builder().config(config).build();
    }

    @Bean
    public JsapiServiceExtension jsapiServiceExtension(){
        RSAConfig config = initConfig();
        return new JsapiServiceExtension.Builder().config(config).build();
    }

    @Bean
    NotificationConfig notificationConfig(){
        NotificationConfig config = new RSAAutoCertificateConfig.Builder()
                .merchantId(merchantId)
                .privateKeyFromPath(privateKeyPath)
                .merchantSerialNumber(merchantSerialNumber)
                .apiV3Key(apiV3Key)
                .build();
        return config;
    }
}
