package com.aiup.service.dao;

import com.aiup.service.entity.UserLicense;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;

/**
 * 用户许可表(UserLicense)表数据库访问层
 *
 * @author makejava
 * @since 2023-08-22 12:54:44
 */
 @Mapper
public interface UserLicenseDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserLicense queryById(Integer id);

    /**
     * 查询指定行数据
     *
     * @param userLicense 查询条件
     * @param pageable         分页对象
     * @return 对象列表
     */
    List<UserLicense> queryAllByLimit(@Param("bean") UserLicense userLicense, @Param("pageable") Pageable pageable);

    /**
     * 统计总行数
     *
     * @param userLicense 查询条件
     * @return 总行数
     */
    long count(UserLicense userLicense);

    /**
     * 新增数据
     *
     * @param userLicense 实例对象
     * @return 影响行数
     */
    int insert(UserLicense userLicense);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserLicense> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<UserLicense> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserLicense> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<UserLicense> entities);

    /**
     * 修改数据
     *
     * @param userLicense 实例对象
     * @return 影响行数
     */
    int update(UserLicense userLicense);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Integer id);

}

