package com.aiup.service.dao;

import com.aiup.service.entity.UserNotesCnt;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;

/**
 * 用户内容使用次数(UserNotesCnt)表数据库访问层
 *
 * @author makejava
 * @since 2023-08-22 12:54:47
 */
 @Mapper
public interface UserNotesCntDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserNotesCnt queryById(Integer id);

    /**
     * 查询指定行数据
     *
     * @param userNotesCnt 查询条件
     * @param pageable         分页对象
     * @return 对象列表
     */
    List<UserNotesCnt> queryAllByLimit(@Param("bean") UserNotesCnt userNotesCnt, @Param("pageable") Pageable pageable);

    /**
     * 统计总行数
     *
     * @param userNotesCnt 查询条件
     * @return 总行数
     */
    long count(UserNotesCnt userNotesCnt);

    /**
     * 新增数据
     *
     * @param userNotesCnt 实例对象
     * @return 影响行数
     */
    int insert(UserNotesCnt userNotesCnt);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserNotesCnt> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<UserNotesCnt> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserNotesCnt> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<UserNotesCnt> entities);

    /**
     * 修改数据
     *
     * @param userNotesCnt 实例对象
     * @return 影响行数
     */
    int update(UserNotesCnt userNotesCnt);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Integer id);

}

