package com.aiup.service.domain.exception;

import lombok.Data;

@Data
public class CommonException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private String msg;

    private int code = -1;

    private Object entity;

    public CommonException(String msg) {
        super(msg);
        this.msg = msg;
    }

    public CommonException(Throwable e) {
        super(e);
    }

    public CommonException(String msg, Throwable e) {
        super(msg, e);
        this.msg = msg;
    }

    public CommonException(String msg, int code) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public CommonException(String msg, int code, Throwable e) {
        super(msg, e);
        this.msg = msg;
        this.code = code;
    }

    public CommonException(String msg, int code, Object entity) {
        super(msg);
        this.msg = msg;
        this.code = code;
        this.entity = entity;
    }
}

