package com.aiup.service.domain.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@ApiModel("更新用户信息请求对象")
@Data
public class UpdateUserInfoQuery {

    @ApiModelProperty(value = "登录用户ID（前端不用传）", hidden =true)
    private Integer userId;

    /**
     * 性别  0-未知、1-男性、2-女性
     */
    @ApiModelProperty(value = "性别  0-未知、1-男性、2-女性")
    private Integer gender;
    /**
     * 国家
     */
    @ApiModelProperty(value = "国家")
    private String country;
    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private String province;
    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private String city;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickName;
    /**
     * 头像地址
     */
    @ApiModelProperty(value = "头像地址")
    private String avatarUrl;

}
