package com.aiup.service.service;

import com.aiup.service.entity.TemplateInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

/**
 * 模板信息表(TemplateInfo)表服务接口
 *
 * @author makejava
 * @since 2023-08-15 11:18:43
 */
public interface TemplateInfoService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TemplateInfo queryById(Integer id);

    /**
     * 分页查询
     *
     * @param templateInfo 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    Page<TemplateInfo> queryByPage(TemplateInfo templateInfo, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param templateInfo 实例对象
     * @return 实例对象
     */
    TemplateInfo insert(TemplateInfo templateInfo);

    /**
     * 修改数据
     *
     * @param templateInfo 实例对象
     * @return 实例对象
     */
    TemplateInfo update(TemplateInfo templateInfo);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

}
