package com.aiup.service.service;

import com.aiup.service.entity.UserAdvice;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

/**
 * 用户问题表(UserAdvice)表服务接口
 *
 * @author makejava
 * @since 2023-09-05 19:28:46
 */
public interface UserAdviceService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserAdvice queryById(Integer id);

    /**
     * 分页查询
     *
     * @param userAdvice 筛选条件
     * @param pageRequest      分页对象
     * @return 查询结果
     */
    Page<UserAdvice> queryByPage(UserAdvice userAdvice, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userAdvice 实例对象
     * @return 实例对象
     */
    UserAdvice insert(UserAdvice userAdvice);

    /**
     * 修改数据
     *
     * @param userAdvice 实例对象
     * @return 实例对象
     */
    UserAdvice update(UserAdvice userAdvice);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

}
