package com.aiup.service.service;

import com.aiup.service.domain.query.ConfigListQuery;
import com.aiup.service.entity.UserConfig;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import java.util.List;

/**
 * 用户配置信息(UserConfig)表服务接口
 *
 * @author makejava
 * @since 2023-08-29 16:49:49
 */
public interface UserConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param configId 主键
     * @return 实例对象
     */
    UserConfig queryById(Integer configId);

    /**
     * 分页查询
     *
     * @param userConfig  筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    Page<UserConfig> queryByPage(UserConfig userConfig, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userConfig 实例对象
     * @return 实例对象
     */
    UserConfig insert(UserConfig userConfig);

    /**
     * 修改数据
     *
     * @param userConfig 实例对象
     * @return 实例对象
     */
    UserConfig update(UserConfig userConfig);

    /**
     * 通过主键删除数据
     *
     * @param configId 主键
     * @return 是否成功
     */
    boolean deleteById(Integer configId);

    List<UserConfig> getListByType(ConfigListQuery query);
}
