package com.aiup.service.service;

import com.aiup.service.entity.UserNotesCnt;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

/**
 * 用户内容使用次数(UserNotesCnt)表服务接口
 *
 * @author makejava
 * @since 2023-08-18 12:57:02
 */
public interface UserNotesCntService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserNotesCnt queryById(Integer id);

    /**
     * 分页查询
     *
     * @param userNotesCnt 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    Page<UserNotesCnt> queryByPage(UserNotesCnt userNotesCnt, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userNotesCnt 实例对象
     * @return 实例对象
     */
    UserNotesCnt insert(UserNotesCnt userNotesCnt);

    /**
     * 修改数据
     *
     * @param userNotesCnt 实例对象
     * @return 实例对象
     */
    UserNotesCnt update(UserNotesCnt userNotesCnt);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

}
