package com.aiup.service.service;

import com.aiup.service.domain.WxCodeSessionResult;
import com.aiup.service.domain.query.UpdateUserInfoQuery;
import com.aiup.service.domain.query.WeChatGetMobileQuery;
import com.aiup.service.domain.query.WeChatLoginQuery;
import com.aiup.service.domain.response.WeChatSessionKeyResponse;
import com.aiup.service.entity.UserInfo;


public interface WeChatLoginService {
    /**
     * 根据code获取openId
     * @param code
     * @return
     */
    WxCodeSessionResult getOpenIdByCode(String code);

    /**
     * 获取手机号第一步
     * @param query
     * @return
     */
    WeChatSessionKeyResponse getSessionKey(WeChatLoginQuery query);

    /**
     * 解密用户信息
     * @param query
     * @return
     */
    UserInfo deCodeWxUserInfo(WeChatGetMobileQuery query);

    /**
     * 更新用户信息
     * @param query
     * @return
     */
    UserInfo updateUserInfo(UpdateUserInfoQuery query);
}
