package com.aiup.service.service.impl;

import com.aiup.service.entity.UserLoginLog;
import com.aiup.service.dao.UserLoginLogDao;
import com.aiup.service.service.UserLoginLogService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * 用户登录日志(UserLoginLog)表服务实现类
 *
 * @author makejava
 * @since 2023-08-19 22:39:44
 */
@Service("userLoginLogService")
public class UserLoginLogServiceImpl implements UserLoginLogService {
    @Resource
    private UserLoginLogDao userLoginLogDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserLoginLog queryById(Long id) {
        return this.userLoginLogDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userLoginLog 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserLoginLog> queryByPage(UserLoginLog userLoginLog, PageRequest pageRequest) {
        long total = this.userLoginLogDao.count(userLoginLog);
        return new PageImpl<>(this.userLoginLogDao.queryAllByLimit(userLoginLog, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userLoginLog 实例对象
     * @return 实例对象
     */
    @Override
    public UserLoginLog insert(UserLoginLog userLoginLog) {
        this.userLoginLogDao.insert(userLoginLog);
        return userLoginLog;
    }

    /**
     * 修改数据
     *
     * @param userLoginLog 实例对象
     * @return 实例对象
     */
    @Override
    public UserLoginLog update(UserLoginLog userLoginLog) {
        this.userLoginLogDao.update(userLoginLog);
        return this.queryById(userLoginLog.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Long id) {
        return this.userLoginLogDao.deleteById(id) > 0;
    }
}
