package com.aiup.service.service.impl;

import com.aiup.service.entity.UserNotesCnt;
import com.aiup.service.dao.UserNotesCntDao;
import com.aiup.service.service.UserNotesCntService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * 用户内容使用次数(UserNotesCnt)表服务实现类
 *
 * @author makejava
 * @since 2023-08-18 12:57:02
 */
@Service("userNotesCntService")
public class UserNotesCntServiceImpl implements UserNotesCntService {
    @Resource
    private UserNotesCntDao userNotesCntDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserNotesCnt queryById(Integer id) {
        return this.userNotesCntDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userNotesCnt 筛选条件
     * @param pageRequest  分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserNotesCnt> queryByPage(UserNotesCnt userNotesCnt, PageRequest pageRequest) {
        long total = this.userNotesCntDao.count(userNotesCnt);
        return new PageImpl<>(this.userNotesCntDao.queryAllByLimit(userNotesCnt, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userNotesCnt 实例对象
     * @return 实例对象
     */
    @Override
    public UserNotesCnt insert(UserNotesCnt userNotesCnt) {
        this.userNotesCntDao.insert(userNotesCnt);
        return userNotesCnt;
    }

    /**
     * 修改数据
     *
     * @param userNotesCnt 实例对象
     * @return 实例对象
     */
    @Override
    public UserNotesCnt update(UserNotesCnt userNotesCnt) {
        this.userNotesCntDao.update(userNotesCnt);
        return this.queryById(userNotesCnt.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.userNotesCntDao.deleteById(id) > 0;
    }
}
