/*
 * Decompiled with CFR 0.152.
 */
package com.aiup.service.config.exception;

import com.aiup.service.config.exception.BaseException;
import com.aiup.service.config.exception.PageException;
import com.aiup.service.domain.R;
import com.aiup.service.domain.exception.CommonException;
import com.aiup.service.utils.StringUtils;
import java.io.BufferedReader;
import javax.security.auth.login.AccountExpiredException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={CommonException.class})
    @ResponseBody
    public R businessException(CommonException e) {
        R result = R.error();
        if (StringUtils.isNotEmpty(e.getMessage())) {
            result.setDescription(e.getMessage());
        }
        if (e.getCode() > 0) {
            result.setErrorCode(String.valueOf(e.getCode()));
        }
        result.setRetValue(e.getEntity());
        return result;
    }

    @ExceptionHandler(value={PageException.class})
    public String PageException(PageException e) {
        if (e.getPage() != null) {
            return e.getPage();
        }
        return "error";
    }

    @ExceptionHandler(value={AccountExpiredException.class})
    @ResponseBody
    public R handleAccountExpiredException(AccountExpiredException e) {
        log.warn(e.getMessage(), e);
        return R.error(e.getMessage());
    }

    @ExceptionHandler(value={BaseException.class})
    @ResponseBody
    public R baseException(BaseException e) {
        log.warn(e.getMessage(), e);
        return R.error(e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public R handleException(HttpServletRequest request, Exception e) {
        String params = null;
        String method = request.getMethod();
        params = request.getQueryString();
        String err = String.format("Refer:%s, Url:%s, method:%s,params:%s", request.getHeader("referer"), request.getRequestURL().toString(), method, params);
        log.error("\u7edf\u4e00\u5f02\u5e38\u6355\u83b7\u4fe1\u606f\uff1a" + err, e);
        return R.error("\u7cfb\u7edf\u5f02\u5e38", (Object)"\u63a5\u53e3\u5f02\u5e38");
    }

    private String getBody(HttpServletRequest request) {
        try {
            BufferedReader reader = request.getReader();
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                line = reader.readLine();
            }
            reader.close();
            String reqBody = builder.toString();
            return reqBody;
        }
        catch (Exception ep) {
            this.logger.error(ep.toString());
            return null;
        }
    }

    @Override
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body2, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)ex;
            return new ResponseEntity<Object>(R.error(exception.getBindingResult().getAllErrors().get(0).getDefaultMessage()), HttpStatus.OK);
        }
        if (ex instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException exception = (MethodArgumentTypeMismatchException)ex;
            log.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff0c\u65b9\u6cd5\uff1a" + exception.getParameter().getMethod().getName() + "\uff0c\u53c2\u6570\uff1a" + exception.getName() + ",\u4fe1\u606f\uff1a" + exception.getLocalizedMessage());
            return new ResponseEntity<Object>(R.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25,\u53c2\u6570\uff1a" + exception.getName()), HttpStatus.OK);
        }
        return new ResponseEntity<Object>(R.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25"), HttpStatus.OK);
    }
}

