/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock.handler;

import com.alibaba.druid.mock.MockPreparedStatement;
import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.mock.MockResultSetMetaData;
import com.alibaba.druid.mock.MockStatementBase;
import com.alibaba.druid.mock.handler.MockExecuteHandler;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.util.jdbc.ResultSetMetaDataBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class MySqlMockExecuteHandlerImpl
implements MockExecuteHandler {
    @Override
    public ResultSet executeQuery(MockStatementBase statement, String sql) throws SQLException {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        List<SQLStatement> stmtList = parser.parseStatementList();
        if (stmtList.size() > 1) {
            throw new SQLException("not support multi-statment. " + sql);
        }
        if (stmtList.size() == 0) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        if (stmt instanceof CobarShowStatus) {
            return this.showStatus(statement);
        }
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLSelect select = ((SQLSelectStatement)stmt).getSelect();
        SQLSelectQuery query2 = select.getQuery();
        if (query2 instanceof SQLSelectQueryBlock) {
            return this.executeQuery(statement, (SQLSelectQueryBlock)query2);
        }
        throw new SQLException("TODO");
    }

    public ResultSet executeQuery(MockStatementBase statement, SQLSelectQueryBlock query2) throws SQLException {
        SQLTableSource from = query2.getFrom();
        if (from instanceof SQLExprTableSource) {
            String ident;
            SQLExpr expr = ((SQLExprTableSource)from).getExpr();
            if (expr instanceof SQLIdentifierExpr && "dual".equalsIgnoreCase(ident = ((SQLIdentifierExpr)expr).getName())) {
                return this.executeQueryFromDual(statement, query2);
            }
            throw new SQLException("TODO : " + query2);
        }
        if (from == null) {
            return this.executeQueryFromDual(statement, query2);
        }
        throw new SQLException("TODO");
    }

    public ResultSet showStatus(MockStatementBase statement) throws SQLException {
        MockResultSet rs = new MockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[]{"on"};
        ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
        column.setColumnType(-9);
        metaData.getColumns().add(column);
        rs.getRows().add(row);
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQueryFromDual(MockStatementBase statement, SQLSelectQueryBlock query2) throws SQLException {
        MockResultSet rs = statement.getConnection().getDriver().createMockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[query2.getSelectList().size()];
        int size = query2.getSelectList().size();
        for (int i2 = 0; i2 < size; ++i2) {
            ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
            SQLSelectItem item = query2.getSelectList().get(i2);
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLIntegerExpr) {
                row[i2] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(4);
            } else if (expr instanceof SQLNumberExpr) {
                row[i2] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(3);
            } else if (expr instanceof SQLCharExpr) {
                row[i2] = ((SQLCharExpr)expr).getText();
                column.setColumnType(12);
            } else if (expr instanceof SQLNCharExpr) {
                row[i2] = ((SQLNCharExpr)expr).getText();
                column.setColumnType(-9);
            } else if (expr instanceof SQLBooleanExpr) {
                row[i2] = ((SQLBooleanExpr)expr).getBooleanValue();
                column.setColumnType(-9);
            } else if (expr instanceof SQLNullExpr) {
                row[i2] = null;
            } else if (expr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
                if (!"NOW".equalsIgnoreCase(methodInvokeExpr.getMethodName())) throw new SQLException("TODO");
                row[i2] = new Timestamp(System.currentTimeMillis());
            } else if (expr instanceof SQLVariantRefExpr) {
                SQLVariantRefExpr varExpr = (SQLVariantRefExpr)expr;
                int varIndex = varExpr.getIndex();
                if (statement instanceof MockPreparedStatement) {
                    MockPreparedStatement mockPstmt = (MockPreparedStatement)statement;
                    row[i2] = mockPstmt.getParameters().get(varIndex);
                } else {
                    row[i2] = null;
                }
            } else {
                row[i2] = null;
            }
            metaData.getColumns().add(column);
        }
        rs.getRows().add(row);
        return rs;
    }
}

