/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class DruidDataSourceFactory
implements ObjectFactory {
    private static final Log LOG = LogFactory.getLog(DruidDataSourceFactory.class);
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    public static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    public static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    public static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    public static final String PROP_DEFAULTCATALOG = "defaultCatalog";
    public static final String PROP_DRIVERCLASSNAME = "driverClassName";
    public static final String PROP_MAXACTIVE = "maxActive";
    public static final String PROP_MAXIDLE = "maxIdle";
    public static final String PROP_MINIDLE = "minIdle";
    public static final String PROP_INITIALSIZE = "initialSize";
    public static final String PROP_MAXWAIT = "maxWait";
    public static final String PROP_TESTONBORROW = "testOnBorrow";
    public static final String PROP_TESTONRETURN = "testOnReturn";
    public static final String PROP_TIMEBETWEENEVICTIONRUNSMILLIS = "timeBetweenEvictionRunsMillis";
    public static final String PROP_NUMTESTSPEREVICTIONRUN = "numTestsPerEvictionRun";
    public static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    public static final String PROP_PHY_TIMEOUT_MILLIS = "phyTimeoutMillis";
    public static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_VALIDATIONQUERY = "validationQuery";
    public static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    public static final String PROP_INITCONNECTIONSQLS = "initConnectionSqls";
    public static final String PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED = "accessToUnderlyingConnectionAllowed";
    public static final String PROP_REMOVEABANDONED = "removeAbandoned";
    public static final String PROP_REMOVEABANDONEDTIMEOUT = "removeAbandonedTimeout";
    public static final String PROP_LOGABANDONED = "logAbandoned";
    public static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    public static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    public static final String PROP_CONNECTIONPROPERTIES = "connectionProperties";
    public static final String PROP_FILTERS = "filters";
    public static final String PROP_EXCEPTION_SORTER = "exceptionSorter";
    public static final String PROP_EXCEPTION_SORTER_CLASS_NAME = "exception-sorter-class-name";
    public static final String PROP_NAME = "name";
    public static final String PROP_INIT = "init";
    private static final String[] ALL_PROPERTIES = new String[]{"defaultAutoCommit", "defaultReadOnly", "defaultTransactionIsolation", "defaultCatalog", "driverClassName", "maxActive", "maxIdle", "minIdle", "initialSize", "maxWait", "testOnBorrow", "testOnReturn", "timeBetweenEvictionRunsMillis", "numTestsPerEvictionRun", "minEvictableIdleTimeMillis", "testWhileIdle", "password", "filters", "url", "username", "validationQuery", "validationQueryTimeout", "initConnectionSqls", "accessToUnderlyingConnectionAllowed", "removeAbandoned", "removeAbandonedTimeout", "logAbandoned", "poolPreparedStatements", "maxOpenPreparedStatements", "connectionProperties", "exceptionSorter", "exception-sorter-class-name", "init", "name", "druid.timeBetweenLogStatsMillis", "druid.stat.sql.MaxSize", "druid.clearFiltersEnable", "druid.resetStatEnable", "druid.notFullTimeoutRetryCount", "druid.maxWaitThreadCount", "druid.failFast", "druid.phyTimeoutMillis", "druid.wall.tenantColumn", "druid.wall.updateAllow", "druid.wall.deleteAllow", "druid.wall.insertAllow", "druid.wall.selelctAllow", "druid.wall.multiStatementAllow"};

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment2) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName()) && !"com.alibaba.druid.pool.DruidDataSource".equals(ref.getClassName())) {
            return null;
        }
        Properties properties = new Properties();
        for (int i2 = 0; i2 < ALL_PROPERTIES.length; ++i2) {
            String propertyName = ALL_PROPERTIES[i2];
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.setProperty(propertyName, propertyValue);
        }
        return this.createDataSourceInternal(properties);
    }

    protected DataSource createDataSourceInternal(Properties properties) throws Exception {
        DruidDataSource dataSource = new DruidDataSource();
        DruidDataSourceFactory.config(dataSource, properties);
        return dataSource;
    }

    public static DataSource createDataSource(Properties properties) throws Exception {
        return DruidDataSourceFactory.createDataSource((Map)properties);
    }

    public static DataSource createDataSource(Map properties) throws Exception {
        DruidDataSource dataSource = new DruidDataSource();
        DruidDataSourceFactory.config(dataSource, properties);
        return dataSource;
    }

    public static void config(DruidDataSource dataSource, Map<?, ?> properties) throws SQLException {
        String value = null;
        value = (String)properties.get(PROP_DEFAULTAUTOCOMMIT);
        if (value != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_DEFAULTREADONLY)) != null) {
            dataSource.setDefaultReadOnly((boolean)Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_DEFAULTTRANSACTIONISOLATION)) != null) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOG.error("Could not parse defaultTransactionIsolation: " + value);
                    LOG.error("WARNING: defaultTransactionIsolation not set");
                    LOG.error("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((value = (String)properties.get(PROP_DEFAULTCATALOG)) != null) {
            dataSource.setDefaultCatalog(value);
        }
        if ((value = (String)properties.get(PROP_DRIVERCLASSNAME)) != null) {
            dataSource.setDriverClassName(value);
        }
        if ((value = (String)properties.get(PROP_MAXACTIVE)) != null) {
            dataSource.setMaxActive(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_MAXIDLE)) != null) {
            dataSource.setMaxIdle(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_MINIDLE)) != null) {
            dataSource.setMinIdle(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_INITIALSIZE)) != null) {
            dataSource.setInitialSize(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_MAXWAIT)) != null) {
            dataSource.setMaxWait(Long.parseLong(value));
        }
        if ((value = (String)properties.get(PROP_TESTONBORROW)) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_TESTONRETURN)) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_TIMEBETWEENEVICTIONRUNSMILLIS)) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(value));
        }
        if ((value = (String)properties.get(PROP_NUMTESTSPEREVICTIONRUN)) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(value));
        }
        if ((value = (String)properties.get(PROP_PHY_TIMEOUT_MILLIS)) != null) {
            dataSource.setPhyTimeoutMillis(Long.parseLong(value));
        }
        if ((value = (String)properties.get(PROP_TESTWHILEIDLE)) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_PASSWORD)) != null) {
            dataSource.setPassword(value);
        }
        if ((value = (String)properties.get(PROP_URL)) != null) {
            dataSource.setUrl(value);
        }
        if ((value = (String)properties.get(PROP_USERNAME)) != null) {
            dataSource.setUsername(value);
        }
        if ((value = (String)properties.get(PROP_VALIDATIONQUERY)) != null) {
            dataSource.setValidationQuery(value);
        }
        if ((value = (String)properties.get(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            dataSource.setValidationQueryTimeout(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_ACCESSTOUNDERLYINGCONNECTIONALLOWED)) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_REMOVEABANDONED)) != null) {
            dataSource.setRemoveAbandoned(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_REMOVEABANDONEDTIMEOUT)) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(value));
        }
        if ((value = (String)properties.get(PROP_LOGABANDONED)) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(value));
        }
        if ((value = (String)properties.get(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            boolean poolPreparedStatements = Boolean.valueOf(value);
            dataSource.setPoolPreparedStatements(poolPreparedStatements);
            if (poolPreparedStatements && (value = (String)properties.get(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
                dataSource.setMaxOpenPreparedStatements(Integer.parseInt(value));
            }
        }
        if ((value = (String)properties.get(PROP_FILTERS)) != null) {
            dataSource.setFilters(value);
        }
        if ((value = (String)properties.get(PROP_EXCEPTION_SORTER)) != null) {
            dataSource.setExceptionSorter(value);
        }
        if ((value = (String)properties.get(PROP_EXCEPTION_SORTER_CLASS_NAME)) != null) {
            dataSource.setExceptionSorter(value);
        }
        if ((value = (String)properties.get(PROP_INITCONNECTIONSQLS)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ";");
            dataSource.setConnectionInitSqls(Collections.list(tokenizer));
        }
        if ((value = (String)properties.get(PROP_CONNECTIONPROPERTIES)) != null) {
            dataSource.setConnectionProperties(value);
        }
        Properties dataSourceProperties = null;
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!entryKey.startsWith("druid.")) continue;
            if (dataSourceProperties == null) {
                dataSourceProperties = new Properties();
            }
            String entryValue = (String)entry.getValue();
            dataSourceProperties.put(entryKey, entryValue);
        }
        if (dataSourceProperties != null) {
            dataSource.configFromPropety(dataSourceProperties);
        }
        if ("true".equals(value = (String)properties.get(PROP_INIT))) {
            dataSource.init();
        }
    }
}

