/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class SQLBinaryExpr
extends SQLExprImpl
implements SQLLiteralExpr,
SQLValuableExpr {
    private String text;
    private transient Number val;

    public SQLBinaryExpr() {
    }

    public SQLBinaryExpr(String value) {
        this.text = value;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Number getValue() {
        if (this.text == null) {
            return null;
        }
        if (this.val == null) {
            long[] words = new long[this.text.length() / 64 + 1];
            for (int i2 = this.text.length() - 1; i2 >= 0; --i2) {
                int wordIndex;
                char ch = this.text.charAt(i2);
                if (ch != '1') continue;
                int n = wordIndex = i2 >> 6;
                words[n] = words[n] | 1L << this.text.length() - 1 - i2;
            }
            if (words.length == 1) {
                this.val = words[0];
            } else {
                byte[] bytes = new byte[words.length * 8];
                for (int i3 = 0; i3 < words.length; ++i3) {
                    Utils.putLong(bytes, (words.length - 1 - i3) * 8, words[i3]);
                }
                this.val = new BigInteger(bytes);
            }
        }
        return this.val;
    }

    public void setValue(String value) {
        this.text = value;
    }

    @Override
    public void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append("b'");
            buf.append(this.text);
            buf.append('\'');
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public SQLBinaryExpr clone() {
        return new SQLBinaryExpr(this.text);
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLBinaryExpr other = (SQLBinaryExpr)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

